﻿<?xml version="1.0" encoding="utf-8"?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" 
				xmlns:msxsl="urn:schemas-microsoft-com:xslt" 
				xmlns:websoft="http://www.websoft.ru" 
				version="1.0">
<!--
'*	002_popup#.xsl
'*	Copyright (c) Websoft, 2006.  All rights reserved.
-->
<xsl:output method="xml" encoding="utf-8" omit-xml-declaration="yes"/>
<xsl:param name="imagesFolder"></xsl:param>
<!-- profiles definition start -->
<xsl:variable name="profiles">
	<popup_close>
		<src>popup_close.gif</src>
		<width>20</width>
		<height>19</height>
		<alt>Close window</alt>
		<style>cursor:pointer;</style>
	</popup_close>
	<corner_top_left_header>
		<src>popup_tl_h.gif</src>
		<width>13</width>
		<height>13</height>
	</corner_top_left_header>
	<corner_top_right_header>
		<src>popup_tr_h.gif</src>
		<width>13</width>
		<height>13</height>
	</corner_top_right_header>
	<corner_bottom_left>
		<src>popup_bl.gif</src>
		<width>13</width>
		<height>13</height>
	</corner_bottom_left>
	<corner_bottom_right>
		<src>popup_br.gif</src>
		<width>13</width>
		<height>13</height>
	</corner_bottom_right>
	<bottom_left_edge_header>
		<src>popup_h_b_l.gif</src>
		<width>13</width>
		<height>6</height>
	</bottom_left_edge_header>
	<bottom_right_edge_header>
		<src>popup_h_b_r.gif</src>
		<width>13</width>
		<height>6</height>
	</bottom_right_edge_header>
	<background_top_edge_header><src>popup_bg_t_h.gif</src></background_top_edge_header>	
	<background_header><src>popup_bg_h.gif</src></background_header>	
	<background_left_edge_header><src>popup_h_l.gif</src></background_left_edge_header>
	<background_right_edge_header><src>popup_h_r.gif</src></background_right_edge_header>
	<background_left_edge><src>popup_bg_l.gif</src></background_left_edge>
	<background_right_edge><src>popup_bg_r.gif</src></background_right_edge>
	<background_bottom_edge><src>popup_bg_b.gif</src></background_bottom_edge>
	<background_header_bottom_edge><src>popup_bg_h_b.gif</src></background_header_bottom_edge>
	<header_style>font-family: Arial; color: #000000; font-weight: bold; font-size:16px; cursor:default; padding-left:5px; padding-right:5px; padding-bottom:3px;</header_style>
	<header_td_style>padding-left:20px;</header_td_style>
	<bgcolor>#FFFFFF</bgcolor>
</xsl:variable>
<!-- profiles definition end -->

<!--		 Template: Root    --> 

<xsl:template match="/">
	<xsl:apply-templates select="params"/>
</xsl:template>

<!--		 Template: Params    --> 

<xsl:template match="params">
<xsl:variable name="cur_profile" select="popup_profile"/>
<xsl:variable name="show_button_close" select="button_close"/>
<xsl:variable name="click_hide" select="onclick_hide"/>
<xsl:variable name="top_height">13</xsl:variable>
<xsl:variable name="header_bottom_height">6</xsl:variable>
<xsl:variable name="popup_bottom_height">13</xsl:variable>
<xsl:variable name="cur_folder"><xsl:value-of select="$imagesFolder"/><xsl:value-of select="$cur_profile"/>\</xsl:variable>

<table width="100%" border="0" cellpadding="0" cellspacing="0">
  <tr>
  	<xsl:attribute name="height"><xsl:value-of select="$top_height"/></xsl:attribute>
    <td align="right" valign="bottom">
		<xsl:attribute name="width"><xsl:value-of select="msxsl:node-set($profiles)/corner_top_left_header/width" /></xsl:attribute>
		<xsl:attribute name="height"><xsl:value-of select="msxsl:node-set($profiles)/corner_top_left_header/height" /></xsl:attribute>
		<img>
			<xsl:attribute name="src"><xsl:value-of select="$cur_folder"/><xsl:value-of select="msxsl:node-set($profiles)/corner_top_left_header/src" /></xsl:attribute>
			<xsl:attribute name="width"><xsl:value-of select="msxsl:node-set($profiles)/corner_top_left_header/width" /></xsl:attribute>
			<xsl:attribute name="height"><xsl:value-of select="msxsl:node-set($profiles)/corner_top_left_header/height" /></xsl:attribute>
		</img>
	</td>
    <td width="100%">
		<xsl:attribute name="background"><xsl:value-of select="$cur_folder"/><xsl:value-of select="msxsl:node-set($profiles)/background_top_edge_header/src" /></xsl:attribute>
	</td>
    <td align="left" valign="bottom">
		<img>
			<xsl:attribute name="src"><xsl:value-of select="$cur_folder"/><xsl:value-of select="msxsl:node-set($profiles)/corner_top_right_header/src" /></xsl:attribute>
			<xsl:attribute name="width"><xsl:value-of select="msxsl:node-set($profiles)/corner_top_right_header/width" /></xsl:attribute>
			<xsl:attribute name="height"><xsl:value-of select="msxsl:node-set($profiles)/corner_top_right_header/height" /></xsl:attribute>
		</img>
	</td>
  </tr>
  <tr valign="top">
    <td>
		<xsl:attribute name="background"><xsl:value-of select="$cur_folder"/><xsl:value-of select="msxsl:node-set($profiles)/background_left_edge_header/src" /></xsl:attribute>
	</td>
    <td valign="middle">
		<xsl:attribute name="background"><xsl:value-of select="$cur_folder"/><xsl:value-of select="msxsl:node-set($profiles)/background_header/src" /></xsl:attribute>	
		<table width="100%"  border="0" cellspacing="0" cellpadding="0">
	 		 <tr valign="top">
	   			<td align="center" width="100%">
					<xsl:if test="$show_button_close='yes'">				 		
						<xsl:attribute name="style"><xsl:value-of select="msxsl:node-set($profiles)/header_td_style" /></xsl:attribute>
					</xsl:if>			
					<div id="popupHeader">
						<xsl:attribute name="style"><xsl:value-of select="msxsl:node-set($profiles)/header_style" /></xsl:attribute>
						<xsl:value-of select="popup_header_text" disable-output-escaping="yes"/>
					</div>						
				</td>
    			<xsl:if test="$show_button_close='yes'">
					<td valign="top">
						<img>
							<xsl:attribute name="src"><xsl:value-of select="$cur_folder"/><xsl:value-of select="msxsl:node-set($profiles)/popup_close/src" /></xsl:attribute>
							<xsl:attribute name="width"><xsl:value-of select="msxsl:node-set($profiles)/popup_close/width" /></xsl:attribute>
							<xsl:attribute name="height"><xsl:value-of select="msxsl:node-set($profiles)/popup_close/height" /></xsl:attribute>
							<xsl:attribute name="alt"><xsl:value-of select="msxsl:node-set($profiles)/popup_close/alt" /></xsl:attribute>
							<xsl:attribute name="style"><xsl:value-of select="msxsl:node-set($profiles)/popup_close/style" /></xsl:attribute>
						</img>
					</td>
				</xsl:if>			
	 		 </tr>
		</table>
	</td>
    <td>
		<xsl:attribute name="background"><xsl:value-of select="$cur_folder"/><xsl:value-of select="msxsl:node-set($profiles)/background_right_edge_header/src" /></xsl:attribute>
	</td>
  </tr>
  <tr>
    <xsl:attribute name="height"><xsl:value-of select="$header_bottom_height"/></xsl:attribute>
    <td>
		<img>
			<xsl:attribute name="src"><xsl:value-of select="$cur_folder"/><xsl:value-of select="msxsl:node-set($profiles)/bottom_left_edge_header/src" /></xsl:attribute>
			<xsl:attribute name="width"><xsl:value-of select="msxsl:node-set($profiles)/bottom_left_edge_header/width" /></xsl:attribute>
			<xsl:attribute name="height"><xsl:value-of select="msxsl:node-set($profiles)/bottom_left_edge_header/height" /></xsl:attribute>
		</img>
	</td>
	<td>
		<xsl:attribute name="background"><xsl:value-of select="$cur_folder"/><xsl:value-of select="msxsl:node-set($profiles)/background_header_bottom_edge/src" /></xsl:attribute>	
	</td>
	<td>
		<img>
			<xsl:attribute name="src"><xsl:value-of select="$cur_folder"/><xsl:value-of select="msxsl:node-set($profiles)/bottom_right_edge_header/src" /></xsl:attribute>
			<xsl:attribute name="width"><xsl:value-of select="msxsl:node-set($profiles)/bottom_right_edge_header/width" /></xsl:attribute>
			<xsl:attribute name="height"><xsl:value-of select="msxsl:node-set($profiles)/bottom_right_edge_header/height" /></xsl:attribute>
		</img>
	</td>
  </tr>
  <tr>
    <td>
		<xsl:attribute name="background"><xsl:value-of select="$cur_folder"/><xsl:value-of select="msxsl:node-set($profiles)/background_left_edge/src" /></xsl:attribute>	
	</td>
    <td>
			<xsl:attribute name="bgcolor"><xsl:value-of select="msxsl:node-set($profiles)/bgcolor" /></xsl:attribute>
			<div id="popupInnerText">
				<xsl:variable name="cur_margin" select="popup_margin" />
				<xsl:variable name="cur_style" select="concat('cursor:default; position: relative; width: 100%; margin: ',$cur_margin,'px;')" />
				<xsl:attribute name="style"><xsl:value-of select="$cur_style" /></xsl:attribute>
				<xsl:value-of select="popup_text" disable-output-escaping="yes"/>
			</div>
	</td>
    <td>
		<xsl:attribute name="background"><xsl:value-of select="$cur_folder"/><xsl:value-of select="msxsl:node-set($profiles)/background_right_edge/src"/></xsl:attribute>		
	</td>
  </tr>
  <tr>
    <xsl:attribute name="height"><xsl:value-of select="$popup_bottom_height"/></xsl:attribute>  
    <td align="right" valign="top">
		<img>
			<xsl:attribute name="src"><xsl:value-of select="$cur_folder"/><xsl:value-of select="msxsl:node-set($profiles)/corner_bottom_left/src" /></xsl:attribute>
			<xsl:attribute name="width"><xsl:value-of select="msxsl:node-set($profiles)/corner_bottom_left/width" /></xsl:attribute>
			<xsl:attribute name="height"><xsl:value-of select="msxsl:node-set($profiles)/corner_bottom_left/height" /></xsl:attribute>
		</img>
	</td>	
    <td>
		<xsl:attribute name="background"><xsl:value-of select="$cur_folder"/><xsl:value-of select="msxsl:node-set($profiles)/background_bottom_edge/src"/></xsl:attribute>			
	</td>
    <td>
		<img>
			<xsl:attribute name="src"><xsl:value-of select="$cur_folder"/><xsl:value-of select="msxsl:node-set($profiles)/corner_bottom_right/src" /></xsl:attribute>
			<xsl:attribute name="width"><xsl:value-of select="msxsl:node-set($profiles)/corner_bottom_right/width" /></xsl:attribute>
			<xsl:attribute name="height"><xsl:value-of select="msxsl:node-set($profiles)/corner_bottom_right/height" /></xsl:attribute>	
		</img>
	</td>
  </tr>
</table>

</xsl:template>

</xsl:stylesheet>
