﻿<?xml version="1.0" encoding="utf-8"?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
				xmlns:msxsl="urn:schemas-microsoft-com:xslt"
				xmlns:websoft="http://www.websoft.ru"
				version="1.0">
<!--
'*	form_005_radiogroup.xsl
'*	Copyright (c) Websoft, 2007.  All rights reserved.
-->
<xsl:output method="xml" encoding="utf-8" omit-xml-declaration="yes"/>
<xsl:param name="objectID"></xsl:param>
<!--		 Template: Root    -->
<xsl:template match="/">
	<xsl:apply-templates select="params"/>
</xsl:template>
<!--		 Template: Params    -->
<xsl:template match="params">
<xsl:variable name="cshow" select="input_showtext" />
<xsl:variable name="cleft" select="input_where_left" />
<xsl:variable name="cright" select="input_where_right" />
<table border="0" cellspacing="0">
	<xsl:attribute name="cellpadding"><xsl:value-of select="input_margin" /></xsl:attribute>
	<xsl:variable name="cur_var"><xsl:value-of select="input_id" /></xsl:variable>
	<xsl:for-each select="valuelist/item">
	<tr>
		<xsl:if test="$cshow='yes'">
			<xsl:if test="$cleft='yes'">
				<td align="right" valign="middle" width="100%">
					<xsl:value-of select="input_text" disable-output-escaping="yes"/>
				</td>
			</xsl:if>
		</xsl:if>
		<td align="center" valign="middle">
			<input type="radio" style="border: 0px solid;">
				<xsl:attribute name="onclick">var oArgs=new Object; oArgs.pid='<xsl:value-of select="$objectID"/>'; CallMethod('form_005_radiogroup','AcceptInput',oArgs); return true;</xsl:attribute>
				<xsl:attribute name="id"><xsl:value-of select="$objectID"/>_input</xsl:attribute>
				<xsl:attribute name="variable"><xsl:value-of select="../../input_id"/></xsl:attribute>
				<xsl:attribute name="name"><xsl:value-of select="$objectID"/>_input</xsl:attribute>
				<xsl:if test="input_checked='yes'">
					<xsl:attribute name="checked">checked</xsl:attribute>
				</xsl:if>
				<xsl:attribute name="value"><xsl:if test="input_value!=''"><xsl:value-of select="input_value"/></xsl:if><xsl:if test="input_value=''"><xsl:value-of select="position()"/></xsl:if></xsl:attribute>
			</input>
		</td>
		<xsl:if test="$cshow='yes'">
			<xsl:if test="$cright='yes'">
				<td align="left" valign="middle" width="100%">
					<xsl:value-of select="input_text" disable-output-escaping="yes"/>
				</td>
			</xsl:if>
		</xsl:if>
	</tr>
	</xsl:for-each>
</table>
</xsl:template>
</xsl:stylesheet>
