/*
 * Decompiled with CFR 0.152.
 */
package edu.xtec.jclic;

import edu.xtec.jclic.Activity;
import edu.xtec.jclic.Constants;
import edu.xtec.jclic.PlayStation;
import edu.xtec.jclic.PlayerHistory;
import edu.xtec.jclic.RunnableComponent;
import edu.xtec.jclic.bags.ActivityBagElement;
import edu.xtec.jclic.bags.ActivitySequenceElement;
import edu.xtec.jclic.bags.JumpInfo;
import edu.xtec.jclic.boxes.ActiveBox;
import edu.xtec.jclic.boxes.ActiveBoxContent;
import edu.xtec.jclic.boxes.BoxBase;
import edu.xtec.jclic.boxes.BoxConnector;
import edu.xtec.jclic.boxes.Counter;
import edu.xtec.jclic.clic3.Clic3;
import edu.xtec.jclic.fileSystem.FileSystem;
import edu.xtec.jclic.fileSystem.ZipFileSystem;
import edu.xtec.jclic.media.ActiveMediaBag;
import edu.xtec.jclic.media.ActiveMediaPlayer;
import edu.xtec.jclic.media.CheckMediaSystem;
import edu.xtec.jclic.media.EventSounds;
import edu.xtec.jclic.media.JavaSoundAudioBuffer;
import edu.xtec.jclic.media.MediaContent;
import edu.xtec.jclic.misc.Utils;
import edu.xtec.jclic.project.JClicProject;
import edu.xtec.jclic.report.Reporter;
import edu.xtec.jclic.skins.AboutWindow;
import edu.xtec.jclic.skins.Skin;
import edu.xtec.util.BrowserLauncher;
import edu.xtec.util.FontCheck;
import edu.xtec.util.Messages;
import edu.xtec.util.Options;
import edu.xtec.util.ResourceManager;
import edu.xtec.util.StrUtils;
import edu.xtec.util.SwingWorker;
import java.applet.Applet;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.InputStream;
import java.net.URL;
import java.util.HashMap;
import java.util.Locale;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.KeyStroke;
import javax.swing.RootPaneContainer;
import javax.swing.SwingUtilities;
import javax.swing.Timer;

public class Player
extends JPanel
implements Constants,
RunnableComponent,
PlayStation,
ActionListener {
    private static final Font CHECK_ARIAL = FontCheck.checkSystemFont((String)"Arial", (String)"arial2.ttf");
    public static final String DEFAULT_SKIN = "@default.xml";
    public static final String DEFAULT_REPORTER = "Reporter";
    public static final String[] DEFAULT_EVENT_SOUNDS = new String[]{"sounds/start.mp3", "sounds/click.mp3", "sounds/action_error.mp3", "sounds/action_ok.mp3", "sounds/finished_error.mp3", "sounds/finished_ok.mp3"};
    public static final String[] ACTION_ICONS = new String[]{"icons/prev.gif", "icons/next.gif", "icons/return.gif", "icons/reset.gif", "icons/info_small.gif", "icons/help.gif", "icons/audio_on.gif", "icons/logo_button.gif"};
    public static final String DEFAULT_APP_NAME = "JClic";
    protected Action[] actions;
    protected Messages messages;
    protected JClicProject project;
    protected Activity.Panel actPanel;
    protected PlayerHistory history;
    protected Skin skin;
    protected Skin defaultSkin;
    protected ActiveMediaBag activeMediaBag;
    protected Reporter reporter;
    protected EventSounds eventSounds;
    protected Timer timer;
    protected boolean audioEnabled = true;
    protected boolean trace = false;
    protected boolean navButtonsDisabled = false;
    protected boolean navButtonsAlways = false;
    protected String appName = "JClic";
    Timer delayedTimer;
    Action delayedAction;
    Object currentConstraints;
    int[] counterVal = new int[3];
    Cursor[] cursors = new Cursor[3];
    Options options;
    Image splashImg;
    Point bgImageOrigin = new Point();
    private SwingWorker worker = null;

    public Player(Options options) {
        this(options, null);
    }

    public Player(Options options, JClicProject jClicProject) {
        this.options = options;
        this.project = jClicProject;
        this.init();
    }

    protected void init() {
        this.options.setLookAndFeel();
        CheckMediaSystem.check(this.options, false);
        this.setPreferredSize(new Dimension(600, 400));
        this.setLayout(null);
        Utils.checkRenderingHints(this.options);
        BoxConnector.checkOptions(this.options);
        ActiveBox.checkOptions(this.options);
        int n = 0;
        while (n < 3) {
            this.counterVal[n] = 0;
            ++n;
        }
        this.setMessages();
        this.buildActions();
        this.setActionsText();
        this.history = new PlayerHistory(this);
        this.trace = this.options.getBoolean("trace");
        ActiveBox.compressImages = this.options.getBoolean("compressImages", true);
        this.audioEnabled = this.options.getBoolean("audioEnabled", true);
        this.navButtonsAlways = this.options.getBoolean("navButtonsAlways", false);
        this.setProject(this.project);
        this.activeMediaBag = new ActiveMediaBag();
        this.initSkin();
        this.setSkin(this.skin);
        this.setSystemMessage(this.getMessages().get("msg_initializing"), null);
        this.setWaitCursor(true);
        this.createCursors();
        this.createEventSounds();
        this.initTimers();
        this.splashImg = ResourceManager.getImageIcon((String)"icons/logo.png").getImage();
        if (this.skin != null && this.skin.hasMemMonitor()) {
            this.skin.setMem(Runtime.getRuntime().freeMemory());
        }
        this.setWaitCursor(false);
        this.setWindowTitle();
        this.setSystemMessage(this.getMessages().get("msg_ready"), null);
    }

    public boolean start(String string, String string2) {
        this.initReporter();
        if (string != null) {
            return this.load(string, string2);
        }
        return false;
    }

    public void activate() {
    }

    public void stop() {
        this.stopMedia(-1);
    }

    protected void finalize() throws Throwable {
        this.end();
        super.finalize();
    }

    public void end() {
        if (this.worker != null) {
            this.worker.interrupt();
            this.worker = null;
        }
        this.stopMedia();
        this.closeHelpWindow();
        if (this.actPanel != null) {
            this.actPanel.end();
            this.remove(this.actPanel);
            this.actPanel = null;
        }
        if (this.eventSounds != null) {
            this.eventSounds.close();
            this.eventSounds = null;
        }
        if (this.project != null) {
            this.project.end();
            this.project = null;
        }
        if (this.activeMediaBag != null) {
            this.activeMediaBag.removeAll();
        }
        if (this.reporter != null) {
            this.reporter.end();
            this.reporter = null;
        }
    }

    protected void createCursors() {
        try {
            Toolkit toolkit = Toolkit.getDefaultToolkit();
            this.cursors[0] = toolkit.createCustomCursor(ResourceManager.getImageIcon((String)"cursors/hand.gif").getImage(), new Point(8, 0), "hand");
            this.cursors[1] = toolkit.createCustomCursor(ResourceManager.getImageIcon((String)"cursors/ok.gif").getImage(), new Point(0, 0), "ok");
            this.cursors[2] = toolkit.createCustomCursor(ResourceManager.getImageIcon((String)"cursors/micro.gif").getImage(), new Point(15, 3), "record");
        }
        catch (Exception exception) {
            System.err.println("Error creating cursor:\n" + exception);
        }
    }

    protected void createEventSounds() {
        if (this.options.getBoolean("Mac")) {
            try {
                JavaSoundAudioBuffer.initialize();
            }
            catch (Exception exception) {
                System.err.println("Error initializing AudioBuffer lines:\n" + exception);
            }
        }
        this.eventSounds = new EventSounds(null);
        try {
            int n = 0;
            while (n < DEFAULT_EVENT_SOUNDS.length) {
                String string = DEFAULT_EVENT_SOUNDS[n];
                this.eventSounds.setDataSource(n, ResourceManager.getResourceAsByteArray((String)string), this.options);
                ++n;
            }
            this.eventSounds.realize(this.options, this.project.mediaBag);
        }
        catch (Exception exception) {
            System.err.println("Error reading system sound:\"" + exception);
        }
        EventSounds.globalEnabled = this.options.getBoolean("systemSounds", true);
    }

    protected void initReporter() {
        if (this.reporter != null) {
            this.reporter.end();
            this.reporter = null;
        }
        String string = StrUtils.secureString((Object)this.options.getString("reporter"), (String)DEFAULT_REPORTER);
        try {
            this.reporter = Reporter.getReporter(string, this.options.getString("reporterParams"), this, this.messages);
        }
        catch (Exception exception) {
            this.reporter = null;
            this.messages.showErrorWarning((Component)this, "report_err_creating", string, exception, null);
        }
    }

    protected void initSkin() {
        String string = "";
        try {
            FileSystem fileSystem = null;
            string = this.options.getString("skin");
            if (string == null) {
                string = DEFAULT_SKIN;
            } else if (!string.startsWith("@")) {
                fileSystem = new FileSystem(FileSystem.getPathPartOf(string), this);
                string = FileSystem.getFileNameOf(string);
            }
            this.defaultSkin = Skin.getSkin(string, fileSystem, this);
            this.actions[7].setEnabled(true);
            this.actions[6].setEnabled(true);
        }
        catch (Exception exception) {
            System.err.println("Error creating skin \"" + string + "\":\n" + exception);
        }
    }

    protected void initTimers() {
        this.timer = new Timer(1000, this);
        this.delayedTimer = new Timer(1000, this);
        this.delayedTimer.setRepeats(false);
        this.delayedAction = null;
    }

    public void closeHelpWindow() {
        if (this.skin != null) {
            if (this.skin.currentHelpWindow != null) {
                ((Component)this.skin.currentHelpWindow).setVisible(false);
            }
            if (this.skin.currentAboutWindow != null) {
                ((Component)this.skin.currentAboutWindow).setVisible(false);
            }
        }
    }

    protected Messages setMessages() {
        this.messages = Messages.getMessages((HashMap)this.options, (String)"messages.JClicMessages");
        this.setLocale(this.messages.getLocale());
        Locale.setDefault(this.messages.getLocale());
        this.setActionsText();
        if (this.skin != null) {
            this.skin.setLocale(this.messages.getLocale());
        }
        return this.messages;
    }

    public Component getTopComponent() {
        if (this.skin != null) {
            return this.skin;
        }
        return this;
    }

    public Skin getSkin() {
        return this.skin;
    }

    public void setSkin(Skin skin) {
        if (skin == null) {
            skin = this.defaultSkin;
        }
        if (skin != null && !skin.equals(this.skin)) {
            Container container = null;
            Object[] objectArray = null;
            if (this.skin != null) {
                objectArray = this.skin.getCurrentSettings();
                this.skin.detach();
                container = this.skin.getParent();
                container.remove(this.skin);
            }
            skin.attach(this);
            this.skin = skin;
            if (container != null) {
                RootPaneContainer rootPaneContainer = null;
                while (container != null && rootPaneContainer == null) {
                    if (container instanceof RootPaneContainer) {
                        rootPaneContainer = (RootPaneContainer)((Object)container);
                        continue;
                    }
                    container = container.getParent();
                }
                if (rootPaneContainer != null) {
                    this.addTo(rootPaneContainer, this.currentConstraints);
                    container.validate();
                    container.repaint();
                }
            }
            if (objectArray != null && this.skin != null) {
                this.skin.setCurrentSettings(objectArray);
            }
        }
    }

    public void addTo(RootPaneContainer rootPaneContainer, Object object) {
        this.currentConstraints = object;
        if (object == null) {
            rootPaneContainer.getContentPane().add(this.getTopComponent());
        } else {
            rootPaneContainer.getContentPane().add(this.getTopComponent(), object);
        }
    }

    protected FileSystem createFileSystem() {
        return new FileSystem(this);
    }

    protected void setProject(JClicProject jClicProject) {
        if (this.project != null) {
            if (this.project != jClicProject) {
                this.project.end();
            }
            this.removeActivity();
        }
        this.project = jClicProject != null ? jClicProject : new JClicProject(this, this.createFileSystem(), null);
        this.project.realize(this.eventSounds, this);
        if (this.project.skin != null) {
            this.defaultSkin = this.project.skin;
        }
    }

    public boolean load(String string, String string2) {
        this.load(string, string2, null, null);
        return true;
    }

    public void load(final String string, final String string2, final String string3, final ActivityBagElement activityBagElement) {
        if (this.worker != null) {
            return;
        }
        this.worker = new SwingWorker(){
            Activity.Panel actp;
            Exception exception = null;
            Player thisPlayer = Player.this;

            public Object construct() {
                if (Player.this.skin != null) {
                    Player.this.skin.startAnimation();
                }
                Player.this.setWaitCursor(true);
                String string6 = Clic3.pacNameToLowerCase(string);
                String string22 = Clic3.pacNameToLowerCase(string2);
                Activity activity = null;
                String string32 = string3;
                ActivityBagElement activityBagElement2 = activityBagElement;
                FileSystem fileSystem = Player.this.project.getFileSystem();
                try {
                    Object object;
                    String string4;
                    if (string6 != null) {
                        Player.this.setSystemMessage(Player.this.messages.get("msg_loading_project"), FileSystem.getFileNameOf(string6));
                        if (string22 == null) {
                            string22 = "0";
                        }
                        if (fileSystem != null && (string6 = fileSystem.getUrl(string6)).startsWith("file://")) {
                            string6 = string6.substring(7);
                        }
                        string4 = null;
                        if (string6.endsWith(".jclic.zip")) {
                            fileSystem = FileSystem.createFileSystem(string6, this.thisPlayer);
                            object = ((ZipFileSystem)fileSystem).getEntries(".jclic");
                            if (object == null) {
                                throw new Exception("File " + string6 + " does not contain any jclic project");
                            }
                            string4 = object[0];
                        } else {
                            fileSystem = new FileSystem(FileSystem.getPathPartOf(string6), this.thisPlayer);
                            string4 = FileSystem.getFileNameOf(string6);
                        }
                        if (string4.endsWith(".jclic")) {
                            object = fileSystem.getXMLDocument(string4);
                            Player.this.setProject(JClicProject.getJClicProject(object.getRootElement(), this.thisPlayer, fileSystem, string6));
                            if (Player.this.reporter != null) {
                                Player.this.reporter.newSession(Player.this.project, this.thisPlayer, Player.this.messages);
                            }
                        } else {
                            string22 = string4;
                            Player.this.setProject(new JClicProject(this.thisPlayer, fileSystem, string6));
                        }
                    }
                    if (string22 != null) {
                        int n;
                        string4 = FileSystem.stdFn(string22);
                        Player.this.setSystemMessage(Player.this.messages.get("msg_loading_project"), FileSystem.getFileNameOf(string4));
                        Player.this.navButtonsDisabled = false;
                        object = Player.this.project.activitySequence.getElementByTag(string4, true);
                        if (object == null && (n = StrUtils.getAbsIntValueOf((String)string4)) >= 0) {
                            object = Player.this.project.activitySequence.getElement(n, true);
                        }
                        if (object == null) {
                            n = Player.this.project.activitySequence.getSize() == 0 ? 1 : 0;
                            boolean bl = string4.endsWith(".pcc");
                            boolean bl2 = string4.endsWith(".pac");
                            if (bl || bl2) {
                                if (bl) {
                                    String string5 = fileSystem.root + string4;
                                    fileSystem = FileSystem.createFileSystem(string5, this.thisPlayer);
                                    if (n != 0) {
                                        Player.this.project.setFileSystem(fileSystem);
                                        Player.this.project.setFullPath(string5);
                                    } else {
                                        Player.this.setProject(new JClicProject(this.thisPlayer, fileSystem, string5));
                                    }
                                    n = 1;
                                    Clic3.readPccFile(Player.this.project);
                                    object = Player.this.project.activitySequence.getCurrentAct();
                                } else if (bl2) {
                                    Clic3.addPacToSequence(Player.this.project, string4);
                                    object = Player.this.project.activitySequence.getElementByTag(string4, true);
                                }
                                if (n != 0) {
                                    Player.this.project.setName(string4);
                                    if (Player.this.reporter != null) {
                                        Player.this.reporter.newSession(Player.this.project, this.thisPlayer, Player.this.messages);
                                    }
                                }
                            }
                        }
                        if (object != null) {
                            if (Player.this.reporter != null) {
                                Player.this.reporter.newSequence((ActivitySequenceElement)object);
                            }
                            string32 = object.getActivityName();
                        }
                    }
                    if (string32 != null) {
                        string4 = FileSystem.stdFn(string32);
                        activityBagElement2 = Player.this.project.activityBag.getElement(string4);
                    }
                    if (activityBagElement2 != null) {
                        Player.this.setSystemMessage(Player.this.messages.get("msg_loading_activity"), activityBagElement2.getName());
                        activity = Activity.getActivity(activityBagElement2.getData(), Player.this.project);
                    }
                    if (activity != null) {
                        Player.this.setSystemMessage(null, Player.this.messages.get("msg_preparing_media"));
                        if (Player.this.project.settings.eventSounds != null) {
                            activity.eventSounds.setParent(Player.this.project.settings.eventSounds);
                        }
                        Player.this.project.mediaBag.waitForAllImages();
                        activity.prepareMedia(this.thisPlayer);
                        Player.this.activeMediaBag.realizeAll();
                        Player.this.project.activitySequence.checkCurrentActivity(activityBagElement2.getName());
                        Player.this.setSystemMessage(null, Player.this.messages.get("msg_initializing"));
                        this.actp = activity.getActivityPanel(this.thisPlayer);
                        this.actp.buildVisualComponents();
                    }
                }
                catch (Exception exception) {
                    this.exception = exception;
                    if (Player.this.project == null) {
                        Player.this.setProject(null);
                    }
                    activity = null;
                    this.actp = null;
                }
                return this.actp;
            }

            public void finished() {
                Player.this.setWaitCursor(false);
                if (Player.this.actPanel != null) {
                    Player.this.actPanel.end();
                    Player.this.remove(Player.this.actPanel);
                    Player.this.actPanel = null;
                    Player.this.setCounterValue(2, 0);
                }
                if (this.actp != null && Player.this.worker != null) {
                    Player.this.setBackgroundSettings(this.actp.getActivity());
                    Player.this.actPanel = this.actp;
                    Player.this.add(Player.this.actPanel);
                    Player.this.actPanel.setCursor(null);
                    Player.this.splashImg = null;
                    if (Player.this.skin != null) {
                        Player.this.skin.resetAllCounters(false);
                    }
                    if (this.actp.skin != null) {
                        Player.this.setSkin(this.actp.skin);
                    } else if (Player.this.project.skin != null) {
                        Player.this.setSkin(Player.this.project.skin);
                    } else {
                        Player.this.setSkin(Player.this.defaultSkin);
                    }
                    if (Player.this.skin != null) {
                        int n;
                        boolean bl;
                        boolean bl2 = bl = Player.this.history.storedElementsCount() > 0;
                        int n2 = Player.this.navButtonsAlways ? 3 : (n = Player.this.navButtonsDisabled ? 0 : Player.this.project.activitySequence.getNavButtonsFlag());
                        if (Player.this.actions != null) {
                            Player.this.actions[1].setEnabled((n & 1) != 0 && Player.this.project.activitySequence.hasNextAct(bl));
                            Player.this.actions[0].setEnabled((n & 2) != 0 && Player.this.project.activitySequence.hasPrevAct(bl));
                            Player.this.actions[2].setEnabled(Player.this.history.storedElementsCount() > 0);
                            Player.this.actions[5].setEnabled(this.actp.getActivity().helpWindowAllowed());
                            Player.this.actions[3].setEnabled(this.actp.getActivity().canReinit());
                            Player.this.actions[4].setEnabled(this.actp.getActivity().hasInfo());
                        }
                    }
                    Player.this.setSystemMessage(Player.this.messages.get("msg_ready"), null);
                    Player.this.initActivity();
                } else if (this.exception != null) {
                    String string4 = null;
                    Vector<String> vector = new Vector<String>();
                    if (string != null) {
                        vector.add(string);
                        string4 = "msg_error_loading_project";
                    }
                    if (string2 != null) {
                        vector.add(string2);
                        if (string4 == null) {
                            string4 = "msg_error_loading_sequence";
                        }
                    }
                    if (string3 != null) {
                        vector.add(string3);
                        if (string4 == null) {
                            string4 = "msg_error_loading_activity";
                        }
                    }
                    if (activityBagElement != null) {
                        vector.add(activityBagElement.getName());
                        if (string4 == null) {
                            string4 = "msg_error_loading_activity";
                        }
                    }
                    if (string4 == null) {
                        string4 = "ERROR";
                    }
                    Player.this.setSystemMessage(Player.this.messages.get(string4), null);
                    Player.this.messages.showErrorWarning((Component)this.thisPlayer, "err_reading_data", vector, this.exception, null);
                    Player.this.validate();
                } else {
                    Player.this.setSystemMessage(Player.this.messages.get("msg_ready"), null);
                }
                Player.this.setWindowTitle();
                Player.this.worker = null;
                if (Player.this.skin != null) {
                    Player.this.skin.stopAnimation();
                    Player.this.skin.setEnabled(true);
                }
                Player.this.setEnabled(true);
            }
        };
        this.forceFinishActivity();
        if (this.skin != null) {
            this.skin.setEnabled(false);
        }
        this.setEnabled(false);
        this.worker.start();
    }

    public void forceFinishActivity() {
        if (this.timer != null) {
            this.timer.stop();
            this.delayedTimer.stop();
            if (this.actPanel != null) {
                this.closeHelpWindow();
                this.actPanel.forceFinishActivity();
                this.stopMedia();
                this.activeMediaBag.removeAll();
                if (Runtime.getRuntime().freeMemory() < 0x100000L) {
                    if (this.trace) {
                        System.out.println(">>> LOW MEMORY! cleaning...");
                    }
                    this.project.mediaBag.clearData();
                    System.runFinalization();
                    System.gc();
                }
            }
            this.setCursor(null);
        }
    }

    public void removeActivity() {
        this.forceFinishActivity();
        if (this.actPanel != null) {
            this.actPanel.end();
            this.remove(this.actPanel);
            this.setMsg(null);
            this.setBackgroundSettings(null);
            this.actPanel = null;
        }
    }

    public void initActivity() {
        this.setWaitCursor(true);
        this.setCursor(null);
        this.timer.stop();
        this.delayedTimer.stop();
        this.setCounterValue(2, 0);
        this.stopMedia();
        try {
            block6: {
                try {
                    if (this.actPanel != null) {
                        this.actPanel.initActivity();
                        this.timer.start();
                        if (!this.actPanel.getActivity().mustPauseSequence()) {
                            this.startAutoPassTimer();
                        }
                        this.setSystemMessage(this.messages.get("msg_activity_running"), null);
                    }
                    if (this.skin == null) break block6;
                    this.skin.setMem(Runtime.getRuntime().freeMemory());
                }
                catch (Exception exception) {
                    this.messages.showErrorWarning((Component)this, "msg_error_starting_activity", exception);
                    this.setSystemMessage(this.messages.get("ERROR"), null);
                    Object var3_2 = null;
                    this.setWaitCursor(false);
                    this.validate();
                    this.repaint();
                }
            }
            Object var3_1 = null;
            this.setWaitCursor(false);
            this.validate();
            this.repaint();
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            this.setWaitCursor(false);
            this.validate();
            this.repaint();
            throw throwable;
        }
    }

    public void startActivity(Activity.Panel panel) {
        this.setWaitCursor(true);
        try {
            try {
                panel.startActivity();
            }
            catch (Exception exception) {
                this.messages.showErrorWarning((Component)this, "msg_error_starting_activity", exception);
                this.setSystemMessage(this.messages.get("ERROR"), null);
                Object var4_3 = null;
                this.setWaitCursor(false);
            }
            Object var4_2 = null;
            this.setWaitCursor(false);
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            this.setWaitCursor(false);
            throw throwable;
        }
    }

    public void doLayout() {
        if (this.trace) {
            System.out.println(">>> layout!");
        }
        if (this.actPanel != null) {
            BoxBase.resetAllFonts();
            Rectangle rectangle = this.getBounds();
            Rectangle rectangle2 = new Rectangle(6, 6, rectangle.width - 12, rectangle.height - 12);
            if (this.actPanel.bgImage != null && !this.actPanel.getActivity().tiledBgImg) {
                this.bgImageOrigin.x = (this.getWidth() - this.actPanel.bgImage.getWidth(this)) / 2;
                this.bgImageOrigin.y = (this.getHeight() - this.actPanel.bgImage.getHeight(this)) / 2;
                if (this.actPanel.getActivity().absolutePositioned) {
                    rectangle2.x = this.bgImageOrigin.x;
                    rectangle2.y = this.bgImageOrigin.y;
                    rectangle2.width -= this.bgImageOrigin.x - 6;
                    rectangle2.height -= this.bgImageOrigin.y - 6;
                    rectangle2.width = Math.min(rectangle2.width, rectangle.width);
                    rectangle2.height = Math.min(rectangle2.height, rectangle.height);
                }
            }
            this.actPanel.fitTo(rectangle2, rectangle);
        }
    }

    public void paintComponent(Graphics graphics) {
        Graphics2D graphics2D = (Graphics2D)graphics;
        if (this.splashImg != null) {
            graphics2D.setColor(Constants.BG_COLOR);
            graphics2D.fill(graphics2D.getClip());
            int n = this.splashImg.getWidth(this);
            int n2 = this.splashImg.getHeight(this);
            int n3 = (this.getBounds().width - n) / 2;
            int n4 = (this.getBounds().height - n2) / 2;
            graphics2D.drawImage(this.splashImg, n3, n4, this);
            return;
        }
        Rectangle rectangle = new Rectangle(0, 0, this.getWidth(), this.getHeight());
        if (this.actPanel == null || this.actPanel.getActivity().bgGradient == null || this.actPanel.getActivity().bgGradient.hasTransparency()) {
            super.paintComponent(graphics);
        }
        if (this.actPanel != null && (this.actPanel.getActivity().bgGradient != null || this.actPanel.bgImage != null)) {
            RenderingHints renderingHints = graphics2D.getRenderingHints();
            graphics2D.setRenderingHints(Constants.DEFAULT_RENDERING_HINTS);
            if (this.actPanel.getActivity().bgGradient != null) {
                this.actPanel.getActivity().bgGradient.paint(graphics2D, rectangle);
            }
            if (this.actPanel.bgImage != null) {
                Rectangle rectangle2 = new Rectangle(0, 0, this.actPanel.bgImage.getWidth(this), this.actPanel.bgImage.getHeight(this));
                Rectangle rectangle3 = graphics2D.getClipBounds();
                if (!this.actPanel.getActivity().tiledBgImg) {
                    rectangle2.setLocation(this.bgImageOrigin);
                    if (rectangle2.intersects(rectangle3)) {
                        graphics2D.drawImage(this.actPanel.bgImage, this.bgImageOrigin.x, this.bgImageOrigin.y, this);
                    }
                } else {
                    Utils.tileImage(graphics2D, this.actPanel.bgImage, rectangle, rectangle2, this);
                }
            }
            graphics2D.setRenderingHints(renderingHints);
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        String string = null;
        if (this.timer != null && actionEvent.getSource().equals(this.timer)) {
            this.incCounterValue(2);
            if (this.actPanel != null && this.actPanel.getActivity().maxTime > 0 && this.actPanel.isPlaying() && this.counterVal[2] >= this.actPanel.getActivity().maxTime) {
                this.actPanel.finishActivity(false);
            }
            return;
        }
        if (this.delayedTimer != null && actionEvent.getSource().equals(this.delayedTimer)) {
            this.delayedTimer.stop();
            if (this.delayedAction != null) {
                this.delayedAction.actionPerformed(null);
            }
        }
        if (string == null && (string = actionEvent.getActionCommand()) == null) {
            return;
        }
        this.delayedAction = null;
        this.processActionEvent(string);
    }

    protected int getNumActions() {
        return 8;
    }

    protected void buildActions() {
        this.actions = new Action[this.getNumActions()];
        this.actions[1] = new AbstractAction(){

            public void actionPerformed(ActionEvent actionEvent) {
                Player.this.history.processJump(Player.this.project.activitySequence.getJump(false, Player.this.reporter), false);
            }
        };
        this.actions[0] = new AbstractAction(){

            public void actionPerformed(ActionEvent actionEvent) {
                Player.this.history.processJump(Player.this.project.activitySequence.getJump(true, Player.this.reporter), false);
            }
        };
        this.actions[2] = new AbstractAction(){

            public void actionPerformed(ActionEvent actionEvent) {
                Player.this.history.pop();
            }
        };
        this.actions[3] = new AbstractAction(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (Player.this.actPanel != null && Player.this.actPanel.getActivity().canReinit()) {
                    Player.this.initActivity();
                }
            }
        };
        this.actions[5] = new AbstractAction(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (Player.this.actPanel != null) {
                    Player.this.actPanel.showHelp();
                }
            }
        };
        this.actions[4] = new AbstractAction(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (Player.this.actPanel != null && Player.this.actPanel.getActivity().hasInfo()) {
                    if (Player.this.actPanel.getActivity().infoUrl != null) {
                        Player.this.displayUrl(Player.this.actPanel.getActivity().infoUrl, true);
                    } else if (Player.this.actPanel.getActivity().infoCmd != null) {
                        Player.this.runCmd(Player.this.actPanel.getActivity().infoCmd);
                    }
                }
            }
        };
        this.actions[7] = new AbstractAction(){

            public void actionPerformed(ActionEvent actionEvent) {
                Player.this.showAbout(true);
            }
        };
        this.actions[6] = new AbstractAction(){

            public void actionPerformed(ActionEvent actionEvent) {
                Boolean bl;
                Object object = this.getValue("Default");
                Player.this.audioEnabled = !Player.this.audioEnabled;
                Boolean bl2 = bl = Player.this.audioEnabled ? Boolean.TRUE : Boolean.FALSE;
                if (!Player.this.audioEnabled) {
                    Player.this.stopMedia();
                    EventSounds.globalEnabled = false;
                } else {
                    EventSounds.globalEnabled = Player.this.options.getBoolean("systemSounds", true);
                }
                this.putValue("Default", bl);
                if (this.changeSupport != null) {
                    PropertyChangeEvent propertyChangeEvent = new PropertyChangeEvent(this, "selected", object, bl);
                    this.changeSupport.firePropertyChange(propertyChangeEvent);
                }
            }
        };
        this.actions[6].putValue("Default", this.audioEnabled ? Boolean.TRUE : Boolean.FALSE);
        int n = 0;
        while (n < Constants.DYNAMIC_ACTIONS.length) {
            this.actions[Constants.DYNAMIC_ACTIONS[n]].setEnabled(false);
            ++n;
        }
        this.actions[6].setEnabled(true);
    }

    protected void setActionsText() {
        if (this.actions != null) {
            int n = 0;
            while (n < this.actions.length) {
                if (this.actions[n] != null) {
                    Icon icon;
                    String string = this.messages.get("action_" + this.getActionName(n) + "_caption");
                    if (!string.equals(this.actions[n].getValue("Name"))) {
                        this.actions[n].putValue("Name", string);
                    }
                    if (!(string = this.messages.get("action_" + this.getActionName(n) + "_tooltip")).equals(this.actions[n].getValue("ShortDescription"))) {
                        this.actions[n].putValue("ShortDescription", string);
                    }
                    if ((string = this.messages.get("action_" + this.getActionName(n) + "_keys")) != null && string.length() == 2) {
                        this.actions[n].putValue("MnemonicKey", new Integer(string.charAt(0)));
                        char c = string.charAt(1);
                        int n2 = -1;
                        if (c == '*') {
                            switch (n) {
                                case 1: {
                                    n2 = 39;
                                    break;
                                }
                                case 0: {
                                    n2 = 37;
                                    break;
                                }
                                case 2: {
                                    n2 = 38;
                                    break;
                                }
                                case 3: {
                                    n2 = 10;
                                    break;
                                }
                            }
                        } else {
                            n2 = c;
                        }
                        if (n2 >= 0) {
                            this.actions[n].putValue("AcceleratorKey", KeyStroke.getKeyStroke(n2, 2));
                        }
                    }
                    if ((icon = this.getActionIcon(n)) != null && !icon.equals(this.actions[n].getValue("SmallIcon"))) {
                        this.actions[n].putValue("SmallIcon", icon);
                    }
                }
                ++n;
            }
        }
    }

    protected String getActionName(int n) {
        if (n < 0 || n >= Constants.ACTION_NAME.length) {
            return null;
        }
        return Constants.ACTION_NAME[n];
    }

    protected Icon getActionIcon(int n) {
        if (n < 0 || n >= ACTION_ICONS.length) {
            return null;
        }
        return ResourceManager.getImageIcon((String)ACTION_ICONS[n]);
    }

    public Action getAction(int n) {
        if (this.actions == null || n < 0 || n >= this.actions.length) {
            return null;
        }
        return this.actions[n];
    }

    protected boolean processActionEvent(String string) {
        return !this.isEnabled();
    }

    protected void showAbout(boolean bl) {
        if (this.skin != null) {
            AboutWindow aboutWindow = this.skin.buildAboutWindow();
            try {
                aboutWindow.buildAboutTab(DEFAULT_APP_NAME, this.getMsg("JCLIC_VERSION"), null, null, null, null, null);
                aboutWindow.buildStandardTab(aboutWindow.getHtmlSystemInfo(), "about_window_systemInfo", "about_window_lb_system", "icons/system_small.gif");
                if (this.project != null) {
                    StringBuffer stringBuffer = new StringBuffer(4096);
                    stringBuffer.append(this.project.settings.toHtmlString(this.messages));
                    if (this.actPanel != null) {
                        stringBuffer.append("\n<BR>\n").append(this.actPanel.getActivity().toHtmlString(this));
                    }
                    aboutWindow.buildStandardTab(stringBuffer.substring(0), "about_window_projectInfo", "about_window_lb_project", "icons/info_small.gif");
                }
                if (this.reporter != null) {
                    aboutWindow.buildStandardTab(this.reporter.toHtmlString(this.messages), "about_window_reportInfo", "about_window_lb_report", "icons/report_small.gif");
                    if (bl) {
                        aboutWindow.getTabbedPane().setSelectedIndex(3);
                    }
                }
                this.skin.showAboutWindow(aboutWindow);
            }
            catch (Exception exception) {
                System.err.println("Error building about window!\n" + exception);
            }
        }
    }

    public void playMedia(final MediaContent mediaContent, final ActiveBox activeBox) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                String string = mediaContent.mediaFileName;
                JumpInfo jumpInfo = null;
                switch (mediaContent.mediaType) {
                    case 8: {
                        jumpInfo = new JumpInfo(0, FileSystem.stdFn(string));
                        jumpInfo.projectPath = mediaContent.externalParam;
                        Player.this.history.processJump(jumpInfo, true);
                        break;
                    }
                    case 7: {
                        Player.this.history.push();
                        if (!Player.this.navButtonsAlways) {
                            Player.this.navButtonsDisabled = true;
                        }
                        Player.this.load(null, null, string, null);
                        break;
                    }
                    case 12: {
                        Player.this.history.pop();
                        break;
                    }
                    case 11: {
                        String string2 = mediaContent.mediaFileName;
                        if (string2 != null) {
                            string2 = Player.this.project.getFileSystem().getUrl(string2);
                        }
                        jumpInfo = new JumpInfo(3, string2);
                        Player.this.history.processJump(jumpInfo, false);
                        break;
                    }
                    case 9: {
                        if (mediaContent.mediaFileName == null) break;
                        StringBuffer stringBuffer = new StringBuffer(mediaContent.mediaFileName);
                        if (mediaContent.externalParam != null) {
                            stringBuffer.append(" ").append(mediaContent.externalParam);
                        }
                        Player.this.runCmd(stringBuffer.substring(0));
                        break;
                    }
                    case 10: {
                        if (mediaContent.mediaFileName == null) break;
                        Player.this.displayUrl(mediaContent.mediaFileName, true);
                        break;
                    }
                    case 1: 
                    case 2: 
                    case 3: 
                    case 5: 
                    case 6: {
                        ActiveMediaPlayer activeMediaPlayer;
                        if (!Player.this.audioEnabled || (activeMediaPlayer = Player.this.activeMediaBag.getActiveMediaPlayer(mediaContent, Player.this.project.mediaBag, Player.this)) == null) break;
                        activeMediaPlayer.play(activeBox);
                        break;
                    }
                }
            }
        });
    }

    protected void runCmd(String string) {
        if (this.options.get("applet") != null) {
            this.messages.showAlert((Component)this, "msg_warn_no_exec_in_applets");
            return;
        }
        try {
            Runtime.getRuntime().exec(string, null, new File(this.project.getFileSystem().root));
        }
        catch (Exception exception) {
            this.messages.showErrorWarning((Component)this, "msg_error_executing_external", string, exception, null);
        }
    }

    public void stopMedia() {
        this.stopMedia(-1);
    }

    public void stopMedia(int n) {
        this.activeMediaBag.stopAll(n);
    }

    public void activityFinished(boolean bl) {
        this.closeHelpWindow();
        if (bl) {
            this.setCursor(this.getCustomCursor(1));
            this.actPanel.setCursor(null);
        }
        this.setSystemMessage(this.messages.get("msg_activity_finished"), null);
        this.timer.stop();
        this.startAutoPassTimer();
    }

    public void startAutoPassTimer() {
        ActivitySequenceElement activitySequenceElement = this.project.activitySequence.getCurrentAct();
        if (activitySequenceElement != null && activitySequenceElement.delay > 0 && !this.delayedTimer.isRunning() && !this.navButtonsDisabled) {
            this.delayedAction = this.actions[1];
            this.delayedTimer.setInitialDelay(activitySequenceElement.delay * 1000);
            this.delayedTimer.start();
        }
    }

    protected void setBackgroundSettings(Activity activity) {
        this.setBackground(activity != null ? activity.bgColor : Color.lightGray);
        this.bgImageOrigin.setLocation(0, 0);
        this.repaint();
    }

    public void setMsg(ActiveBoxContent activeBoxContent) {
        ActiveBox activeBox = null;
        if (this.skin != null) {
            activeBox = this.skin.getMsgBox();
        }
        if (activeBox != null) {
            activeBox.clear();
            activeBox.setContent(activeBoxContent == null ? ActiveBoxContent.getEmptyContent() : activeBoxContent);
        }
    }

    public void playMsg() {
        if (this.skin != null && this.skin.getMsgBox() != null) {
            this.skin.getMsgBox().playMedia(this);
        }
    }

    public void incCounterValue(int n) {
        int n2 = n;
        this.counterVal[n2] = this.counterVal[n2] + 1;
        Counter counter = null;
        if (this.skin != null && (counter = this.skin.getCounter(n)) != null) {
            counter.setValue(this.counterVal[n]);
        }
        if (n == 1 && this.actPanel != null && this.actPanel.getActivity().maxActions > 0 && this.actPanel.isPlaying() && this.counterVal[1] >= this.actPanel.getActivity().maxActions) {
            this.actPanel.finishActivity(false);
        }
    }

    public void setCountDown(int n, int n2) {
        Counter counter = null;
        if (this.skin != null && (counter = this.skin.getCounter(n)) != null) {
            counter.setCountDown(n2);
        }
    }

    public void setCounterValue(int n, int n2) {
        this.counterVal[n] = n2;
        Counter counter = null;
        if (this.skin != null && (counter = this.skin.getCounter(n)) != null) {
            counter.setValue(n2);
        }
    }

    public int getCounterValue(int n) {
        return this.counterVal[n];
    }

    public void setCounterEnabled(int n, boolean bl) {
        if (this.skin != null) {
            this.skin.enableCounter(n, bl);
            this.setCountDown(n, 0);
        }
    }

    public Messages getMessages() {
        return this.messages == null ? this.setMessages() : this.messages;
    }

    public void setWaitCursor(boolean bl) {
        if (this.skin != null) {
            this.skin.setWaitCursor(bl);
        }
    }

    public void setSystemMessage(String string, String string2) {
        if (this.skin != null) {
            this.skin.setSystemMessage(string, string2);
        }
        if (this.trace) {
            System.out.println("MSG " + (string == null ? "" : string + " ") + (string2 == null ? "" : string2));
        }
    }

    public JComponent getComponent() {
        return this;
    }

    public ActiveMediaPlayer getActiveMediaPlayer(MediaContent mediaContent) {
        if (this.activeMediaBag != null && mediaContent != null) {
            return this.activeMediaBag.getActiveMediaPlayer(mediaContent, this.project.mediaBag, this);
        }
        return null;
    }

    public Cursor getCustomCursor(int n) {
        if (n >= 0 && n < this.cursors.length) {
            return this.cursors[n];
        }
        return null;
    }

    public void reportNewActivity(Activity activity, int n) {
        ActivitySequenceElement activitySequenceElement = this.project.activitySequence.getCurrentAct();
        if (this.reporter != null) {
            if (activitySequenceElement.getTag() != null && !activitySequenceElement.getTag().equals(this.reporter.getCurrentSequenceTag())) {
                this.reporter.newSequence(activitySequenceElement);
            }
            if (activity.includeInReports) {
                this.reporter.newActivity(activity);
            }
        }
        this.setCounterValue(1, 0);
        this.setCounterValue(0, 0);
    }

    public void reportNewAction(Activity activity, String string, String string2, String string3, boolean bl, int n) {
        if (this.reporter != null && activity.includeInReports && activity.reportActions) {
            this.reporter.newAction(string, string2, string3, bl);
        }
        if (n >= 0) {
            this.incCounterValue(1);
            this.setCounterValue(0, n);
        }
    }

    public void reportEndActivity(Activity activity, boolean bl) {
        if (this.reporter != null && activity.includeInReports) {
            this.reporter.endActivity(this.counterVal[0], this.counterVal[1], bl);
        }
    }

    public boolean showHelp(JComponent jComponent, String string) {
        if (this.skin != null) {
            this.skin.showHelp(jComponent, string);
            return true;
        }
        return false;
    }

    public InputStream getProgressInputStream(InputStream inputStream, int n, String string) {
        if (this.skin != null && inputStream != null && !(inputStream instanceof ByteArrayInputStream)) {
            inputStream = this.skin.getProgressInputStream(inputStream, n, string);
        }
        return inputStream;
    }

    public Options getOptions() {
        return this.options;
    }

    public void displayUrl(String string, boolean bl) {
        if (string != null) {
            string = this.project.getFileSystem().getUrl(string);
            try {
                this.displayUrl(new URL(string), bl);
            }
            catch (Exception exception) {
                System.err.println("Unable to invoque URL " + string + "\n" + exception);
            }
        }
    }

    public void displayUrl(URL uRL, boolean bl) {
        if (uRL == null) {
            return;
        }
        Applet applet = this.options.getApplet();
        try {
            if (applet != null) {
                if (bl) {
                    String string = (String)this.options.get("infoUrlFrame");
                    if (string == null) {
                        string = "_BLANK";
                    }
                    applet.getAppletContext().showDocument(uRL, string);
                } else {
                    this.end();
                    applet.getAppletContext().showDocument(uRL);
                }
            } else {
                BrowserLauncher.openURL((String)uRL.toExternalForm());
            }
        }
        catch (Exception exception) {
            System.err.println("Unable to invoque URL " + uRL + "\n" + exception);
        }
    }

    public void exit() {
        this.exit(null);
    }

    public void exit(String string) {
        final String string2 = string == null ? this.options.getString("exitUrl") : string;
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                if (string2 != null) {
                    Player.this.displayUrl(string2, false);
                }
                if (Player.this.options.getApplet() == null) {
                    try {
                        Player.this.end();
                        Frame frame = JOptionPane.getFrameForComponent(Player.this.getTopComponent());
                        if (frame != null) {
                            frame.dispose();
                        } else {
                            System.exit(0);
                        }
                    }
                    catch (Exception exception) {
                        System.err.println("Unable to exit!\n" + exception);
                    }
                }
            }
        });
    }

    public void requestFocus() {
        if (this.actPanel != null) {
            this.actPanel.requestFocus();
        }
    }

    public String getMsg(String string) {
        return this.messages.get(string);
    }

    public void doAutoStart() {
    }

    public boolean newInstanceRequest(final String string, final String string2) {
        boolean bl = false;
        if (string != null) {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    Frame frame = JOptionPane.getFrameForComponent(Player.this);
                    if (frame != null) {
                        frame.toFront();
                    }
                    Player.this.load(string, string2);
                }
            });
            bl = true;
        }
        return bl;
    }

    public boolean windowCloseRequested() {
        return true;
    }

    public void setWindowTitle(String string) {
        Window window = Options.getWindowForComponent((Component)this);
        if (window != null) {
            StringBuffer stringBuffer = new StringBuffer();
            String string2 = StrUtils.nullableString((Object)string);
            if (string2 != null) {
                stringBuffer.append(string2).append(" - ");
            }
            stringBuffer.append(this.appName);
            if (window instanceof Frame) {
                ((Frame)window).setTitle(stringBuffer.substring(0));
            } else if (window instanceof Dialog) {
                ((Dialog)window).setTitle(stringBuffer.substring(0));
            }
        }
    }

    public void setWindowTitle() {
        String string;
        StringBuffer stringBuffer = new StringBuffer();
        String string2 = this.project == null ? null : StrUtils.nullableString((Object)this.project.getPublicName());
        String string3 = string = this.actPanel == null ? null : StrUtils.nullableString((Object)this.actPanel.getActivity().getPublicName());
        if (string != null) {
            stringBuffer.append(string);
            if (string2 != null) {
                stringBuffer.append(" [");
            }
        }
        if (string2 != null) {
            stringBuffer.append(string2);
            if (string != null) {
                stringBuffer.append("]");
            }
        }
        this.setWindowTitle(stringBuffer.substring(0));
    }
}

