/*
 * Decompiled with CFR 0.152.
 */
package edu.xtec.jclic.media;

import edu.xtec.jclic.bags.MediaBag;
import edu.xtec.jclic.media.JavaSoundAudioPlayer;
import edu.xtec.jclic.media.PseudoClip;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.DataLine;
import javax.sound.sampled.SourceDataLine;

public class FalseClip
implements PseudoClip {
    private AudioInputStream ais;
    private AudioFormat af;
    private MediaBag mb;
    private String mediaFileName;
    private PlayThread playThread;
    private int loopCount;

    private FalseClip(MediaBag mediaBag, String string) throws Exception {
        this.mb = mediaBag;
        this.mediaFileName = string;
        this.af = this.getAudioInputStream().getFormat();
    }

    public static FalseClip getFalseClip(MediaBag mediaBag, String string) throws Exception {
        return new FalseClip(mediaBag, string);
    }

    private AudioInputStream getAudioInputStream() throws Exception {
        if (this.ais == null) {
            JavaSoundAudioPlayer javaSoundAudioPlayer = new JavaSoundAudioPlayer();
            javaSoundAudioPlayer.setDataSource(this.mb.getMediaDataSource(this.mediaFileName));
            this.ais = javaSoundAudioPlayer.ais;
            if (this.ais == null) {
                throw new Exception("Unable to open audio data!");
            }
        }
        return this.ais;
    }

    public void close() {
        this.stop();
    }

    public AudioFormat getFormat() {
        return this.af;
    }

    public boolean isActive() {
        return this.playThread != null && this.playThread.isAlive();
    }

    public boolean isOpen() {
        return this.ais != null;
    }

    public boolean isRunning() {
        return this.isActive();
    }

    public void loop(int n) throws Exception {
        this.start();
        this.loopCount = n;
    }

    public void open() throws Exception {
        this.getAudioInputStream();
    }

    public void setFramePosition(int n) {
    }

    public void setLoopPoints(int n, int n2) {
    }

    public void start() throws Exception {
        if (this.playThread == null) {
            this.loopCount = 0;
            this.playThread = new PlayThread();
            this.playThread.start();
        }
    }

    public void stop() {
        if (this.playThread != null) {
            if (this.playThread.isAlive()) {
                this.playThread.running = false;
                while (this.playThread != null) {
                    Thread.currentThread();
                    Thread.yield();
                }
            } else {
                this.playThread = null;
                this.ais = null;
            }
        }
    }

    class PlayThread
    extends Thread {
        public boolean running = false;
        byte[] buf = new byte[1024];
        SourceDataLine line = null;
        static /* synthetic */ Class class$javax$sound$sampled$SourceDataLine;

        public PlayThread() throws Exception {
            FalseClip.this.getAudioInputStream();
            DataLine.Info info = new DataLine.Info(class$javax$sound$sampled$SourceDataLine == null ? (class$javax$sound$sampled$SourceDataLine = PlayThread.class$("javax.sound.sampled.SourceDataLine")) : class$javax$sound$sampled$SourceDataLine, FalseClip.this.af);
            this.line = (SourceDataLine)AudioSystem.getLine(info);
            if (this.line != null) {
                this.line.open(FalseClip.this.af);
            }
        }

        public void run() {
            int n;
            if (this.line != null) {
                this.running = true;
                n = 0;
                try {
                    this.line.start();
                    while (this.running && n >= 0) {
                        n = FalseClip.this.ais.read(this.buf, 0, this.buf.length);
                        if (n >= 0) {
                            int n2 = this.line.write(this.buf, 0, n);
                        }
                        Thread.currentThread();
                        Thread.yield();
                    }
                    if (this.running) {
                        this.line.drain();
                    } else {
                        this.line.stop();
                    }
                }
                catch (Exception exception) {
                    System.err.println("JavaSound playing error:\n" + exception);
                }
                this.line.close();
            }
            FalseClip.this.ais = null;
            FalseClip.this.playThread = null;
            if (this.running && FalseClip.this.loopCount != 0) {
                if (FalseClip.this.loopCount > 0) {
                    FalseClip.this.loopCount--;
                }
                try {
                    n = FalseClip.this.loopCount;
                    FalseClip.this.start();
                    FalseClip.this.loopCount = n;
                }
                catch (Exception exception) {
                    System.err.println("Error looping sound: " + exception);
                }
            }
            this.running = false;
        }

        static /* synthetic */ Class class$(String string) {
            try {
                return Class.forName(string);
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
    }
}

