/*
 * Decompiled with CFR 0.152.
 */
package edu.xtec.jclic.media;

import edu.xtec.jclic.PlayStation;
import edu.xtec.jclic.bags.MediaBag;
import edu.xtec.jclic.boxes.ActiveBox;
import edu.xtec.jclic.media.ActiveMediaPlayer;
import edu.xtec.jclic.media.AudioBuffer;
import edu.xtec.jclic.media.ClipWrapper;
import edu.xtec.jclic.media.FalseClip;
import edu.xtec.jclic.media.JavaSoundAudioBuffer;
import edu.xtec.jclic.media.MediaContent;
import edu.xtec.jclic.media.PseudoClip;
import edu.xtec.util.ExtendedByteArrayInputStream;
import edu.xtec.util.StreamIO;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import javax.sound.midi.MidiSystem;
import javax.sound.midi.Sequencer;
import javax.swing.Timer;

public class JavaSoundActiveMediaPlayer
extends ActiveMediaPlayer {
    PseudoClip clip;
    Timer timer;
    boolean midi;
    ByteArrayInputStream midiIs;
    public static Sequencer sequencer = null;

    public JavaSoundActiveMediaPlayer(MediaContent mediaContent, MediaBag mediaBag, PlayStation playStation) {
        super(mediaContent, mediaBag, playStation);
        InputStream inputStream = null;
        this.midi = false;
        this.midiIs = null;
        if (!this.useAudioBuffer) {
            try {
                switch (mediaContent.mediaType) {
                    case 3: {
                        this.midi = true;
                        inputStream = mediaBag.getInputStream(mediaContent.mediaFileName);
                        if (inputStream instanceof ByteArrayInputStream) {
                            this.midiIs = (ByteArrayInputStream)inputStream;
                            break;
                        }
                        this.midiIs = new ExtendedByteArrayInputStream(StreamIO.readInputStream((InputStream)inputStream), mediaContent.mediaFileName);
                        break;
                    }
                    case 1: {
                        this.clip = mediaContent.to > 0 || mediaContent.from > 0 ? ClipWrapper.getClipWrapper(mediaBag, mediaContent.mediaFileName) : FalseClip.getFalseClip(mediaBag, mediaContent.mediaFileName);
                        if (this.clip == null || mediaContent.loop || mediaContent.to <= Math.max(0, mediaContent.from)) break;
                        this.timer = new Timer(mediaContent.to - Math.max(0, mediaContent.from), new ActionListener(){

                            public void actionPerformed(ActionEvent actionEvent) {
                                if (JavaSoundActiveMediaPlayer.this.clip != null && JavaSoundActiveMediaPlayer.this.clip.isRunning()) {
                                    JavaSoundActiveMediaPlayer.this.clip.stop();
                                }
                            }
                        });
                        this.timer.setCoalesce(false);
                        this.timer.setRepeats(false);
                        break;
                    }
                }
            }
            catch (Exception exception) {
                System.err.println("Error reading media \"" + mediaContent.mediaFileName + "\":\n" + exception);
            }
        }
    }

    public AudioBuffer createAudioBuffer(int n) throws Exception {
        return new JavaSoundAudioBuffer(this.mc.length);
    }

    public static void closeMidiSequencer() {
        if (sequencer != null) {
            if (sequencer.isRunning()) {
                sequencer.stop();
            }
            if (sequencer.isOpen()) {
                sequencer.close();
            }
        }
    }

    public void realize() {
        if (!this.useAudioBuffer) {
            try {
                if (this.midi) {
                    if (sequencer == null) {
                        sequencer = MidiSystem.getSequencer();
                    }
                } else if (this.clip != null && !this.clip.isOpen()) {
                    this.clip.open();
                }
            }
            catch (Exception exception) {
                System.err.println("Error realizing media \"" + this.mc.mediaFileName + "\"\n" + exception);
            }
        }
    }

    protected void playNow(ActiveBox activeBox) {
        if (this.useAudioBuffer) {
            super.playNow(activeBox);
        } else {
            try {
                if (this.midi) {
                    if (sequencer == null) {
                        this.realize();
                    }
                    if (sequencer != null && this.midiIs != null) {
                        if (sequencer.isRunning()) {
                            sequencer.stop();
                        }
                        if (!sequencer.isOpen()) {
                            sequencer.open();
                        }
                        this.midiIs.reset();
                        sequencer.setSequence(this.midiIs);
                        sequencer.stop();
                        this.setTimeRanges();
                        sequencer.start();
                    }
                } else if (this.clip != null) {
                    if (!this.clip.isOpen()) {
                        this.realize();
                    }
                    this.setTimeRanges();
                    this.attachVisualComponent();
                    if (this.mc.loop) {
                        this.clip.loop(-1);
                    } else {
                        this.clip.start();
                        if (this.timer != null) {
                            this.timer.start();
                        }
                    }
                }
            }
            catch (Exception exception) {
                System.err.println("Error playing media \"" + this.mc.mediaFileName + "\":\n" + exception);
            }
        }
    }

    public void stop() {
        super.stop();
        if (!this.useAudioBuffer) {
            try {
                if (this.midi && sequencer != null) {
                    JavaSoundActiveMediaPlayer.closeMidiSequencer();
                } else if (this.clip != null && this.clip.isActive()) {
                    if (this.timer != null && this.timer.isRunning()) {
                        this.timer.stop();
                    }
                    this.clip.stop();
                }
            }
            catch (Exception exception) {
                System.err.println("Error stopping media \"" + this.mc.mediaFileName + "\":\n" + exception);
            }
        }
    }

    public void clear() {
        super.clear();
        if (!this.useAudioBuffer) {
            try {
                if (this.midi) {
                    if (sequencer != null) {
                        sequencer.close();
                        sequencer = null;
                    }
                    if (this.midiIs != null) {
                        this.midiIs.close();
                        this.midiIs = null;
                    }
                } else if (this.clip != null) {
                    this.stop();
                    this.clip.close();
                    this.destroyVisualComponent();
                    this.clip = null;
                    this.timer = null;
                }
            }
            catch (Exception exception) {
                System.err.println("Error closing media \"" + this.mc.mediaFileName + "\":\n" + exception);
            }
        }
    }

    protected void setTimeRanges() {
        if (this.useAudioBuffer) {
            return;
        }
        try {
            if (this.midi && sequencer != null) {
                sequencer.setTickPosition(0L);
            } else if (this.clip != null && this.clip.isOpen()) {
                if (this.mc.from >= 0 || this.mc.to >= 0) {
                    int n;
                    int n2 = this.mc.from > 0 ? (int)(this.clip.getFormat().getFrameRate() * (float)this.mc.from / 1000.0f) : 0;
                    int n3 = n = this.mc.to >= 0 ? (int)(this.clip.getFormat().getFrameRate() * (float)this.mc.to / 1000.0f) : -1;
                    if (this.mc.loop) {
                        this.clip.setLoopPoints(n2, n);
                    }
                    this.clip.setFramePosition(n2);
                } else {
                    this.clip.setFramePosition(0);
                }
            }
        }
        catch (Exception exception) {
            System.err.println("Error setting time ranges for \"" + this.mc.mediaFileName + "\":\n" + exception);
        }
    }

    protected Component getVisualComponent() {
        return null;
    }
}

