/*
 * Decompiled with CFR 0.152.
 */
package edu.xtec.jclic.misc;

import java.awt.Image;
import java.awt.Toolkit;
import java.awt.image.ColorModel;
import java.awt.image.IndexColorModel;
import java.awt.image.MemoryImageSource;
import java.io.BufferedInputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;

public class Bmp {
    private Image image;
    private BmpFileheader bmp_fileheader = new BmpFileheader();
    private BmpInfoHeader bmp_infoheader = new BmpInfoHeader();
    private BmpPalette bmp_palette;
    private int width;
    private int height;

    public Bmp(InputStream inputStream) throws Exception {
        this.read(new DataInputStream(new BufferedInputStream(inputStream)));
    }

    public Bmp(BufferedInputStream bufferedInputStream) throws Exception {
        this.read(new DataInputStream(bufferedInputStream));
    }

    public Bmp(DataInputStream dataInputStream) throws Exception {
        this.read(dataInputStream);
    }

    public Image getImage() {
        return this.image;
    }

    void read(DataInputStream dataInputStream) throws Exception {
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        byte[] byArray = null;
        this.bmp_fileheader.read(dataInputStream);
        this.bmp_infoheader.read(dataInputStream);
        if (this.bmp_infoheader.biClrUsed != 0) {
            n = this.bmp_infoheader.biClrUsed;
        } else if (this.bmp_infoheader.biBitCount < 16) {
            n = 1 << this.bmp_infoheader.biBitCount;
        }
        this.bmp_palette = new BmpPalette(n);
        this.bmp_palette.read(dataInputStream);
        long l = this.bmp_fileheader.bfOffBits - (this.bmp_fileheader.getSize() + this.bmp_infoheader.getSize() + this.bmp_palette.getSize());
        if (l > 0L) {
            dataInputStream.skip(l);
        }
        n2 = (this.bmp_infoheader.biWidth * this.bmp_infoheader.biBitCount + 31) / 32 * 4;
        n3 = this.bmp_infoheader.biSizeImage != 0 ? this.bmp_infoheader.biSizeImage : n2 * this.bmp_infoheader.biHeight;
        byArray = new byte[n3];
        this.readBytePCArray(dataInputStream, byArray);
        dataInputStream.close();
        if (byArray != null) {
            this.image = this.bmp_infoheader.biBitCount > 8 ? this.unpack24(byArray, n2) : this.unpack08(byArray, n2);
        }
        byArray = null;
    }

    public int readIntPC(DataInputStream dataInputStream) throws IOException {
        int n = dataInputStream.readInt();
        return n << 24 | (n & 0xFF00) << 8 | (n & 0xFF0000) >>> 8 | n >>> 24;
    }

    public short readShortPC(DataInputStream dataInputStream) throws IOException {
        int n = dataInputStream.readUnsignedShort();
        return (short)(n << 8 | n >>> 8);
    }

    public byte readBytePC(DataInputStream dataInputStream) throws IOException {
        return (byte)dataInputStream.readUnsignedByte();
    }

    public void readBytePCArray(DataInputStream dataInputStream, byte[] byArray) throws IOException {
        dataInputStream.readFully(byArray);
    }

    Image unpack24(byte[] byArray, int n) throws Exception {
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        int[] nArray = new int[this.bmp_infoheader.biWidth * this.bmp_infoheader.biHeight];
        n5 = 0;
        while (n5 < this.bmp_infoheader.biHeight) {
            n2 = (this.bmp_infoheader.biHeight - 1 - n5) * this.bmp_infoheader.biWidth;
            n3 = n5 * n;
            n4 = 0;
            while (n4 < this.bmp_infoheader.biWidth) {
                nArray[n4 + n2] = 0xFF000000 | byArray[n3++] & 0xFF | (byArray[n3++] & 0xFF) << 8 | (byArray[n3++] & 0xFF) << 16;
                ++n4;
            }
            ++n5;
        }
        return Toolkit.getDefaultToolkit().createImage(new MemoryImageSource(this.bmp_infoheader.biWidth, this.bmp_infoheader.biHeight, ColorModel.getRGBdefault(), nArray, 0, this.bmp_infoheader.biWidth));
    }

    Image unpack08(byte[] byArray, int n) throws Exception {
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        int n6 = 0;
        byte[] byArray2 = new byte[this.bmp_infoheader.biWidth * this.bmp_infoheader.biHeight];
        if (this.bmp_infoheader.biBitCount == 1) {
            n6 = 0;
            while (n6 < this.bmp_infoheader.biHeight) {
                n2 = (this.bmp_infoheader.biHeight - 1 - n6) * this.bmp_infoheader.biWidth;
                n3 = n6 * n;
                n5 = 0;
                while (n5 < this.bmp_infoheader.biWidth - 8) {
                    byArray2[n2 + n5 + 7] = (byte)(byArray[n3] & 1);
                    byArray2[n2 + n5 + 6] = (byte)(byArray[n3] >>> 1 & 1);
                    byArray2[n2 + n5 + 5] = (byte)(byArray[n3] >>> 2 & 1);
                    byArray2[n2 + n5 + 4] = (byte)(byArray[n3] >>> 3 & 1);
                    byArray2[n2 + n5 + 3] = (byte)(byArray[n3] >>> 4 & 1);
                    byArray2[n2 + n5 + 2] = (byte)(byArray[n3] >>> 5 & 1);
                    byArray2[n2 + n5 + 1] = (byte)(byArray[n3] >>> 6 & 1);
                    byArray2[n2 + n5] = (byte)(byArray[n3] >>> 7 & 1);
                    ++n3;
                    n5 += 8;
                }
                n4 = 7;
                while (n4 >= 0) {
                    if (n4 + n5 < this.bmp_infoheader.biWidth) {
                        byArray2[n2 + n5 + n4] = (byte)(byArray[n3] >>> 7 - n4 & 1);
                    }
                    --n4;
                }
                ++n6;
            }
        } else if (this.bmp_infoheader.biBitCount == 4) {
            n6 = 0;
            while (n6 < this.bmp_infoheader.biHeight) {
                n2 = (this.bmp_infoheader.biHeight - 1 - n6) * this.bmp_infoheader.biWidth;
                n3 = n6 * n;
                n5 = 0;
                while (n5 < this.bmp_infoheader.biWidth - 2) {
                    byArray2[n2 + n5] = (byte)(byArray[n3] >> 4 & 0xF);
                    byArray2[n2 + n5 + 1] = (byte)(byArray[n3] & 0xF);
                    ++n3;
                    n5 += 2;
                }
                n4 = 1;
                while (n4 >= 0) {
                    if (n4 + n5 < this.bmp_infoheader.biWidth) {
                        byArray2[n2 + n5 + n4] = (byte)(byArray[n3] >>> (1 - n4 << 2) & 0xF);
                    }
                    --n4;
                }
                ++n6;
            }
        } else {
            n6 = 0;
            while (n6 < this.bmp_infoheader.biHeight) {
                n2 = (this.bmp_infoheader.biHeight - 1 - n6) * this.bmp_infoheader.biWidth;
                n3 = n6 * n;
                n5 = 0;
                while (n5 < this.bmp_infoheader.biWidth) {
                    byArray2[n5 + n2] = (byte)(byArray[n3++] & 0xFF);
                    ++n5;
                }
                ++n6;
            }
        }
        IndexColorModel indexColorModel = new IndexColorModel((int)this.bmp_infoheader.biBitCount, this.bmp_palette.length, this.bmp_palette.r, this.bmp_palette.g, this.bmp_palette.b);
        return Toolkit.getDefaultToolkit().createImage(new MemoryImageSource(this.bmp_infoheader.biWidth, this.bmp_infoheader.biHeight, (ColorModel)indexColorModel, byArray2, 0, this.bmp_infoheader.biWidth));
    }

    class BmpPalette {
        int length;
        byte[] r;
        byte[] g;
        byte[] b;

        public BmpPalette(int n) {
            this.length = n;
            this.r = new byte[n];
            this.g = new byte[n];
            this.b = new byte[n];
        }

        int getSize() {
            return this.length * 4;
        }

        void read(DataInputStream dataInputStream) throws Exception {
            if (this.length > 0) {
                int n = 0;
                while (n < this.length) {
                    this.b[n] = Bmp.this.readBytePC(dataInputStream);
                    this.g[n] = Bmp.this.readBytePC(dataInputStream);
                    this.r[n] = Bmp.this.readBytePC(dataInputStream);
                    byte by = Bmp.this.readBytePC(dataInputStream);
                    ++n;
                }
            }
        }
    }

    class BmpFileheader {
        byte[] bfType = new byte[]{66, 77};
        int bfSize;
        short bfReserved1 = 0;
        short bfReserved2 = 0;
        int bfOffBits;

        BmpFileheader() {
        }

        int getSize() {
            return 14;
        }

        void read(DataInputStream dataInputStream) throws Exception {
            this.bfType[0] = Bmp.this.readBytePC(dataInputStream);
            this.bfType[1] = Bmp.this.readBytePC(dataInputStream);
            if (this.bfType[0] != 66 && this.bfType[1] != 77) {
                throw new IOException("Invalid BMP 3.0 File.");
            }
            this.bfSize = Bmp.this.readIntPC(dataInputStream);
            this.bfReserved1 = Bmp.this.readShortPC(dataInputStream);
            this.bfReserved2 = Bmp.this.readShortPC(dataInputStream);
            this.bfOffBits = Bmp.this.readIntPC(dataInputStream);
        }
    }

    class BmpInfoHeader {
        int biSize = 40;
        int biWidth;
        int biHeight;
        short biPlanes = 1;
        short biBitCount;
        int biCompression;
        int biSizeImage;
        int biXPelsPerMeter;
        int biYPelsPerMeter;
        int biClrUsed;
        int biClrImportant;

        BmpInfoHeader() {
        }

        int getSize() {
            return this.biSize;
        }

        void read(DataInputStream dataInputStream) throws Exception {
            this.biSize = Bmp.this.readIntPC(dataInputStream);
            if (this.biSize == 12) {
                this.biWidth = Bmp.this.readShortPC(dataInputStream);
                this.biHeight = Bmp.this.readShortPC(dataInputStream);
                this.biPlanes = Bmp.this.readShortPC(dataInputStream);
                this.biBitCount = Bmp.this.readShortPC(dataInputStream);
            } else {
                this.biWidth = Bmp.this.readIntPC(dataInputStream);
                this.biHeight = Bmp.this.readIntPC(dataInputStream);
                this.biPlanes = Bmp.this.readShortPC(dataInputStream);
                this.biBitCount = Bmp.this.readShortPC(dataInputStream);
                this.biCompression = Bmp.this.readIntPC(dataInputStream);
                this.biSizeImage = Bmp.this.readIntPC(dataInputStream);
                this.biXPelsPerMeter = Bmp.this.readIntPC(dataInputStream);
                this.biYPelsPerMeter = Bmp.this.readIntPC(dataInputStream);
                this.biClrUsed = Bmp.this.readIntPC(dataInputStream);
                this.biClrImportant = Bmp.this.readIntPC(dataInputStream);
            }
            if (this.biSizeImage == 0) {
                this.biSizeImage = (this.biWidth * this.biBitCount + 31 >> 5 << 2) * this.biHeight;
            }
            if (this.biClrUsed == 0 && this.biBitCount < 16) {
                this.biClrUsed = 1 << this.biBitCount;
            }
        }
    }
}

