/*
 * Decompiled with CFR 0.152.
 */
package edu.xtec.jclic.report;

import edu.xtec.jclic.Activity;
import edu.xtec.jclic.project.JClicProject;
import edu.xtec.jclic.report.ActivityReg;
import edu.xtec.jclic.report.GroupData;
import edu.xtec.jclic.report.Reporter;
import edu.xtec.jclic.report.TCPReportBean;
import edu.xtec.jclic.report.UserData;
import edu.xtec.util.Domable;
import edu.xtec.util.JDomUtility;
import edu.xtec.util.Messages;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.HashMap;
import java.util.Vector;
import javax.swing.Timer;
import org.jdom.Document;
import org.jdom.Element;

public class TCPReporter
extends Reporter {
    protected String currentSessionId = null;
    protected ActivityReg lastActivity = null;
    protected int actCount = 0;
    protected URL serviceUrl = null;
    protected HashMap dbProperties;
    protected Vector tasks = new Vector();
    protected Component parent;
    protected Messages msg;
    protected Timer timer;
    protected int timerLap = 20;
    public static final String SERVER_PATH = "path";
    public static final String DEFAULT_SERVER_PATH = "localhost:9000";
    public static final String SERVER_SERVICE = "service";
    public static final String DEFAULT_SERVER_SERVICE = "/JClicReportService";
    public static final String TIMER_LAP = "lap";
    public static final int DEFAULT_TIMER_LAP = 20;

    protected synchronized void flushTasks() {
        if (!this.tasks.isEmpty() && this.serviceUrl != null) {
            TCPReportBean tCPReportBean = new TCPReportBean("multiple");
            TCPReportBean[] tCPReportBeanArray = null;
            Vector vector = this.tasks;
            synchronized (vector) {
                tCPReportBeanArray = this.tasks.toArray(new TCPReportBean[this.tasks.size()]);
            }
            int n = 0;
            while (n < tCPReportBeanArray.length) {
                tCPReportBean.addElement(tCPReportBeanArray[n].getJDomElement());
                ++n;
            }
            if (this.transaction(tCPReportBean) != null) {
                int n2 = 0;
                while (n2 < tCPReportBeanArray.length) {
                    this.tasks.remove((Object)tCPReportBeanArray[n2]);
                    ++n2;
                }
            }
        }
    }

    public void end() {
        super.end();
        this.reportActivity();
        this.flushTasks();
        this.stopReporting();
    }

    protected void checkUrl() throws Exception {
        if (this.serviceUrl == null) {
            throw new Exception("Service not available!!");
        }
    }

    protected TCPReportBean transaction(String string, Domable[] domableArray) {
        return this.transaction(new TCPReportBean(string, domableArray));
    }

    protected TCPReportBean transaction(TCPReportBean tCPReportBean) {
        if (this.serviceUrl == null) {
            return null;
        }
        TCPReportBean tCPReportBean2 = null;
        boolean bl = true;
        while (tCPReportBean2 == null && bl) {
            try {
                HttpURLConnection httpURLConnection = (HttpURLConnection)this.serviceUrl.openConnection();
                httpURLConnection.setDoOutput(true);
                OutputStream outputStream = httpURLConnection.getOutputStream();
                JDomUtility.saveDocument((OutputStream)outputStream, (Element)tCPReportBean.getJDomElement());
                outputStream.flush();
                outputStream.close();
                InputStream inputStream = httpURLConnection.getInputStream();
                Document document = JDomUtility.getSAXBuilder().build(httpURLConnection.getInputStream());
                tCPReportBean2 = new TCPReportBean(document.getRootElement());
            }
            catch (Exception exception) {
                if (this.msg != null) {
                    int n = this.msg.showErrorWarning(this.parent, "report_err_connect", exception, "ric");
                    switch (n) {
                        case 2: {
                            break;
                        }
                        case 4: {
                            bl = false;
                            break;
                        }
                        default: {
                            this.stopReporting();
                            bl = false;
                            break;
                        }
                    }
                    continue;
                }
                this.stopReporting();
                bl = false;
            }
        }
        return tCPReportBean2;
    }

    protected void stopReporting() {
        if (this.serviceUrl != null) {
            this.serviceUrl = null;
            if (this.description != null) {
                this.description = this.description + " (" + this.msg.get("report_not_connected") + ")";
            }
        }
        if (this.timer != null && this.timer.isRunning()) {
            this.timer.stop();
        }
        this.initiated = false;
    }

    public void init(HashMap hashMap, Component component, Messages messages) throws Exception {
        String string;
        this.parent = component;
        this.msg = messages;
        boolean bl = false;
        try {
            super.init(hashMap, component, messages);
            string = (String)hashMap.get(SERVER_PATH);
            if (string == null) {
                string = DEFAULT_SERVER_PATH;
            }
            this.description = "TCP/IP " + string;
            String string2 = (String)hashMap.get(SERVER_SERVICE);
            if (string2 == null) {
                string2 = DEFAULT_SERVER_SERVICE;
            }
            if (string.length() < 1 || string2.length() < 1) {
                throw new Exception("Bad server specification!");
            }
            if (!string2.startsWith("/")) {
                string2 = string2 + "/";
            }
            this.serviceUrl = new URL("http://" + string + string2);
            if (this.userId == null) {
                this.userId = this.promptUserId(component, messages);
            }
            if (this.userId != null) {
                bl = true;
            }
        }
        catch (Exception exception) {
            messages.showErrorWarning(component, "report_err_init", this.description, exception, null);
        }
        if (bl) {
            string = this.getProperty("TIME_LAP", Integer.toString(this.timerLap));
            this.timerLap = Math.min(300, Math.max(1, Integer.parseInt(string)));
            this.timer = new Timer(this.timerLap * 1000, new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    TCPReporter.this.flushTasks();
                }
            });
            this.timer.setRepeats(true);
            this.timer.start();
        } else {
            this.stopReporting();
        }
    }

    public void newSession(JClicProject jClicProject, Component component, Messages messages) {
        super.newSession(jClicProject, component, messages);
        if (this.serviceUrl == null) {
            return;
        }
        if (this.userId == null) {
            try {
                this.userId = this.promptUserId(component, messages);
            }
            catch (Exception exception) {
                messages.showErrorWarning(component, "error_getting_user", exception);
            }
        }
        if (this.userId != null) {
            this.currentSessionId = null;
        }
    }

    public void createDBSession() {
        if (this.initiated && this.userId != null) {
            this.flushTasks();
            this.currentSessionId = null;
            this.actCount = 0;
            TCPReportBean tCPReportBean = new TCPReportBean("add session");
            tCPReportBean.setParam("project", this.currentSession.projectName);
            tCPReportBean.setParam("time", Long.toString(this.currentSession.timeMillis));
            tCPReportBean.setParam("code", this.currentSession.code);
            tCPReportBean.setParam("user", this.userId);
            tCPReportBean.setParam("key", this.sessionKey);
            tCPReportBean.setParam("context", this.sessionContext);
            tCPReportBean = this.transaction(tCPReportBean);
            if (tCPReportBean != null) {
                this.currentSessionId = tCPReportBean.getParam("session");
            }
            if (this.currentSessionId == null) {
                this.stopReporting();
            }
        }
    }

    protected void reportActivity() {
        if (this.lastActivity != null) {
            if (!this.lastActivity.closed) {
                this.lastActivity.closeActivity();
            }
            if (this.currentSessionId == null) {
                this.createDBSession();
            }
            if (this.currentSessionId != null) {
                TCPReportBean tCPReportBean = new TCPReportBean("add activity");
                tCPReportBean.setParam("session", this.currentSessionId);
                tCPReportBean.setParam("num", Integer.toString(this.actCount++));
                tCPReportBean.setData(this.lastActivity);
                this.tasks.add(tCPReportBean);
            }
        }
        this.lastActivity = this.currentSession != null && this.currentSession.currentSequence != null && this.currentSession.currentSequence.currentActivity != this.lastActivity ? this.currentSession.currentSequence.currentActivity : null;
    }

    public String getProperty(String string, String string2) throws Exception {
        Object object;
        if (this.dbProperties == null) {
            this.dbProperties = new HashMap();
            object = this.transaction(new TCPReportBean("get_properties"));
            if (object == null) {
                return string2;
            }
            this.dbProperties.putAll(object.getParams());
        }
        if ((object = (String)this.dbProperties.get(string)) == null) {
            object = string2;
        }
        return object;
    }

    public Vector getGroups() throws Exception {
        TCPReportBean tCPReportBean = this.transaction("get groups", null);
        if (tCPReportBean == null) {
            return new Vector();
        }
        Domable[] domableArray = tCPReportBean.getData();
        Vector<Domable> vector = new Vector<Domable>(domableArray.length);
        int n = 0;
        while (n < domableArray.length) {
            vector.add(domableArray[n]);
            ++n;
        }
        return vector;
    }

    public Vector getUsers(String string) throws Exception {
        TCPReportBean tCPReportBean = new TCPReportBean("get users");
        tCPReportBean.setParam("group", string);
        tCPReportBean = this.transaction(tCPReportBean);
        if (tCPReportBean == null) {
            return new Vector();
        }
        Domable[] domableArray = tCPReportBean.getData();
        Vector<Domable> vector = new Vector<Domable>(domableArray.length);
        int n = 0;
        while (n < domableArray.length) {
            vector.add(domableArray[n]);
            ++n;
        }
        return vector;
    }

    public UserData getUserData(String string) throws Exception {
        UserData userData = null;
        TCPReportBean tCPReportBean = new TCPReportBean("get user data");
        tCPReportBean.setParam("user", string);
        tCPReportBean = this.transaction(tCPReportBean);
        if (tCPReportBean != null) {
            userData = (UserData)tCPReportBean.getSingleData();
        }
        return userData;
    }

    public GroupData getGroupData(String string) throws Exception {
        GroupData groupData = null;
        TCPReportBean tCPReportBean = new TCPReportBean("get group data");
        tCPReportBean.setParam("group", string);
        tCPReportBean = this.transaction(tCPReportBean);
        if (tCPReportBean != null) {
            groupData = (GroupData)tCPReportBean.getSingleData();
        }
        return groupData;
    }

    public String newGroup(GroupData groupData) throws Exception {
        String string = null;
        TCPReportBean tCPReportBean = new TCPReportBean("new group");
        tCPReportBean.setData(groupData);
        tCPReportBean = this.transaction(tCPReportBean);
        if (tCPReportBean != null) {
            string = tCPReportBean.getParam("group");
        }
        return string;
    }

    public String newUser(UserData userData) throws Exception {
        String string = null;
        TCPReportBean tCPReportBean = new TCPReportBean("new user");
        tCPReportBean.setData(userData);
        tCPReportBean = this.transaction(tCPReportBean);
        if (tCPReportBean != null) {
            string = tCPReportBean.getParam("user");
        }
        return string;
    }

    public void newActivity(Activity activity) {
        super.newActivity(activity);
        this.reportActivity();
    }
}

