/*
 * Decompiled with CFR 0.152.
 */
package org.jdom.input;

import java.util.Map;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.jdom.JDOMException;
import org.xml.sax.SAXException;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.SAXNotSupportedException;
import org.xml.sax.XMLReader;

class JAXPParserFactory {
    private static final String CVS_ID = "@(#) $RCSfile: JAXPParserFactory.java,v $ $Revision: 1.5 $ $Date: 2004/02/27 21:08:47 $ $Name: jdom_1_0 $";
    private static final String JAXP_SCHEMA_LANGUAGE_PROPERTY = "http://java.sun.com/xml/jaxp/properties/schemaLanguage";
    private static final String JAXP_SCHEMA_LOCATION_PROPERTY = "http://java.sun.com/xml/jaxp/properties/schemaSource";

    private JAXPParserFactory() {
    }

    public static XMLReader createParser(boolean bl, Map map, Map map2) throws JDOMException {
        try {
            SAXParser sAXParser = null;
            SAXParserFactory sAXParserFactory = SAXParserFactory.newInstance();
            sAXParserFactory.setValidating(bl);
            sAXParserFactory.setNamespaceAware(true);
            try {
                sAXParser = sAXParserFactory.newSAXParser();
            }
            catch (ParserConfigurationException parserConfigurationException) {
                throw new JDOMException("Could not allocate JAXP SAX Parser", parserConfigurationException);
            }
            JAXPParserFactory.setProperty(sAXParser, map2, JAXP_SCHEMA_LANGUAGE_PROPERTY);
            JAXPParserFactory.setProperty(sAXParser, map2, JAXP_SCHEMA_LOCATION_PROPERTY);
            return sAXParser.getXMLReader();
        }
        catch (SAXException sAXException) {
            throw new JDOMException("Could not allocate JAXP SAX Parser", sAXException);
        }
    }

    private static void setProperty(SAXParser sAXParser, Map map, String string) throws JDOMException {
        try {
            if (map.containsKey(string)) {
                sAXParser.setProperty(string, map.get(string));
            }
        }
        catch (SAXNotSupportedException sAXNotSupportedException) {
            throw new JDOMException(string + " property not supported for JAXP parser " + sAXParser.getClass().getName());
        }
        catch (SAXNotRecognizedException sAXNotRecognizedException) {
            throw new JDOMException(string + " property not recognized for JAXP parser " + sAXParser.getClass().getName());
        }
    }
}

