/*
 * Decompiled with CFR 0.152.
 */
package org.tritonus.share.sampled.convert;

import java.io.IOException;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioInputStream;
import org.tritonus.share.TDebug;
import org.tritonus.share.sampled.AudioUtils;
import org.tritonus.share.sampled.convert.TAudioInputStream;

public abstract class TSynchronousFilteredAudioInputStream
extends TAudioInputStream {
    private AudioInputStream originalStream;
    private AudioFormat originalFormat;
    private int originalFrameSize;
    private int newFrameSize;
    protected byte[] buffer = null;
    private boolean m_bConvertInPlace = false;

    public TSynchronousFilteredAudioInputStream(AudioInputStream audioInputStream, AudioFormat audioFormat) {
        super(audioInputStream, audioFormat, audioInputStream.getFrameLength());
        this.originalStream = audioInputStream;
        this.originalFormat = audioInputStream.getFormat();
        this.originalFrameSize = this.originalFormat.getFrameSize() <= 0 ? 1 : this.originalFormat.getFrameSize();
        int n = this.newFrameSize = this.getFormat().getFrameSize() <= 0 ? 1 : this.getFormat().getFrameSize();
        if (TDebug.TraceAudioConverter) {
            TDebug.out("TSynchronousFilteredAudioInputStream: original format =" + AudioUtils.format2ShortStr(this.originalFormat));
            TDebug.out("TSynchronousFilteredAudioInputStream: converted format=" + AudioUtils.format2ShortStr(this.getFormat()));
        }
        this.m_bConvertInPlace = false;
    }

    protected boolean enableConvertInPlace() {
        if (this.newFrameSize >= this.originalFrameSize) {
            this.m_bConvertInPlace = true;
        }
        return this.m_bConvertInPlace;
    }

    protected abstract int convert(byte[] var1, byte[] var2, int var3, int var4);

    protected void convertInPlace(byte[] byArray, int n, int n2) {
        throw new RuntimeException("Illegal call to convertInPlace");
    }

    public int read() throws IOException {
        if (this.newFrameSize != 1) {
            throw new IOException("frame size must be 1 to read a single byte");
        }
        byte[] byArray = new byte[1];
        int n = this.read(byArray);
        if (n == -1) {
            return -1;
        }
        if (n == 0) {
            return -1;
        }
        return byArray[0] & 0xFF;
    }

    private void clearBuffer() {
        this.buffer = null;
    }

    public AudioInputStream getOriginalStream() {
        return this.originalStream;
    }

    public AudioFormat getOriginalFormat() {
        return this.originalFormat;
    }

    public int read(byte[] byArray, int n, int n2) throws IOException {
        int n3;
        byte[] byArray2;
        int n4 = n2 / this.newFrameSize;
        int n5 = n4 * this.originalFrameSize;
        if (TDebug.TraceAudioConverter) {
            TDebug.out("> TSynchronousFilteredAIS.read(buffer[" + byArray.length + "], " + n + " ," + n2 + " bytes ^=" + n4 + " frames)");
        }
        int n6 = 0;
        if (this.m_bConvertInPlace) {
            byArray2 = byArray;
            n3 = n;
        } else {
            if (this.buffer == null || this.buffer.length < n5) {
                this.buffer = new byte[n5];
            }
            byArray2 = this.buffer;
            n3 = 0;
        }
        int n7 = this.originalStream.read(byArray2, n3, n5);
        if (n7 == -1) {
            this.clearBuffer();
            return -1;
        }
        int n8 = n7 / this.originalFrameSize;
        if (TDebug.TraceAudioConverter) {
            TDebug.out("original.read returned " + n7 + " bytes ^=" + n8 + " frames");
        }
        if (this.m_bConvertInPlace) {
            this.convertInPlace(byArray, n, n8);
            n6 = n8;
        } else {
            n6 = this.convert(this.buffer, byArray, n, n8);
        }
        if (TDebug.TraceAudioConverter) {
            TDebug.out("< converted " + n6 + " frames");
        }
        return n6 * this.newFrameSize;
    }

    public long skip(long l) throws IOException {
        long l2 = l / (long)this.newFrameSize;
        long l3 = this.originalStream.skip(l2 * (long)this.originalFrameSize);
        long l4 = l3 / (long)this.originalFrameSize;
        return l4 * (long)this.newFrameSize;
    }

    public int available() throws IOException {
        int n = this.originalStream.available() / this.originalFrameSize;
        return n * this.newFrameSize;
    }

    public void close() throws IOException {
        this.originalStream.close();
        this.clearBuffer();
    }

    public void mark(int n) {
        int n2 = n / this.newFrameSize;
        this.originalStream.mark(n2 * this.originalFrameSize);
    }

    public void reset() throws IOException {
        this.originalStream.reset();
    }

    public boolean markSupported() {
        return this.originalStream.markSupported();
    }

    private int getFrameSize() {
        return this.getFormat().getFrameSize();
    }
}

