/*
 * Decompiled with CFR 0.152.
 */
package edu.xtec.util;

import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.StringTokenizer;
import java.util.Vector;

public abstract class StrUtils {
    public static void strToIntArray(String string, int[] nArray) {
        if (string == null || nArray == null) {
            return;
        }
        int n = 0;
        StringTokenizer stringTokenizer = new StringTokenizer(string, ",", false);
        while (stringTokenizer.hasMoreTokens() && n < nArray.length) {
            try {
                nArray[n] = Integer.parseInt(stringTokenizer.nextToken().trim());
            }
            catch (Exception exception) {
                // empty catch block
            }
            ++n;
        }
    }

    public static void strToPoint(String string, Point point) {
        int[] nArray = new int[2];
        StrUtils.strToIntArray(string, nArray);
        point.x = nArray[0];
        point.y = nArray[1];
    }

    public static void strToDimension(String string, Dimension dimension) {
        int[] nArray = new int[2];
        StrUtils.strToIntArray(string, nArray);
        dimension.width = nArray[0];
        dimension.height = nArray[1];
    }

    public static void strToRect(String string, Rectangle rectangle) {
        int[] nArray = new int[4];
        StrUtils.strToIntArray(string, nArray);
        rectangle.setBounds(nArray[0], nArray[1], nArray[2], nArray[3]);
    }

    public static String[] strToStrArray(String string, String string2) {
        String[] stringArray;
        if (string == null || string2 == null) {
            return null;
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string, string2, true);
        Vector<Object> vector = new Vector<Object>();
        while (stringTokenizer.hasMoreTokens()) {
            stringArray = stringTokenizer.nextToken();
            if (string2.equals(stringArray)) {
                vector.add(new String());
                continue;
            }
            vector.add(stringArray);
            if (!stringTokenizer.hasMoreTokens()) continue;
            stringTokenizer.nextToken();
        }
        stringArray = new String[vector.size()];
        stringArray = vector.toArray(stringArray);
        return stringArray;
    }

    public static String[] strToStrArrayNoNulls(String string, String string2) throws Exception {
        String[] stringArray = StrUtils.strToStrArray(string, string2);
        if (stringArray == null || stringArray.length == 0) {
            throw new Exception("Invalid parameter: " + string);
        }
        int n = 0;
        while (n < stringArray.length) {
            if (stringArray[n] == null || stringArray[n].length() == 0) {
                throw new Exception("Invalid parameter: " + string);
            }
            ++n;
        }
        return stringArray;
    }

    public static byte[] extractByteSeq(byte[] byArray, int n, byte by, byte by2) {
        byte[] byArray2 = null;
        int n2 = byArray.length;
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        int n6 = 0;
        while (n6 < n2) {
            if (byArray[n6] == 13 && n6 < n2 && byArray[n6 + 1] == 10) {
                n4 = n5 == 0 ? n5 : n5 + 2;
                n5 = n6;
                if (n3 == n) break;
                ++n3;
            }
            ++n6;
        }
        if (n5 > n4) {
            int n7 = n5 - n4;
            byArray2 = new byte[n7];
            int n8 = 0;
            while (n8 < n7) {
                byArray2[n8] = byArray[n4 + n8];
                if (byArray2[n8] == by) {
                    byArray2[n8] = by2;
                }
                ++n8;
            }
        }
        return byArray2;
    }

    public static int roundTo(double d, int n) {
        return (int)(d / (double)n) * n;
    }

    public static int countSpaces(String string) {
        String string2 = string.trim();
        int n = 0;
        int n2 = 0;
        while (n2 < string2.length()) {
            if (string2.charAt(n2) == ' ') {
                ++n;
            }
            ++n2;
        }
        return n;
    }

    public static boolean compareStringsIgnoreCase(String string, String string2) {
        if (string == null && string2 == null) {
            return true;
        }
        if (string == null || string2 == null) {
            return false;
        }
        return string.compareToIgnoreCase(string2) == 0;
    }

    public static boolean compareTrimStringsIgnoreCase(Object object, Object object2) {
        if (object == null) {
            object = "";
        }
        if (object2 == null) {
            object2 = "";
        }
        return object.toString().trim().compareToIgnoreCase(object2.toString().trim()) == 0;
    }

    public static boolean compareObjects(Object object, Object object2) {
        if (object == null && object2 == null) {
            return true;
        }
        if (object == null || object2 == null) {
            return false;
        }
        return object.equals(object2);
    }

    public static String replace(String string, String string2, String string3) {
        int n = 0;
        int n2 = 0;
        if (string == null) {
            string = "";
        }
        StringBuffer stringBuffer = new StringBuffer();
        while ((n2 = string.indexOf(string2, n)) >= 0) {
            stringBuffer.append(string.substring(n, n2));
            if (string3 != null) {
                stringBuffer.append(string3);
            }
            n = n2 + string2.length();
        }
        stringBuffer.append(string.substring(n));
        return stringBuffer.substring(0);
    }

    public static boolean compareMultipleOptions(String string, String string2, boolean bl) {
        if (string == null || string.length() == 0 || string2 == null || string2.length() == 0) {
            return false;
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string2, "|");
        while (stringTokenizer.hasMoreTokens()) {
            if (!(bl ? stringTokenizer.nextToken().equals(string) : stringTokenizer.nextToken().equalsIgnoreCase(string))) continue;
            return true;
        }
        return false;
    }

    public static String secureString(Object object) {
        if (object == null) {
            return new String();
        }
        return object.toString();
    }

    public static String secureString(Object object, String string) {
        String string2 = StrUtils.nullableString(object);
        return string2 == null ? string : string2;
    }

    public static String nullableString(Object object) {
        String string = null;
        if (object != null && (string = object.toString().trim()).length() == 0) {
            string = null;
        }
        return string;
    }

    public static String trimEnding(String string) {
        String string2 = string;
        if (string2 != null) {
            int n;
            int n2 = n = string2.length() - 1;
            while (n >= 0) {
                char c = string2.charAt(n);
                if (c != ' ' && c != '\n' && c != '\r') break;
                --n;
            }
            if (n != n2) {
                string2 = string2.substring(0, n + 1);
            }
        }
        return string2;
    }

    public static String secureSQLString(String string) {
        return StrUtils.replace(StrUtils.secureString(string), "'", "''");
    }

    public static int getAbsIntValueOf(String string) {
        int n = -1;
        if (string != null && string.length() > 0) {
            int n2 = 0;
            while (n2 < string.length()) {
                char c = string.charAt(n2);
                if (c < '0' || c > '9') {
                    return n;
                }
                ++n2;
            }
            try {
                n = Integer.parseInt(string);
            }
            catch (NumberFormatException numberFormatException) {
                n = -1;
            }
        }
        return n;
    }

    public static String getShortExpression(String string, int n) {
        String string2 = StrUtils.secureString(string).trim();
        if (n > 0 && string2.length() > n) {
            string2 = string2.substring(0, n);
            int n2 = n - 1;
            while (n2 > 2 * n / 3) {
                if (Character.isSpaceChar(string2.charAt(n2))) {
                    string2 = string2.substring(0, n2) + "...";
                    break;
                }
                --n2;
            }
        }
        return string2;
    }
}

