/*
 * Decompiled with CFR 0.152.
 */
package org.jdom.input;

import org.jdom.Attribute;
import org.jdom.DefaultJDOMFactory;
import org.jdom.DocType;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.EntityRef;
import org.jdom.JDOMFactory;
import org.jdom.Namespace;
import org.w3c.dom.Attr;
import org.w3c.dom.DocumentType;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class DOMBuilder {
    private static final String CVS_ID = "@(#) $RCSfile: DOMBuilder.java,v $ $Revision: 1.59 $ $Date: 2004/09/03 06:03:41 $ $Name: jdom_1_0 $";
    private String adapterClass;
    private JDOMFactory factory = new DefaultJDOMFactory();

    public DOMBuilder() {
    }

    public DOMBuilder(String string) {
        this.adapterClass = string;
    }

    public void setFactory(JDOMFactory jDOMFactory) {
        this.factory = jDOMFactory;
    }

    public JDOMFactory getFactory() {
        return this.factory;
    }

    public Document build(org.w3c.dom.Document document) {
        Document document2 = this.factory.document(null);
        this.buildTree(document, document2, null, true);
        return document2;
    }

    public Element build(org.w3c.dom.Element element) {
        Document document = this.factory.document(null);
        this.buildTree(element, document, null, true);
        return document.getRootElement();
    }

    private void buildTree(Node node, Document document, Element element, boolean bl) {
        switch (node.getNodeType()) {
            case 9: {
                NodeList nodeList = node.getChildNodes();
                int n = 0;
                int n2 = nodeList.getLength();
                while (n < n2) {
                    this.buildTree(nodeList.item(n), document, element, true);
                    ++n;
                }
                break;
            }
            case 1: {
                Object object;
                String string;
                String string2;
                Object object2;
                String string3 = node.getNodeName();
                String string4 = "";
                String string5 = string3;
                int n = string3.indexOf(58);
                if (n >= 0) {
                    string4 = string3.substring(0, n);
                    string5 = string3.substring(n + 1);
                }
                Namespace namespace = null;
                String string6 = node.getNamespaceURI();
                namespace = string6 == null ? (element == null ? Namespace.NO_NAMESPACE : element.getNamespace(string4)) : Namespace.getNamespace(string4, string6);
                Element element2 = this.factory.element(string5, namespace);
                if (bl) {
                    document.setRootElement(element2);
                } else {
                    this.factory.addContent(element, element2);
                }
                NamedNodeMap namedNodeMap = node.getAttributes();
                int n3 = namedNodeMap.getLength();
                int n4 = 0;
                while (n4 < n3) {
                    Attr attr = (Attr)namedNodeMap.item(n4);
                    object2 = attr.getName();
                    if (((String)object2).startsWith("xmlns")) {
                        string2 = "";
                        n = ((String)object2).indexOf(58);
                        if (n >= 0) {
                            string2 = ((String)object2).substring(n + 1);
                        }
                        string = attr.getValue();
                        object = Namespace.getNamespace(string2, string);
                        if (string4.equals(string2)) {
                            element2.setNamespace((Namespace)object);
                        } else {
                            this.factory.addNamespaceDeclaration(element2, (Namespace)object);
                        }
                    }
                    ++n4;
                }
                int n5 = 0;
                while (n5 < n3) {
                    object2 = (Attr)namedNodeMap.item(n5);
                    string2 = object2.getName();
                    if (!string2.startsWith("xmlns")) {
                        string = "";
                        object = string2;
                        n = string2.indexOf(58);
                        if (n >= 0) {
                            string = string2.substring(0, n);
                            object = string2.substring(n + 1);
                        }
                        String string7 = object2.getValue();
                        Namespace namespace2 = null;
                        namespace2 = "".equals(string) ? Namespace.NO_NAMESPACE : element2.getNamespace(string);
                        Attribute attribute = this.factory.attribute((String)object, string7, namespace2);
                        this.factory.setAttribute(element2, attribute);
                    }
                    ++n5;
                }
                object2 = node.getChildNodes();
                if (object2 == null) break;
                int n6 = object2.getLength();
                int n7 = 0;
                while (n7 < n6) {
                    object = object2.item(n7);
                    if (object != null) {
                        this.buildTree((Node)object, document, element2, false);
                    }
                    ++n7;
                }
                break;
            }
            case 3: {
                String string = node.getNodeValue();
                this.factory.addContent(element, this.factory.text(string));
                break;
            }
            case 4: {
                String string = node.getNodeValue();
                this.factory.addContent(element, this.factory.cdata(string));
                break;
            }
            case 7: {
                if (bl) {
                    this.factory.addContent(document, this.factory.processingInstruction(node.getNodeName(), node.getNodeValue()));
                    break;
                }
                this.factory.addContent(element, this.factory.processingInstruction(node.getNodeName(), node.getNodeValue()));
                break;
            }
            case 8: {
                if (bl) {
                    this.factory.addContent(document, this.factory.comment(node.getNodeValue()));
                    break;
                }
                this.factory.addContent(element, this.factory.comment(node.getNodeValue()));
                break;
            }
            case 5: {
                EntityRef entityRef = this.factory.entityRef(node.getNodeName());
                this.factory.addContent(element, entityRef);
                break;
            }
            case 6: {
                break;
            }
            case 10: {
                DocumentType documentType = (DocumentType)node;
                String string = documentType.getPublicId();
                String string8 = documentType.getSystemId();
                String string9 = documentType.getInternalSubset();
                DocType docType = this.factory.docType(documentType.getName());
                docType.setPublicID(string);
                docType.setSystemID(string8);
                docType.setInternalSubset(string9);
                this.factory.addContent(document, docType);
            }
        }
    }
}

