/*
 * Decompiled with CFR 0.152.
 */
package edu.xtec.jclic.boxes;

import edu.xtec.jclic.boxes.BoxBase;
import edu.xtec.util.Domable;
import edu.xtec.util.JDomUtility;
import java.awt.Color;
import java.util.Iterator;
import org.jdom.Content;
import org.jdom.Element;

public class TextGridContent
implements Domable {
    public static final char DEFAULT_WILD = '*';
    public static final String DEFAULT_RANDOM_CHARS = "ABCDEFGHIJKLMNOPQRSTUVWXYZ";
    public int ncw = 1;
    public int nch = 1;
    public double w = 20.0;
    public double h = 20.0;
    public boolean border = false;
    public BoxBase bb = null;
    public String[] text = new String[1];
    public char wild = (char)42;
    public String randomChars = "ABCDEFGHIJKLMNOPQRSTUVWXYZ";
    public static final String ELEMENT_NAME = "textGrid";
    public static final String ROWS = "rows";
    public static final String COLUMNS = "columns";
    public static final String CELL_WIDTH = "cellWidth";
    public static final String CELL_HEIGHT = "cellHeight";
    public static final String BORDER = "border";
    public static final String ROW = "row";
    public static final String TEXT = "text";
    public static final String WILD = "wild";
    public static final String RANDOM_CHARS = "randomChars";

    public static TextGridContent initNew(int n, int n2, char c) {
        TextGridContent textGridContent = new TextGridContent();
        textGridContent.ncw = n;
        textGridContent.nch = n2;
        textGridContent.text = new String[n2];
        StringBuffer stringBuffer = new StringBuffer();
        int n3 = 0;
        while (n3 < n2) {
            stringBuffer.setLength(0);
            int n4 = 0;
            while (n4 < n) {
                char c2 = c;
                c = (char)(c + '\u0001');
                stringBuffer.append(c2);
                ++n4;
            }
            textGridContent.text[n3] = new String(stringBuffer.toString());
            ++n3;
        }
        textGridContent.bb = new BoxBase();
        textGridContent.bb.backColor = Color.white;
        textGridContent.border = true;
        return textGridContent;
    }

    public Element getJDomElement() {
        Element element = new Element(ELEMENT_NAME);
        element.setAttribute(ROWS, Integer.toString(this.ncw));
        element.setAttribute(COLUMNS, Integer.toString(this.nch));
        element.setAttribute(CELL_WIDTH, Double.toString(this.w));
        element.setAttribute(CELL_HEIGHT, Double.toString(this.h));
        element.setAttribute(BORDER, JDomUtility.boolString((boolean)this.border));
        if (this.wild != '*') {
            new String();
            element.setAttribute(WILD, String.copyValueOf(new char[]{this.wild}));
        }
        if (this.randomChars != DEFAULT_RANDOM_CHARS) {
            element.setAttribute(RANDOM_CHARS, this.randomChars);
        }
        if (this.bb != null) {
            element.addContent((Content)this.bb.getJDomElement());
        }
        Element element2 = new Element(TEXT);
        int n = 0;
        while (n < this.nch) {
            if (n < this.text.length) {
                element2.addContent((Content)new Element(ROW).setText(this.text[n]));
            }
            ++n;
        }
        element.addContent((Content)element2);
        return element;
    }

    public static TextGridContent getTextGridContent(Element element) throws Exception {
        TextGridContent textGridContent = new TextGridContent();
        textGridContent.setProperties(element, null);
        return textGridContent;
    }

    public void setProperties(Element element, Object object) throws Exception {
        JDomUtility.checkName((Element)element, (String)ELEMENT_NAME);
        this.ncw = JDomUtility.getIntAttr((Element)element, (String)ROWS, (int)this.ncw);
        this.nch = JDomUtility.getIntAttr((Element)element, (String)COLUMNS, (int)this.nch);
        this.w = JDomUtility.getDoubleAttr((Element)element, (String)CELL_WIDTH, (double)this.w);
        this.h = JDomUtility.getDoubleAttr((Element)element, (String)CELL_HEIGHT, (double)this.h);
        if (this.ncw < 1 || this.nch < 1 || this.w < 1.0 || this.h < 1.0) {
            throw new IllegalArgumentException("Invalid TextGridContent attributes!");
        }
        String string = element.getAttributeValue(WILD);
        if (string != null && string.length() > 0) {
            this.wild = string.charAt(0);
        }
        this.randomChars = JDomUtility.getStringAttr((Element)element, (String)RANDOM_CHARS, (String)this.randomChars, (boolean)false);
        this.border = JDomUtility.getBoolAttr((Element)element, (String)BORDER, (boolean)this.border);
        Element element2 = element.getChild("style");
        if (element2 != null) {
            this.bb = BoxBase.getBoxBase(element2);
        }
        if ((element2 = element.getChild(TEXT)) != null) {
            this.text = new String[this.nch];
            Iterator iterator = element2.getChildren(ROW).iterator();
            int n = 0;
            while (iterator.hasNext()) {
                Element element3 = (Element)iterator.next();
                this.text[n++] = element3.getText();
            }
            while (n < this.nch) {
                this.text[n] = "";
                ++n;
            }
        }
    }

    public void completeText() {
        String[] stringArray = null;
        char[] cArray = new char[this.ncw];
        int n = 0;
        while (n < this.ncw) {
            cArray[n] = this.wild;
            ++n;
        }
        stringArray = new String[this.nch];
        int n2 = 0;
        while (n2 < this.nch) {
            StringBuffer stringBuffer = new StringBuffer();
            if (n2 < this.text.length) {
                char[] cArray2 = this.text[n2].toCharArray();
                stringBuffer.append(cArray2, 0, Math.min(cArray2.length, this.ncw));
                int n3 = stringBuffer.length();
                if (n3 < this.ncw) {
                    stringBuffer.append(cArray, 0, this.ncw - n3);
                }
                stringArray[n2] = stringBuffer.substring(0);
            } else {
                stringArray[n2] = String.copyValueOf(cArray);
            }
            ++n2;
        }
        this.text = stringArray;
    }

    public int countWildChars() {
        int n = 0;
        this.completeText();
        if (this.text != null) {
            int n2 = 0;
            while (n2 < this.nch) {
                int n3 = 0;
                while (n3 < this.ncw) {
                    if (this.text[n2].charAt(n3) == this.wild) {
                        ++n;
                    }
                    ++n3;
                }
                ++n2;
            }
        }
        return n;
    }

    public int getNumChars() {
        return this.ncw * this.nch;
    }

    public void setCharAt(int n, int n2, char c) {
        if (n >= 0 && n < this.ncw && n2 >= 0 && n2 < this.nch) {
            StringBuffer stringBuffer = new StringBuffer(this.text[n2]);
            stringBuffer.setCharAt(n, c);
            this.text[n2] = stringBuffer.substring(0);
        }
    }

    public void copyStyleTo(TextGridContent textGridContent) {
        if (textGridContent != null) {
            textGridContent.w = this.w;
            textGridContent.h = this.h;
            textGridContent.border = this.border;
            textGridContent.bb = this.bb;
        }
    }
}

