/*
 * Decompiled with CFR 0.152.
 */
package edu.xtec.jclic.project;

import edu.xtec.util.Domable;
import edu.xtec.util.Html;
import edu.xtec.util.JDomUtility;
import edu.xtec.util.Messages;
import org.jdom.Element;

public class Author
implements Domable {
    public String name = new String();
    public String mail = null;
    public String url = null;
    public String organization = null;
    public String comments = null;
    public String rol = null;
    public static final String ELEMENT_NAME = "author";
    public static final String NAME = "name";
    public static final String MAIL = "mail";
    public static final String URL = "url";
    public static final String ORGANIZATION = "organization";
    public static final String COMMENTS = "comments";
    public static final String ROL = "rol";

    public Element getJDomElement() {
        Element element = new Element(ELEMENT_NAME);
        element.setAttribute(NAME, this.name);
        if (this.mail != null) {
            element.setAttribute(MAIL, this.mail);
        }
        if (this.url != null) {
            element.setAttribute(URL, this.url);
        }
        if (this.rol != null) {
            element.setAttribute(ROL, this.rol);
        }
        if (this.organization != null) {
            element.setAttribute(ORGANIZATION, this.organization);
        }
        if (this.comments != null) {
            JDomUtility.addParagraphs((Element)element, (String)COMMENTS, (String)this.comments);
        }
        return element;
    }

    public static Author getAuthor(Element element) throws Exception {
        JDomUtility.checkName((Element)element, (String)ELEMENT_NAME);
        Author author = new Author();
        author.name = JDomUtility.getStringAttr((Element)element, (String)NAME, (String)author.name, (boolean)true);
        author.mail = JDomUtility.getStringAttr((Element)element, (String)MAIL, (String)author.mail, (boolean)false);
        author.url = JDomUtility.getStringAttr((Element)element, (String)URL, (String)author.url, (boolean)false);
        author.rol = JDomUtility.getStringAttr((Element)element, (String)ROL, (String)author.rol, (boolean)false);
        author.organization = JDomUtility.getStringAttr((Element)element, (String)ORGANIZATION, (String)author.organization, (boolean)false);
        author.comments = JDomUtility.getParagraphs((Element)element.getChild(COMMENTS));
        return author;
    }

    public void setProperties(Element element, Object object) throws Exception {
        JDomUtility.checkName((Element)element, (String)ELEMENT_NAME);
        this.name = JDomUtility.getStringAttr((Element)element, (String)NAME, (String)this.name, (boolean)true);
        this.mail = JDomUtility.getStringAttr((Element)element, (String)MAIL, (String)this.mail, (boolean)false);
        this.url = JDomUtility.getStringAttr((Element)element, (String)URL, (String)this.url, (boolean)false);
        this.rol = JDomUtility.getStringAttr((Element)element, (String)ROL, (String)this.rol, (boolean)false);
        this.organization = JDomUtility.getStringAttr((Element)element, (String)ORGANIZATION, (String)this.organization, (boolean)false);
        this.comments = JDomUtility.getParagraphs((Element)element.getChild(COMMENTS));
    }

    public String toHtmlString(Messages messages) {
        Html html = new Html(500);
        if (this.rol != null) {
            html.append(this.rol).append(": ");
        }
        html.append(this.name);
        if (this.mail != null && this.mail.length() > 0) {
            html.sp().mailTo(this.mail, true);
        }
        if (this.url != null && this.url.length() > 0) {
            html.br().linkTo(this.url, null);
        }
        if (this.organization != null && this.organization.length() > 0) {
            html.br().appendParagraphs(this.organization);
        }
        if (this.comments != null && this.comments.length() > 0) {
            html.br().appendParagraphs(this.comments);
        }
        return html.toString();
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer(this.name);
        if (this.rol != null && this.rol.length() > 0) {
            stringBuffer.append(" (").append(this.rol).append(")");
        }
        return stringBuffer.substring(0);
    }
}

