/*
 * Decompiled with CFR 0.152.
 */
package edu.xtec.jclic.shapers;

import edu.xtec.jclic.boxes.BoxBase;
import edu.xtec.jclic.shapers.ShapeData;
import edu.xtec.util.Domable;
import edu.xtec.util.JDomUtility;
import edu.xtec.util.Options;
import edu.xtec.util.TripleString;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Image;
import java.awt.Shape;
import java.awt.geom.GeneralPath;
import java.awt.geom.Rectangle2D;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.Vector;
import org.jdom.Element;

public abstract class Shaper
implements Cloneable,
Domable {
    protected final double WIDTH = 1.0;
    protected final double HEIGHT = 1.0;
    protected static final String DELIM = "|";
    protected int nCols;
    protected int nRows;
    protected int nCells;
    protected ShapeData[] shapeData;
    protected boolean initiated = false;
    public static final String ELEMENT_NAME = "shaper";
    public static final String COLS = "cols";
    public static final String ROWS = "rows";
    public static final String BASE_CLASS = "edu.xtec.jclic.shapers.";
    public static final String BASE_CLASS_TAG = "@";
    public static final String SYSTEM_LIST = "shapers.listshapers";
    static /* synthetic */ Class class$edu$xtec$jclic$shapers$Shaper;
    static /* synthetic */ Class class$java$awt$Component;
    static /* synthetic */ Class class$edu$xtec$util$Options;
    static /* synthetic */ Class class$java$awt$Dimension;
    static /* synthetic */ Class class$java$awt$Image;
    static /* synthetic */ Class class$edu$xtec$jclic$boxes$BoxBase;

    public Shaper(int n, int n2) {
        this.reset(n, n2);
    }

    public void reset(int n, int n2) {
        this.nCols = n;
        this.nRows = n2;
        this.nCells = n2 * n;
        this.initiated = false;
        this.shapeData = new ShapeData[this.nCells];
        int n3 = 0;
        while (n3 < this.nCells) {
            this.shapeData[n3] = new ShapeData();
            ++n3;
        }
    }

    public void reset() {
        this.reset(this.nCols, this.nRows);
    }

    public Element getJDomElement() {
        Element element = new Element(ELEMENT_NAME);
        element.setAttribute("class", this.getClassName());
        element.setAttribute(COLS, Integer.toString(this.nCols));
        element.setAttribute(ROWS, Integer.toString(this.nRows));
        return element;
    }

    public String getClassName() {
        String string = this.getClass().getName();
        if (string.startsWith(BASE_CLASS)) {
            string = BASE_CLASS_TAG + string.substring(BASE_CLASS.length());
        }
        return string;
    }

    public static Shaper getShaper(Element element) throws Exception {
        JDomUtility.checkName((Element)element, (String)ELEMENT_NAME);
        String string = JDomUtility.getClassName((Element)element);
        int n = JDomUtility.getIntAttr((Element)element, (String)COLS, (int)1);
        int n2 = JDomUtility.getIntAttr((Element)element, (String)ROWS, (int)1);
        Shaper shaper = Shaper.createShaper(string, n, n2);
        shaper.setProperties(element, null);
        return shaper;
    }

    public static Shaper createShaper(String string, int n, int n2) throws Exception {
        if (string.startsWith(BASE_CLASS_TAG)) {
            string = BASE_CLASS + string.substring(1);
        }
        Shaper shaper = null;
        Class[] classArray = new Class[]{Integer.TYPE, Integer.TYPE};
        Object[] objectArray = new Object[]{new Integer(n), new Integer(n2)};
        Class<?> clazz = Class.forName(string);
        Constructor<?> constructor = clazz.getConstructor(classArray);
        shaper = (Shaper)constructor.newInstance(objectArray);
        return shaper;
    }

    protected abstract void buildShapes();

    public boolean rectangularShapes() {
        return false;
    }

    public String getEditorPanelClassName() {
        return null;
    }

    public Shaper edit(Component component, Options options, Dimension dimension, Image image, BoxBase boxBase) {
        Shaper shaper = null;
        if (this.getEditorPanelClassName() != null) {
            try {
                Class<?> clazz = Class.forName(this.getEditorPanelClassName());
                Method method = clazz.getMethod("getShaper", class$edu$xtec$jclic$shapers$Shaper == null ? (class$edu$xtec$jclic$shapers$Shaper = Shaper.class$("edu.xtec.jclic.shapers.Shaper")) : class$edu$xtec$jclic$shapers$Shaper, class$java$awt$Component == null ? (class$java$awt$Component = Shaper.class$("java.awt.Component")) : class$java$awt$Component, class$edu$xtec$util$Options == null ? (class$edu$xtec$util$Options = Shaper.class$("edu.xtec.util.Options")) : class$edu$xtec$util$Options, class$java$awt$Dimension == null ? (class$java$awt$Dimension = Shaper.class$("java.awt.Dimension")) : class$java$awt$Dimension, class$java$awt$Image == null ? (class$java$awt$Image = Shaper.class$("java.awt.Image")) : class$java$awt$Image, class$edu$xtec$jclic$boxes$BoxBase == null ? (class$edu$xtec$jclic$boxes$BoxBase = Shaper.class$("edu.xtec.jclic.boxes.BoxBase")) : class$edu$xtec$jclic$boxes$BoxBase);
                shaper = (Shaper)method.invoke(null, this, component, options, dimension, image, boxBase);
            }
            catch (Exception exception) {
                options.getMessages().showErrorWarning(component, "edit_act_shaper_err", exception);
            }
        }
        return shaper;
    }

    public void setProperties(Element element, Object object) throws Exception {
    }

    public Shape getShape(int n, Rectangle2D rectangle2D) {
        if (!this.initiated) {
            this.buildShapes();
        }
        if (n >= this.nCells || this.shapeData[n] == null) {
            return null;
        }
        return this.shapeData[n].getShape(rectangle2D);
    }

    public ShapeData getShapeData(int n) {
        return n >= 0 && n < this.shapeData.length ? this.shapeData[n] : null;
    }

    protected ShapeData getEnclosingShapeData() {
        ShapeData shapeData = new ShapeData();
        shapeData.moveTo(0.0, 0.0);
        shapeData.lineTo(1.0, 0.0);
        shapeData.lineTo(1.0, 1.0);
        shapeData.lineTo(0.0, 1.0);
        shapeData.closePath();
        return shapeData;
    }

    public boolean hasRemainder() {
        return false;
    }

    public Shape getRemainderShape(Rectangle2D rectangle2D) {
        if (!this.hasRemainder()) {
            return null;
        }
        if (!this.initiated) {
            this.buildShapes();
        }
        GeneralPath generalPath = (GeneralPath)this.getEnclosingShapeData().getShape(rectangle2D);
        generalPath.setWindingRule(0);
        int n = 0;
        while (n < this.nCells) {
            if (this.shapeData[n] != null) {
                generalPath.append(this.shapeData[n].getShape(rectangle2D), false);
            }
            ++n;
        }
        return generalPath;
    }

    public int getNumRows() {
        return this.nRows;
    }

    public void setNumRows(int n) {
        if (n > 0 && n != this.nRows) {
            this.reset(this.nCols, n);
        }
    }

    public int getNumColumns() {
        return this.nCols;
    }

    public void setNumColumns(int n) {
        if (n > 0 && n != this.nCols) {
            this.reset(this.nRows, n);
        }
    }

    public int getNumCells() {
        return this.nCells;
    }

    public static Vector getSystemShaperList(Options options) {
        Vector vector = new Vector();
        try {
            vector = TripleString.getTripleList((String)SYSTEM_LIST, (Options)options, (boolean)false, (boolean)true, (boolean)true);
        }
        catch (Exception exception) {
            System.err.println("Error reading list of shapers!\n" + exception);
        }
        return vector;
    }

    public Object clone() throws CloneNotSupportedException {
        Shaper shaper = (Shaper)super.clone();
        shaper.shapeData = (ShapeData[])this.shapeData.clone();
        int n = 0;
        while (n < this.shapeData.length) {
            if (this.shapeData[n] != null) {
                shaper.shapeData[n] = (ShapeData)this.shapeData[n].clone();
            }
            ++n;
        }
        return shaper;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

