/*
 * Decompiled with CFR 0.152.
 */
package freemind.main;

import java.awt.Color;
import java.awt.GraphicsEnvironment;
import java.awt.Point;
import java.io.File;
import java.net.URL;
import java.util.Arrays;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.Vector;

public class Tools {
    public static final Set executableExtensions = new HashSet<String>(Arrays.asList("exe", "com", "vbs", "bat", "lnk"));
    private static Set availableFontFamilyNames = null;

    public static boolean executableByExtension(String file) {
        return executableExtensions.contains(Tools.getExtension(file));
    }

    public static String colorToXml(Color col) {
        if (col == null) {
            throw new IllegalArgumentException("Color was null");
        }
        String red = Integer.toHexString(col.getRed());
        if (col.getRed() < 16) {
            red = "0" + red;
        }
        String green = Integer.toHexString(col.getGreen());
        if (col.getGreen() < 16) {
            green = "0" + green;
        }
        String blue = Integer.toHexString(col.getBlue());
        if (col.getBlue() < 16) {
            blue = "0" + blue;
        }
        return "#" + red + green + blue;
    }

    public static Color xmlToColor(String string) {
        int red = Integer.parseInt(string.substring(1, 3), 16);
        int green = Integer.parseInt(string.substring(3, 5), 16);
        int blue = Integer.parseInt(string.substring(5, 7), 16);
        return new Color(red, green, blue);
    }

    public static String PointToXml(Point col) {
        if (col == null) {
            throw new IllegalArgumentException("Point was null");
        }
        Vector<String> l = new Vector<String>();
        l.add(Integer.toString(col.x));
        l.add(Integer.toString(col.y));
        return Tools.listToString(l);
    }

    public static Point xmlToPoint(String string) {
        List l = Tools.stringToList(string);
        ListIterator it = l.listIterator(0);
        if (l.size() != 2) {
            throw new IllegalArgumentException("A point must consist of two numbers (and not: '" + string + "').");
        }
        int x = Integer.parseInt((String)it.next());
        int y = Integer.parseInt((String)it.next());
        return new Point(x, y);
    }

    public static String BooleanToXml(boolean col) {
        return col ? "true" : "false";
    }

    public static boolean xmlToBoolean(String string) {
        return string.equals("true");
    }

    public static List stringToList(String string) {
        StringTokenizer tok = new StringTokenizer(string, ";");
        LinkedList<String> list = new LinkedList<String>();
        while (tok.hasMoreTokens()) {
            list.add(tok.nextToken());
        }
        return list;
    }

    public static String listToString(List list) {
        ListIterator it = list.listIterator(0);
        String str = new String();
        while (it.hasNext()) {
            str.concat(it.next().toString() + ";");
        }
        return str;
    }

    public static String expandFileName(String file) {
        if (file.startsWith("~")) {
            file = System.getProperty("user.home") + file.substring(1);
        }
        return file;
    }

    public static Set getAvailableFontFamilyNames() {
        if (availableFontFamilyNames == null) {
            GraphicsEnvironment gEnv = GraphicsEnvironment.getLocalGraphicsEnvironment();
            String[] envFonts = gEnv.getAvailableFontFamilyNames();
            availableFontFamilyNames = new HashSet();
            for (int i = 0; i < envFonts.length; ++i) {
                availableFontFamilyNames.add(envFonts[i]);
            }
            availableFontFamilyNames.add("dialog");
        }
        return availableFontFamilyNames;
    }

    public static Vector getAvailableFontFamilyNamesAsVector() {
        GraphicsEnvironment gEnv = GraphicsEnvironment.getLocalGraphicsEnvironment();
        String[] envFonts = gEnv.getAvailableFontFamilyNames();
        Vector<String> availableFontFamilyNames = new Vector<String>();
        for (int i = 0; i < envFonts.length; ++i) {
            availableFontFamilyNames.add(envFonts[i]);
        }
        return availableFontFamilyNames;
    }

    public static boolean isAvailableFontFamily(String fontFamilyName) {
        return Tools.getAvailableFontFamilyNames().contains(fontFamilyName);
    }

    public static String getExtension(File f) {
        return Tools.getExtension(f.toString());
    }

    public static String getExtension(String s) {
        int i = s.lastIndexOf(46);
        return i > 0 && i < s.length() - 1 ? s.substring(i + 1).toLowerCase().trim() : "";
    }

    public static String removeExtension(String s) {
        int i = s.lastIndexOf(46);
        return i > 0 && i < s.length() - 1 ? s.substring(0, i) : "";
    }

    public static String toXMLEscapedText(String text) {
        return text.replaceAll("&", "&amp;").replaceAll("<", "&lt;").replaceAll(">", "&gt;").replaceAll("\"", "&quot;");
    }

    public static String toXMLUnescapedText(String text) {
        return text.replaceAll("&lt;", "<").replaceAll("&gt;", ">").replaceAll("&quot;", "\"").replaceAll("&amp;", "&");
    }

    public static String toXMLEscapedTextWithNBSPizedSpaces(String text) {
        int len = text.length();
        StringBuffer result = new StringBuffer(len);
        boolean previousSpace = false;
        boolean spaceOccured = false;
        for (int i = 0; i < len; ++i) {
            char myChar = text.charAt(i);
            spaceOccured = false;
            switch (myChar) {
                case '&': {
                    result.append("&amp;");
                    break;
                }
                case '<': {
                    result.append("&lt;");
                    break;
                }
                case '>': {
                    result.append("&gt;");
                    break;
                }
                case ' ': {
                    spaceOccured = true;
                    if (previousSpace) {
                        result.append("&nbsp;");
                        break;
                    }
                    result.append(" ");
                    break;
                }
                default: {
                    result.append(myChar);
                }
            }
            previousSpace = spaceOccured;
        }
        return result.toString();
    }

    public static boolean isAbsolutePath(String path) {
        String osNameStart = System.getProperty("os.name").substring(0, 3);
        String fileSeparator = System.getProperty("file.separator");
        if (osNameStart.equals("Win")) {
            return path.length() > 1 && path.substring(1, 2).equals(":") || path.startsWith(fileSeparator);
        }
        if (osNameStart.equals("Mac")) {
            return !path.startsWith(fileSeparator);
        }
        return path.startsWith(fileSeparator);
    }

    public static String urlGetFile(URL url) {
        String osNameStart = System.getProperty("os.name").substring(0, 3);
        String fileSeparator = System.getProperty("file.separator");
        if (osNameStart.equals("Win") && url.getProtocol().equals("file")) {
            String fileName = url.toString().replaceFirst("^file:", "").replace('/', '\\');
            return fileName.indexOf(58) >= 0 ? fileName.replaceFirst("^\\\\*", "") : fileName;
        }
        return url.getFile();
    }

    public static String toRelativeURL(URL base, URL target) {
        if (base.getProtocol().equals(target.getProtocol()) && base.getHost().equals(target.getHost())) {
            String baseString = base.getFile();
            String targetString = target.getFile();
            String result = "";
            baseString = baseString.substring(0, baseString.lastIndexOf("/") + 1);
            targetString = targetString.substring(0, targetString.lastIndexOf("/") + 1);
            StringTokenizer baseTokens = new StringTokenizer(baseString, "/");
            StringTokenizer targetTokens = new StringTokenizer(targetString, "/");
            String nextBaseToken = "";
            String nextTargetToken = "";
            while (baseTokens.hasMoreTokens() && targetTokens.hasMoreTokens()) {
                nextBaseToken = baseTokens.nextToken();
                if (nextBaseToken.equals(nextTargetToken = targetTokens.nextToken())) continue;
                while (true) {
                    result = result.concat("../");
                    if (!baseTokens.hasMoreTokens()) break;
                    nextBaseToken = baseTokens.nextToken();
                }
                while (true) {
                    result = result.concat(nextTargetToken + "/");
                    if (!targetTokens.hasMoreTokens()) break;
                    nextTargetToken = targetTokens.nextToken();
                }
                String temp = target.getFile();
                result = result.concat(temp.substring(temp.lastIndexOf("/") + 1, temp.length()));
                return result;
            }
            while (baseTokens.hasMoreTokens()) {
                result = result.concat("../");
                baseTokens.nextToken();
            }
            while (targetTokens.hasMoreTokens()) {
                nextTargetToken = targetTokens.nextToken();
                result = result.concat(nextTargetToken + "/");
            }
            String temp = target.getFile();
            result = result.concat(temp.substring(temp.lastIndexOf("/") + 1, temp.length()));
            return result;
        }
        return target.toString();
    }

    public static boolean safeEquals(String string1, String string2) {
        return string1 != null && string2 != null && string1.equals(string2);
    }

    public static String firstLetterCapitalized(String text) {
        if (text == null || text.length() == 0) {
            return text;
        }
        return text.substring(0, 1).toUpperCase() + text.substring(1, text.length());
    }

    public static void setHidden(File file, boolean hidden, boolean synchronously) {
        String osNameStart = System.getProperty("os.name").substring(0, 3);
        if (osNameStart.equals("Win")) {
            try {
                Runtime.getRuntime().exec("attrib " + (hidden ? "+" : "-") + "H \"" + file.getAbsolutePath() + "\"");
                if (!synchronously) {
                    return;
                }
                for (int timeOut = 10; file.isHidden() != hidden && timeOut > 0; --timeOut) {
                    Thread.sleep(10L);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public static String expandPlaceholders(String message, String s1) {
        String result = message;
        if (s1 != null) {
            s1 = s1.replaceAll("\\\\", "\\\\\\\\");
            result = result.replaceAll("\\$1", s1);
        }
        return result;
    }

    public static String expandPlaceholders(String message, String s1, String s2) {
        String result = message;
        if (s1 != null) {
            result = result.replaceAll("\\$1", s1);
        }
        if (s2 != null) {
            result = result.replaceAll("\\$2", s2);
        }
        return result;
    }

    public static String expandPlaceholders(String message, String s1, String s2, String s3) {
        String result = message;
        if (s1 != null) {
            result = result.replaceAll("\\$1", s1);
        }
        if (s2 != null) {
            result = result.replaceAll("\\$2", s2);
        }
        if (s3 != null) {
            result = result.replaceAll("\\$3", s3);
        }
        return result;
    }

    public static class Pair {
        Object first;
        Object second;

        public Pair(Object first, Object second) {
            this.first = first;
            this.second = second;
        }

        public Object getFirst() {
            return this.first;
        }

        public Object getSecond() {
            return this.second;
        }
    }

    public static class ObjectHolder {
        Object object;

        public void setObject(Object object) {
            this.object = object;
        }

        public Object getObject() {
            return this.object;
        }
    }

    public static class BooleanHolder {
        private boolean value;

        public void setValue(boolean value) {
            this.value = value;
        }

        public boolean getValue() {
            return this.value;
        }
    }

    public static class IntHolder {
        private int value;

        public IntHolder() {
        }

        public IntHolder(int value) {
            this.value = value;
        }

        public void setValue(int value) {
            this.value = value;
        }

        public int getValue() {
            return this.value;
        }

        public String toString() {
            return new String("IntHolder(") + this.value + ")";
        }
    }
}

