/*
 * Decompiled with CFR 0.152.
 */
package edu.xtec.util;

import edu.xtec.util.MultiBundle;
import edu.xtec.util.NarrowOptionPane;
import edu.xtec.util.ResourceManager;
import edu.xtec.util.StrUtils;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.Serializable;
import java.text.Collator;
import java.text.DateFormat;
import java.text.NumberFormat;
import java.text.ParseException;
import java.util.AbstractList;
import java.util.Date;
import java.util.HashMap;
import java.util.Locale;
import java.util.ResourceBundle;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;

public class Messages {
    public static final String LANGUAGE = "language";
    public static final String COUNTRY = "country";
    public static final String VARIANT = "variant";
    public static final String BASIC_BUNDLE = "messages.BasicMessages";
    public static final String MESSAGES = "messages";
    public static final String ERROR = "ERROR";
    public static final String WARNING = "WARNING";
    public static final int OK = 0;
    public static final int YES = 1;
    public static final int RETRY = 2;
    public static final int NO = 3;
    public static final int IGNORE = 4;
    public static final int CANCEL = 5;
    public static final int YES_TO_ALL = 6;
    public static final int NO_TO_ALL = 7;
    private static final int NUM_BUTTONS = 8;
    private static final String BTN_KEYS = "oyrnicYN";
    private static final String[] BTN_CODES = new String[]{"OK", "YES", "RETRY", "NO", "IGNORE", "CANCEL", "YES_TO_ALL", "NO_TO_ALL"};
    private String[] dlgButtons;
    public static final int MAX_PASSWORD_LENGTH = 24;
    private Locale currentLocale;
    private MultiBundle messages;
    private Collator collator;
    private NumberFormat numberFormat;
    private NumberFormat percentFormat;
    public static final String OPTIONS_DELIMITER = ",";
    private static HashMap codesToNames;
    private static HashMap namesToCodes;

    public Messages(String string) {
        this.init(string, null, null, null);
    }

    public Messages(String string, String string2) {
        StringTokenizer stringTokenizer = new StringTokenizer(string2, OPTIONS_DELIMITER);
        this.init(string, stringTokenizer.hasMoreTokens() ? stringTokenizer.nextToken() : null, stringTokenizer.hasMoreTokens() ? stringTokenizer.nextToken() : null, stringTokenizer.hasMoreTokens() ? stringTokenizer.nextToken() : null);
    }

    public Messages(String string, HashMap hashMap) {
        this.init(string, (String)hashMap.get(LANGUAGE), (String)hashMap.get(COUNTRY), (String)hashMap.get(VARIANT));
    }

    public Messages(String string, String string2, String string3, String string4) {
        this.init(string, string2, string3, string4);
    }

    public static Messages getMessages(HashMap hashMap, String string) {
        Messages messages = (Messages)hashMap.get(MESSAGES);
        if (messages == null) {
            String string2 = (String)hashMap.get(LANGUAGE);
            if (string2 == null) {
                JOptionPane jOptionPane = new JOptionPane("Please select your language:", 3, 2);
                jOptionPane.setSelectionValues(Messages.getDescriptiveLanguageCodes(null));
                jOptionPane.setWantsInput(true);
                String string3 = Messages.getDescriptiveLanguageCode(Locale.getDefault().getLanguage());
                jOptionPane.setInitialSelectionValue(string3);
                Messages.showDlg((Component)hashMap.get("mainParentComponent"), jOptionPane, "Language selecion");
                String string4 = (String)jOptionPane.getInputValue();
                if (string4 == null) {
                    string4 = string3;
                }
                hashMap.put(LANGUAGE, Messages.getLanguageFromDescriptive(string4));
            }
            messages = new Messages(string, hashMap);
            hashMap.put(MESSAGES, messages);
            Locale.setDefault(messages.getLocale());
        } else if (string != null) {
            messages.setLocale(hashMap);
            messages.addBundle(string);
        }
        return messages;
    }

    public void init(String string, String string2, String string3, String string4) {
        this.setLocale(string2, string3, string4);
        this.addBundle(string);
        this.addBundle(BASIC_BUNDLE);
        this.getDlgButtons(true);
    }

    public void setLocale(HashMap hashMap) {
        this.setLocale((String)hashMap.get(LANGUAGE), (String)hashMap.get(COUNTRY), (String)hashMap.get(VARIANT));
    }

    public void setLocale(String string, String string2, String string3) {
        Locale locale = null;
        if (string2 == null) {
            string2 = "";
        }
        if (!(locale = string == null || string.length() == 0 ? (this.currentLocale == null ? Locale.getDefault() : this.currentLocale) : (string3 == null || string3.length() == 0 ? new Locale(string, string2) : new Locale(string, string2, string3))).equals(this.currentLocale)) {
            this.currentLocale = locale;
            this.numberFormat = NumberFormat.getInstance(this.currentLocale);
            this.percentFormat = NumberFormat.getPercentInstance(this.currentLocale);
            this.collator = null;
            if (this.messages != null) {
                this.messages.setLocale(this.currentLocale);
                this.getDlgButtons(true);
            }
        }
    }

    public String[] getDlgButtons(boolean bl) {
        if (bl || this.dlgButtons == null) {
            this.dlgButtons = new String[8];
            int n = 0;
            while (n < 8) {
                this.dlgButtons[n] = this.get(BTN_CODES[n]);
                ++n;
            }
        }
        return this.dlgButtons;
    }

    public void addBundle(String string) {
        if (this.currentLocale != null && string != null) {
            try {
                ResourceBundle resourceBundle = ResourceManager.getBundle(string, this.currentLocale);
                if (this.messages == null) {
                    this.messages = new MultiBundle(resourceBundle, string, this.currentLocale);
                } else {
                    this.messages.addBundle(resourceBundle, string, this.currentLocale);
                }
            }
            catch (Exception exception) {
                System.err.println("unable to build messagesBundle: " + string);
                System.err.println(exception);
            }
        }
    }

    public String getShortDateStr(Date date) {
        DateFormat dateFormat = DateFormat.getDateInstance(3, this.currentLocale);
        return dateFormat.format(date);
    }

    public String getShortDateTimeStr(Date date) {
        DateFormat dateFormat = DateFormat.getDateTimeInstance(3, 2, this.currentLocale);
        return dateFormat.format(date);
    }

    public Date parseShortDate(String string) {
        Date date = null;
        if (string != null) {
            try {
                date = DateFormat.getDateInstance(3, this.currentLocale).parse(string);
            }
            catch (ParseException parseException) {
                // empty catch block
            }
        }
        return date;
    }

    public String get(String string, String string2) {
        return this.get(new StringBuffer(string).append(string2).substring(0));
    }

    public static String get(HashMap hashMap, String string, String string2) {
        return Messages.getMessages(hashMap, null).get(string, string2);
    }

    public String get(String string) {
        return this.messages == null ? string : this.messages.getString(string);
    }

    public static String get(HashMap hashMap, String string) {
        return Messages.getMessages(hashMap, null).get(string);
    }

    public String getAllowNull(String string) {
        return string == null ? "" : this.get(string);
    }

    public String get(String string, String string2, String string3) {
        StringBuffer stringBuffer = new StringBuffer(this.getAllowNull(string));
        stringBuffer.append(" ").append(string2 != null ? string2 : "").append(" ").append(this.getAllowNull(string3));
        return stringBuffer.substring(0);
    }

    public Locale getLocale() {
        return this.currentLocale;
    }

    public Collator getCollator() {
        if (this.collator == null) {
            this.collator = Collator.getInstance(this.currentLocale);
        }
        return this.collator;
    }

    protected String[] parseButtons(String string) {
        string = StrUtils.secureString(string, "o");
        String[] stringArray = new String[string.length()];
        String[] stringArray2 = this.getDlgButtons(false);
        int n = 0;
        while (n < string.length()) {
            int n2 = Math.max(BTN_KEYS.indexOf(string.charAt(n)), 0);
            stringArray[n] = stringArray2[n2];
            ++n;
        }
        return stringArray;
    }

    protected JButton[] parseJButtons(String string) {
        string = StrUtils.secureString(string, "o");
        JButton[] jButtonArray = new JButton[string.length()];
        String[] stringArray = this.getDlgButtons(false);
        int n = 0;
        while (n < string.length()) {
            int n2 = Math.max(BTN_KEYS.indexOf(string.charAt(n)), 0);
            jButtonArray[n] = new JButton(stringArray[n2]);
            jButtonArray[n].setActionCommand(BTN_CODES[n2]);
            ++n;
        }
        return jButtonArray;
    }

    public int showQuestionDlg(Component component, String string, String string2, String string3) {
        return this.showQuestionDlgObj(component, this.get(string), string2, string3);
    }

    public int showQuestionDlgObj(Component component, Object object, String string, String string2) {
        NarrowOptionPane narrowOptionPane = new NarrowOptionPane(60, object, 3, -1, null, this.parseButtons(string2));
        String string3 = this.get(StrUtils.secureString(string, "QUESTION"));
        return this.getFeedback(component, narrowOptionPane, string3);
    }

    public String showInputDlg(Component component, String string, String string2, String string3, String string4, boolean bl) {
        String[] stringArray = null;
        if (string != null) {
            stringArray = new String[]{string};
        }
        return this.showInputDlg(component, stringArray, string2, string3, string4, bl);
    }

    public String showInputDlg(Component component, String[] stringArray, String string, String string2, String string3, boolean bl) {
        String string4 = null;
        JTextField jTextField = null;
        if (bl) {
            jTextField = new JPasswordField(24);
            if (string == null) {
                string = "PASSWORD";
            }
        } else {
            jTextField = new JTextField(24);
        }
        if (string2 != null) {
            jTextField.setText(string2);
        }
        if (this.showInputDlg(component, stringArray, new String[]{string}, new JComponent[]{jTextField}, string3)) {
            if (bl) {
                char[] cArray = ((JPasswordField)jTextField).getPassword();
                if (cArray != null && cArray.length > 0) {
                    string4 = String.copyValueOf(cArray);
                }
            } else {
                string4 = jTextField.getText();
            }
        }
        return string4;
    }

    public boolean showInputDlg(Component component, String[] stringArray, String[] stringArray2, JComponent[] jComponentArray, String string) {
        Serializable serializable;
        int n;
        Vector<Object> vector = new Vector<Object>();
        if (stringArray != null) {
            n = 0;
            while (n < stringArray.length) {
                vector.add(this.get(stringArray[n]));
                ++n;
            }
        }
        if (jComponentArray != null) {
            if (stringArray2 == null) {
                n = 0;
                while (n < jComponentArray.length) {
                    vector.add(jComponentArray[n]);
                    ++n;
                }
            } else {
                GridBagLayout gridBagLayout = new GridBagLayout();
                serializable = new GridBagConstraints();
                serializable.fill = 1;
                serializable.insets = new Insets(3, 3, 3, 3);
                JPanel jPanel = new JPanel(gridBagLayout);
                int n2 = 0;
                while (n2 < jComponentArray.length) {
                    if (stringArray2.length > n2) {
                        JLabel jLabel = new JLabel(this.get(stringArray2[n2]));
                        jLabel.setLabelFor(jComponentArray[n2]);
                        jLabel.setHorizontalAlignment(2);
                        serializable.gridwidth = -1;
                        gridBagLayout.setConstraints(jLabel, (GridBagConstraints)serializable);
                        jPanel.add(jLabel);
                    }
                    serializable.gridwidth = 0;
                    gridBagLayout.setConstraints(jComponentArray[n2], (GridBagConstraints)serializable);
                    jPanel.add(jComponentArray[n2]);
                    ++n2;
                }
                vector.add(jPanel);
            }
        }
        String string2 = string != null ? this.get(string) : "";
        serializable = new NarrowOptionPane(60, vector.toArray(), 3, -1, null, this.parseButtons("oc"));
        return this.getFeedback(component, (JOptionPane)serializable, string2) == 0;
    }

    public boolean showInputDlg(Component component, JComponent jComponent, String string) {
        return this.showInputDlg(component, jComponent, string, "oc");
    }

    public boolean showInputDlg(Component component, JComponent jComponent, String string, String string2) {
        InputDlg inputDlg = new InputDlg(component, string, string2, jComponent);
        return inputDlg.getFeedback() == 0;
    }

    public void showAlert(Component component, String string) {
        this.showAlert(component, new String[]{this.get(string)});
    }

    public void showAlert(Component component, String[] stringArray) {
        System.err.println("Warning:");
        int n = 0;
        while (n < stringArray.length) {
            System.err.println(stringArray[n]);
            ++n;
        }
        NarrowOptionPane narrowOptionPane = new NarrowOptionPane(60, stringArray, 2, -1, null, this.parseButtons(null));
        this.getFeedback(component, narrowOptionPane, this.get(WARNING));
    }

    public int showErrorWarning(Component component, String string, Exception exception) {
        return this.showErrorWarning(component, string, (Vector)null, exception, null);
    }

    public int showErrorWarning(Component component, String string, Exception exception, String string2) {
        return this.showErrorWarning(component, string, (Vector)null, exception, string2);
    }

    public int showErrorWarning(Component component, String string, String string2, Exception exception, String string3) {
        Vector<String> vector = new Vector<String>();
        if (string2 != null) {
            vector.add(string2);
        }
        return this.showErrorWarning(component, string, vector, exception, string3);
    }

    public int showErrorWarning(Component component, String string, Vector vector, Exception exception, String string2) {
        Object object;
        if (string == null) {
            string = ERROR;
        }
        Vector<Object> vector2 = new Vector<Object>();
        String string3 = this.get(string);
        System.err.println(string3);
        vector2.add(this.get(string));
        if (vector != null) {
            object = ((AbstractList)vector).iterator();
            while (object.hasNext()) {
                Object e = object.next();
                if (e == null) continue;
                vector2.add(e);
                System.err.println(e);
            }
        }
        if (exception != null) {
            object = exception.getLocalizedMessage();
            if (object != null) {
                vector2.add(object);
            } else {
                vector2.add(exception.toString());
            }
            System.err.println((String)object);
            exception.printStackTrace(System.err);
        }
        object = new NarrowOptionPane(60, vector2.toArray(), 0, -1, null, this.parseButtons(string2));
        return this.getFeedback(component, (JOptionPane)object, this.get(ERROR));
    }

    public boolean confirmReadableFile(Component component, File file) {
        boolean bl = file.canRead();
        if (!bl) {
            this.showAlert(component, new String[]{this.get("FILE_BEG"), Messages.quote(file.getAbsolutePath()), this.get(file.exists() ? "FILE_NOT READABLE" : "FILE_NOT_EXIST")});
        }
        return bl;
    }

    public int confirmOverwriteFile(Component component, File file, String string) {
        int n = 1;
        if (file.exists()) {
            boolean bl;
            boolean bl2 = file.isDirectory();
            Vector<String> vector = new Vector<String>();
            vector.add(this.get(bl2 ? "FILE_DIR_BEG" : "FILE_BEG"));
            vector.add(Messages.quote(file.getAbsolutePath()));
            boolean bl3 = bl = !file.canWrite();
            if (bl) {
                vector.add(this.get("FILE_READONLY"));
            } else {
                vector.add(this.get("FILE_EXISTS"));
                vector.add(this.get(bl2 ? "FILE_OVERWRITE_DIR_PROMPT" : "FILE_OVERWRITE_PROMPT"));
            }
            if (bl) {
                this.showErrorWarning(component, ERROR, vector, null, null);
                n = 5;
            } else {
                NarrowOptionPane narrowOptionPane = new NarrowOptionPane(60, vector.toArray(), 3, -1, null, this.parseButtons(string));
                n = this.getFeedback(component, narrowOptionPane, this.get("CONFIRM"));
            }
        }
        return n;
    }

    private static boolean showDlg(Component component, JOptionPane jOptionPane, String string) {
        if (component != null && !(component instanceof Frame)) {
            component = JOptionPane.getFrameForComponent(component);
        }
        JDialog jDialog = jOptionPane.createDialog(component, string);
        jOptionPane.selectInitialValue();
        return Messages.showDlg(jDialog);
    }

    public static boolean showDlg(final JDialog jDialog) {
        if (SwingUtilities.isEventDispatchThread()) {
            ((Component)jDialog).setVisible(true);
        } else {
            try {
                SwingUtilities.invokeAndWait(new Runnable(){

                    public void run() {
                        ((Component)jDialog).setVisible(true);
                    }
                });
            }
            catch (Exception exception) {
                System.err.println("Show dialog error: " + exception);
                return false;
            }
        }
        return true;
    }

    protected int getFeedback(Component component, JOptionPane jOptionPane, String string) {
        Object object;
        int n = 5;
        if (Messages.showDlg(component, jOptionPane, string) && (object = jOptionPane.getValue()) != null) {
            int n2 = 0;
            while (n2 < 8) {
                if (this.dlgButtons[n2].equals(object)) {
                    n = n2;
                    break;
                }
                ++n2;
            }
        }
        return n;
    }

    public static String quote(String string) {
        return new StringBuffer(" \"").append(string).append("\" ").substring(0);
    }

    public String kValue(long l) {
        StringBuffer stringBuffer = new StringBuffer(20);
        stringBuffer.append(this.numberFormat.format(l / 1024L)).append(" Kb");
        return stringBuffer.substring(0);
    }

    public String fileSize(long l) {
        StringBuffer stringBuffer = new StringBuffer(20);
        int n = (int)l / 1024;
        double d = (double)l / 1048576.0;
        if (n == 0) {
            stringBuffer.append(this.numberFormat.format(l)).append(" bytes");
        } else if (d < 1.0) {
            stringBuffer.append(this.numberFormat.format(n)).append(" Kb");
        } else {
            int n2 = this.numberFormat.getMaximumFractionDigits();
            this.numberFormat.setMaximumFractionDigits(1);
            stringBuffer.append(this.numberFormat.format(d)).append(" Mb");
            this.numberFormat.setMaximumFractionDigits(n2);
        }
        return stringBuffer.substring(0);
    }

    public String getNumber(long l) {
        return this.numberFormat.format(l);
    }

    public String getNumber(double d) {
        return this.numberFormat.format(d);
    }

    public String getPercent(long l) {
        return this.percentFormat.format((double)l / 100.0);
    }

    public String getPercent(double d) {
        return this.percentFormat.format(d);
    }

    public String getHmsTime(long l) {
        long l2 = l / 1000L;
        if (l2 < 1L) {
            l2 = 1L;
        }
        StringBuffer stringBuffer = new StringBuffer(50);
        if (l2 >= 3600L) {
            stringBuffer.append(l2 / 3600L).append("h");
        }
        if (l2 >= 60L) {
            stringBuffer.append(l2 % 3600L / 60L).append("'");
        }
        stringBuffer.append(l2 % 60L).append("\"");
        return stringBuffer.substring(0);
    }

    public static String getDescriptiveLanguageCode(String string) {
        String string2 = null;
        if (string != null) {
            Locale locale = new Locale(string, "");
            string2 = locale.getDisplayName(Locale.getDefault()) + " (" + string + ")";
        }
        return string2;
    }

    public static String getLanguageFromDescriptive(String string) {
        String string2 = null;
        if (string != null) {
            int n = string.trim().length() - 3;
            string2 = string.substring(n, n + 2);
        }
        return string2;
    }

    public static final String[] getDescriptiveLanguageCodes(Locale locale) {
        Locale locale2 = Locale.getDefault();
        String[] stringArray = Locale.getISOLanguages();
        String[] stringArray2 = new String[stringArray.length];
        int n = 0;
        while (n < stringArray.length) {
            String string = null;
            if (locale == null && stringArray[n].equals("eu")) {
                string = "euskara";
            } else if (locale == null && stringArray[n].equals("gl")) {
                string = "galego";
            } else {
                Locale locale3 = new Locale(stringArray[n], "");
                string = locale3.getDisplayName(locale == null ? locale3 : locale2);
            }
            stringArray2[n] = string + " (" + stringArray[n] + ")";
            ++n;
        }
        return stringArray2;
    }

    public String[] getDescriptiveLanguageCodes() {
        return Messages.getDescriptiveLanguageCodes(this.getLocale());
    }

    private static final void buildLanguageMaps() {
        String[] stringArray = Messages.getDescriptiveLanguageCodes(null);
        codesToNames = new HashMap(stringArray.length);
        namesToCodes = new HashMap(stringArray.length);
        int n = 0;
        while (n < stringArray.length) {
            int n2 = stringArray[n].length() - 5;
            String string = stringArray[n].substring(0, n2).toLowerCase();
            String string2 = stringArray[n].substring(n2 + 2, n2 + 4);
            codesToNames.put(string2, string);
            namesToCodes.put(string, string2);
            ++n;
        }
    }

    public static final HashMap getCodesToNames() {
        if (codesToNames == null) {
            Messages.buildLanguageMaps();
        }
        return codesToNames;
    }

    public static final HashMap getNamesToCodes() {
        if (namesToCodes == null) {
            Messages.buildLanguageMaps();
        }
        return namesToCodes;
    }

    class InputDlg
    extends JDialog
    implements ActionListener {
        int result = 5;
        Component parent;

        InputDlg(Component component, String string, String string2, JComponent jComponent) {
            super(JOptionPane.getFrameForComponent(component), string != null ? Messages.this.get(string) : "", true);
            this.parent = component;
            this.setDefaultCloseOperation(2);
            this.getContentPane().setLayout(new BorderLayout(10, 10));
            if (jComponent != null) {
                this.getContentPane().add((Component)jComponent, "Center");
            }
            JButton[] jButtonArray = Messages.this.parseJButtons(string2);
            JPanel jPanel = new JPanel();
            JButton jButton = null;
            int n = 0;
            while (n < jButtonArray.length) {
                jPanel.add(jButtonArray[n]);
                jButtonArray[n].addActionListener(this);
                String string3 = jButtonArray[n].getActionCommand();
                if (jButton == null && (BTN_CODES[0].equals(string3) || BTN_CODES[1].equals(string3))) {
                    jButton = jButtonArray[n];
                }
                ++n;
            }
            this.getContentPane().add((Component)jPanel, "South");
            if (jButton != null) {
                this.getRootPane().setDefaultButton(jButton);
            }
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (actionEvent != null) {
                String string = actionEvent.getActionCommand();
                int n = 0;
                while (n < BTN_CODES.length) {
                    if (BTN_CODES[n].equals(string)) {
                        this.result = n;
                        break;
                    }
                    ++n;
                }
                ((Component)this).setVisible(false);
            }
        }

        public int getFeedback() {
            this.pack();
            if (this.parent != null) {
                ((Component)this).setLocation((this.parent.getWidth() - this.getWidth()) / 2, (this.parent.getHeight() - this.getHeight()) / 2);
            }
            this.setLocationRelativeTo(this.parent);
            if (!Messages.showDlg(this)) {
                this.result = 5;
            }
            return this.result;
        }
    }
}

