/*
 * Decompiled with CFR 0.152.
 */
package edu.xtec.jclic;

import edu.xtec.jclic.Constants;
import edu.xtec.jclic.PlayStation;
import edu.xtec.jclic.automation.AutoContentProvider;
import edu.xtec.jclic.bags.MediaBagElement;
import edu.xtec.jclic.boxes.ActiveBagContent;
import edu.xtec.jclic.boxes.ActiveBoxBag;
import edu.xtec.jclic.boxes.ActiveBoxContent;
import edu.xtec.jclic.boxes.BoxBase;
import edu.xtec.jclic.boxes.BoxConnector;
import edu.xtec.jclic.boxes.TextGridContent;
import edu.xtec.jclic.clic3.Clic3Activity;
import edu.xtec.jclic.edit.Editable;
import edu.xtec.jclic.edit.Editor;
import edu.xtec.jclic.media.EventSounds;
import edu.xtec.jclic.misc.Gradient;
import edu.xtec.jclic.project.JClicProject;
import edu.xtec.jclic.skins.Skin;
import edu.xtec.util.Domable;
import edu.xtec.util.Html;
import edu.xtec.util.JDomUtility;
import edu.xtec.util.ResourceBridge;
import java.awt.AWTEvent;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.lang.reflect.Constructor;
import java.util.HashMap;
import java.util.Iterator;
import java.util.StringTokenizer;
import javax.swing.BorderFactory;
import javax.swing.JPanel;
import org.jdom.Content;
import org.jdom.Element;

public abstract class Activity
implements Constants,
Editable,
Domable {
    protected JClicProject project;
    public String name = "---";
    public String code;
    public String description;
    public int margin = 8;
    public Color bgColor = DEFAULT_BG_COLOR;
    public Gradient bgGradient;
    public boolean tiledBgImg;
    public String bgImageFile;
    public boolean border = true;
    public boolean absolutePositioned;
    public Point absolutePosition;
    public boolean includeInReports = true;
    public boolean reportActions;
    public boolean helpWindow;
    public boolean showSolution;
    public String helpMsg;
    public EventSounds eventSounds = new EventSounds(null);
    public boolean useOrder;
    public boolean dragCells;
    public String skinFileName;
    public int maxTime;
    public boolean countDownTime;
    public int maxActions;
    public boolean countDownActions;
    public String infoUrl;
    public String infoCmd;
    public static final String[] MSG_TYPE = new String[]{"previous", "initial", "final", "finalError"};
    public static final int PREVIOUS = 0;
    public static final int MAIN = 1;
    public static final int END = 2;
    public static final int END_ERROR = 3;
    public static final int NUM_MSG = 4;
    protected ActiveBoxContent[] messages = new ActiveBoxContent[4];
    protected Dimension windowSize = new Dimension(400, 300);
    protected boolean transparentBg;
    protected Color activityBgColor = DEFAULT_BG_COLOR;
    protected Gradient activityBgGradient;
    protected boolean bTimeCounter = true;
    protected boolean bScoreCounter = true;
    protected boolean bActionsCounter = true;
    protected int shuffles = 31;
    protected AutoContentProvider acp;
    public ActiveBagContent[] abc;
    public TextGridContent tgc;
    public int boxGridPos;
    public boolean[] scramble = new boolean[2];
    public boolean invAss;
    public static final int AB = 0;
    public static final int BA = 1;
    public static final int AUB = 2;
    public static final int BUA = 3;
    public static final String[] LAYOUT_NAMES = new String[]{"AB", "BA", "AUB", "BUA"};
    public static final int DEFAULT_WIDTH = 400;
    public static final int DEFAULT_HEIGHT = 300;
    public static final int MINIMUM_WIDTH = 40;
    public static final int MINIMUM_HEIGHT = 40;
    public static final String DEFAULT_NAME = "---";
    public static final int DEFAULT_MARGIN = 8;
    public static final int DEFAULT_SHUFFLES = 31;
    public static final int DEFAULT_GRID_ELEMENT_SIZE = 20;
    public static final Color DEFAULT_BG_COLOR = Color.lightGray;
    public static final String ACTION_MATCH = "MATCH";
    public static final String ACTION_PLACE = "PLACE";
    public static final String ACTION_WRITE = "WRITE";
    public static final String ACTION_SELECT = "SELECT";
    public static final String ACTION_HELP = "HELP";
    public static final String ELEMENT_NAME = "activity";
    public static final String NAME = "name";
    public static final String BASE_CLASS = "edu.xtec.jclic.activities.";
    public static final String BASE_CLASS_TAG = "@";
    public static final String ID = "id";
    public static final String CODE = "code";
    public static final String DESCRIPTION = "description";
    public static final String MESSAGES = "messages";
    public static final String TYPE = "type";
    public static final String SETTINGS = "settings";
    public static final String LAYOUT = "layout";
    public static final String MARGIN = "margin";
    public static final String CONTAINER = "container";
    public static final String BGCOLOR = "bgColor";
    public static final String IMAGE = "image";
    public static final String TILED = "tiled";
    public static final String COUNTERS = "counters";
    public static final String TIME = "time";
    public static final String ACTIONS = "actions";
    public static final String SCORE = "score";
    public static final String WINDOW = "window";
    public static final String TRANSPARENT = "transparent";
    public static final String BORDER = "border";
    public static final String POSITION = "position";
    public static final String X = "x";
    public static final String Y = "y";
    public static final String SIZE = "size";
    public static final String WIDTH = "width";
    public static final String HEIGHT = "height";
    public static final String PRIMARY = "primary";
    public static final String SECONDARY = "secondary";
    public static final String SOLVED_PRIMARY = "solvedPrimary";
    public static final String SOLVED_SECONDARY = "solved_secondary";
    public static final String GRID = "grid";
    public static final String ROW = "row";
    public static final String CLUES = "clues";
    public static final String CLUE = "clue";
    public static final String RANDOM_CHARS = "random_chars";
    public static final String SCRAMBLE = "scramble";
    public static final String TIMES = "times";
    public static final String REPORT = "report";
    public static final String REPORT_ACTIONS = "reportActions";
    public static final String HELP_WINDOW = "helpWindow";
    public static final String HELP_SHOW_SOLUTION = "showSolution";
    public static final String USE_ORDER = "useOrder";
    public static final String DRAG_CELLS = "dragCells";
    public static final String SKIN = "skin";
    public static final String FILE = "file";
    public static final String MAX_TIME = "maxTime";
    public static final String COUNT_DOWN_TIME = "countDownTime";
    public static final String MAX_ACTIONS = "maxActions";
    public static final String COUNT_DOWN_ACTIONS = "countDownActions";
    public static final String INFO_URL = "infoUrl";
    public static final String INFO_CMD = "infoCmd";
    public static final String[][] COMPATIBLE_ACTIVITIES = new String[][]{{"@puzzles.DoublePuzzle", "@puzzles.ExchangePuzzle", "@puzzles.HolePuzzle", "@memory.MemoryGame", "@associations.SimpleAssociation", "@associations.ComplexAssociation", "@panels.Explore", "@panels.Identify", "@panels.InformationScreen", "@text.WrittenAnswer"}, {"@text.FillInBlanks", "@text.Identify", "@text.Order", "@text.Complete"}};
    static /* synthetic */ Class class$edu$xtec$jclic$project$JClicProject;

    public Activity(JClicProject jClicProject) {
        this.project = jClicProject;
    }

    public void initNew() {
        this.name = this.project.getBridge().getMsg("UNNAMED");
    }

    public String getPublicName() {
        return this.name;
    }

    public JClicProject getProject() {
        return this.project;
    }

    public Editor getEditor(Editor editor) {
        Object var2_2 = null;
        String string = this.getClass().getName() + "Editor";
        try {
            Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            string = "edu.xtec.jclic.ActivityEditor";
        }
        return Editor.createEditor(string, this, editor);
    }

    public String getShortClassName() {
        String string = this.getClass().getName();
        if (string.startsWith(BASE_CLASS)) {
            string = BASE_CLASS_TAG + string.substring(BASE_CLASS.length());
        }
        return string;
    }

    public String[] getSimilarActivityClasses() {
        String[] stringArray = null;
        String string = this.getShortClassName();
        int n = 0;
        while (n < COMPATIBLE_ACTIVITIES.length) {
            String[] stringArray2 = COMPATIBLE_ACTIVITIES[n];
            int n2 = 0;
            while (n2 < stringArray2.length) {
                if (string.equals(stringArray2[n2])) {
                    stringArray = stringArray2;
                    break;
                }
                ++n2;
            }
            ++n;
        }
        if (stringArray == null) {
            stringArray = new String[]{string};
        }
        return stringArray;
    }

    public Element getJDomElement() {
        Element element;
        Element element2;
        Element element3 = new Element(ELEMENT_NAME);
        element3.setAttribute("class", this.getShortClassName());
        element3.setAttribute(NAME, this.name);
        if (this.code != null) {
            element3.setAttribute(CODE, this.code);
        }
        if (this.description != null) {
            JDomUtility.addParagraphs((Element)element3, (String)DESCRIPTION, (String)this.description);
        }
        Element element4 = new Element(MESSAGES);
        int n = 0;
        while (n < 4) {
            if (this.messages[n] != null) {
                element4.addContent((Content)this.messages[n].getJDomElement().setAttribute(TYPE, MSG_TYPE[n]));
            }
            ++n;
        }
        element3.addContent((Content)element4);
        element4 = new Element(SETTINGS);
        element4.setAttribute(MARGIN, Integer.toString(this.margin));
        if (this.infoUrl != null && this.infoUrl.length() > 0) {
            element4.setAttribute(INFO_URL, this.infoUrl);
        } else if (this.infoCmd != null && this.infoCmd.length() > 0) {
            element4.setAttribute(INFO_CMD, this.infoCmd);
        }
        if (this.useOrder) {
            element4.setAttribute(USE_ORDER, JDomUtility.boolString((boolean)this.useOrder));
        }
        if (this.dragCells) {
            element4.setAttribute(DRAG_CELLS, JDomUtility.boolString((boolean)this.dragCells));
        }
        if (this.maxTime > 0) {
            element4.setAttribute(MAX_TIME, Integer.toString(this.maxTime));
            element4.setAttribute(COUNT_DOWN_TIME, JDomUtility.boolString((boolean)this.countDownTime));
        }
        if (this.maxActions > 0) {
            element4.setAttribute(MAX_ACTIONS, Integer.toString(this.maxActions));
            element4.setAttribute(COUNT_DOWN_ACTIONS, JDomUtility.boolString((boolean)this.countDownActions));
        }
        element4.setAttribute(REPORT, JDomUtility.boolString((boolean)this.includeInReports));
        if (this.includeInReports) {
            element4.setAttribute(REPORT_ACTIONS, JDomUtility.boolString((boolean)this.reportActions));
        }
        if (this.helpWindow) {
            element2 = new Element(HELP_WINDOW);
            boolean bl = this.helpSolutionAllowed();
            if (bl) {
                element2.setAttribute(HELP_SHOW_SOLUTION, JDomUtility.boolString((boolean)this.showSolution));
            }
            if (!(this.helpMsg == null || bl && this.showSolution)) {
                JDomUtility.setParagraphs((Element)element2, (String)this.helpMsg);
            }
            element4.addContent((Content)element2);
        }
        element2 = new Element(CONTAINER);
        element2.setAttribute(BGCOLOR, JDomUtility.colorToString((Color)this.bgColor));
        if (this.bgGradient != null) {
            element2.addContent((Content)this.bgGradient.getJDomElement());
        }
        if (this.bgImageFile != null && this.bgImageFile.length() > 0) {
            element = new Element(IMAGE);
            element.setAttribute(NAME, this.bgImageFile);
            element.setAttribute(TILED, JDomUtility.boolString((boolean)this.tiledBgImg));
            element2.addContent((Content)element);
        }
        element = new Element(COUNTERS);
        element.setAttribute(TIME, JDomUtility.boolString((boolean)this.bTimeCounter));
        element.setAttribute(ACTIONS, JDomUtility.boolString((boolean)this.bActionsCounter));
        element.setAttribute(SCORE, JDomUtility.boolString((boolean)this.bScoreCounter));
        element2.addContent((Content)element);
        element4.addContent((Content)element2);
        element2 = new Element(WINDOW);
        element2.setAttribute(BGCOLOR, JDomUtility.colorToString((Color)this.activityBgColor));
        if (this.activityBgGradient != null) {
            element2.addContent((Content)this.activityBgGradient.getJDomElement());
        }
        if (this.transparentBg) {
            element2.setAttribute(TRANSPARENT, JDomUtility.boolString((boolean)this.transparentBg));
        }
        element2.setAttribute(BORDER, JDomUtility.boolString((boolean)this.border));
        if (this.absolutePositioned && this.absolutePosition != null) {
            element = new Element(POSITION);
            element.setAttribute(X, Integer.toString(this.absolutePosition.x));
            element.setAttribute(Y, Integer.toString(this.absolutePosition.y));
            element2.addContent((Content)element);
        }
        if (this.windowSize.width != 400 || this.windowSize.height != 300) {
            element = new Element(SIZE);
            element.setAttribute(WIDTH, Integer.toString(this.windowSize.width));
            element.setAttribute(HEIGHT, Integer.toString(this.windowSize.height));
            element2.addContent((Content)element);
        }
        element4.addContent((Content)element2);
        element2 = this.eventSounds.getJDomElement();
        if (element2 != null) {
            element4.addContent((Content)element2);
        }
        if (this.skinFileName != null) {
            element2 = new Element(SKIN);
            element2.setAttribute(FILE, this.skinFileName);
            element4.addContent((Content)element2);
        }
        element3.addContent((Content)element4);
        if (this.acp != null) {
            element3.addContent((Content)this.acp.getJDomElement());
        }
        return element3;
    }

    public static Activity getActivity(Object object, JClicProject jClicProject) throws Exception {
        String string;
        Activity activity = null;
        Element element = null;
        Clic3Activity clic3Activity = null;
        if (object instanceof Element) {
            element = (Element)object;
            JDomUtility.checkName((Element)element, (String)ELEMENT_NAME);
            string = JDomUtility.getClassName((Element)element);
        } else if (object instanceof Clic3Activity) {
            clic3Activity = (Clic3Activity)object;
            string = clic3Activity.className;
        } else if (object instanceof String) {
            string = (String)object;
        } else {
            throw new Exception("unknown data!!");
        }
        Class[] classArray = new Class[]{class$edu$xtec$jclic$project$JClicProject == null ? (class$edu$xtec$jclic$project$JClicProject = Activity.class$("edu.xtec.jclic.project.JClicProject")) : class$edu$xtec$jclic$project$JClicProject};
        Object[] objectArray = new Object[]{jClicProject};
        if (string.startsWith(BASE_CLASS_TAG)) {
            string = BASE_CLASS + string.substring(1);
        }
        Class<?> clazz = Class.forName(string);
        Constructor<?> constructor = clazz.getConstructor(classArray);
        activity = (Activity)constructor.newInstance(objectArray);
        if (element != null) {
            activity.setProperties(element, null);
        } else if (clic3Activity != null) {
            activity.setProperties(clic3Activity);
        } else {
            activity.initNew();
        }
        return activity;
    }

    public Activity duplicate() throws Exception {
        return Activity.getActivity(this.getJDomElement(), this.project);
    }

    public void setProperties(Element element, Object object) throws Exception {
        int n;
        Element element2;
        Object object2;
        JDomUtility.checkName((Element)element, (String)ELEMENT_NAME);
        this.name = JDomUtility.getStringAttr((Element)element, (String)NAME, (String)this.name, (boolean)false);
        this.code = JDomUtility.getStringAttr((Element)element, (String)CODE, (String)this.code, (boolean)false);
        Element element3 = element.getChild(DESCRIPTION);
        if (element3 != null) {
            this.description = JDomUtility.getParagraphs((Element)element3);
        }
        if ((element3 = element.getChild(MESSAGES)) != null) {
            object2 = element3.getChildren("cell").iterator();
            while (object2.hasNext()) {
                element2 = (Element)object2.next();
                n = JDomUtility.getStrIndexAttr((Element)element2, (String)TYPE, (String[])MSG_TYPE, (int)-1);
                if (n < 0) continue;
                this.messages[n] = ActiveBoxContent.getActiveBoxContent(element2, this.project.mediaBag);
            }
        }
        if ((element3 = element.getChild(SETTINGS)) != null) {
            Element element4;
            this.margin = JDomUtility.getIntAttr((Element)element3, (String)MARGIN, (int)this.margin);
            this.infoUrl = JDomUtility.getStringAttr((Element)element3, (String)INFO_URL, (String)this.infoUrl, (boolean)false);
            if (this.infoUrl == null) {
                this.infoCmd = JDomUtility.getStringAttr((Element)element3, (String)INFO_CMD, (String)this.infoCmd, (boolean)false);
            }
            this.useOrder = JDomUtility.getBoolAttr((Element)element3, (String)USE_ORDER, (boolean)this.useOrder);
            this.dragCells = JDomUtility.getBoolAttr((Element)element3, (String)DRAG_CELLS, (boolean)this.dragCells);
            this.maxTime = JDomUtility.getIntAttr((Element)element3, (String)MAX_TIME, (int)this.maxTime);
            if (this.maxTime > 0) {
                this.countDownTime = JDomUtility.getBoolAttr((Element)element3, (String)COUNT_DOWN_TIME, (boolean)this.countDownTime);
            }
            this.maxActions = JDomUtility.getIntAttr((Element)element3, (String)MAX_ACTIONS, (int)this.maxActions);
            if (this.maxActions > 0) {
                this.countDownActions = JDomUtility.getBoolAttr((Element)element3, (String)COUNT_DOWN_ACTIONS, (boolean)this.countDownActions);
            }
            this.includeInReports = JDomUtility.getBoolAttr((Element)element3, (String)REPORT, (boolean)this.includeInReports);
            this.reportActions = this.includeInReports ? JDomUtility.getBoolAttr((Element)element3, (String)REPORT_ACTIONS, (boolean)this.reportActions) : false;
            element2 = element3.getChild(HELP_WINDOW);
            if (element2 != null) {
                if (this.helpSolutionAllowed()) {
                    this.showSolution = JDomUtility.getBoolAttr((Element)element2, (String)HELP_SHOW_SOLUTION, (boolean)this.showSolution);
                }
                if (!this.showSolution) {
                    this.helpMsg = JDomUtility.getParagraphs((Element)element2);
                }
                boolean bl = this.helpWindow = this.helpMsg != null || this.showSolution;
            }
            if ((element2 = element3.getChild(CONTAINER)) != null) {
                this.bgColor = JDomUtility.getColorAttr((Element)element2, (String)BGCOLOR, (Color)this.bgColor);
                element4 = element2.getChild("gradient");
                if (element4 != null) {
                    this.bgGradient = Gradient.getGradient(element4);
                }
                if ((element4 = element2.getChild(IMAGE)) != null) {
                    this.bgImageFile = element4.getAttributeValue(NAME);
                    this.tiledBgImg = JDomUtility.getBoolAttr((Element)element4, (String)TILED, (boolean)this.tiledBgImg);
                }
                if ((element4 = element2.getChild(COUNTERS)) != null) {
                    this.bTimeCounter = JDomUtility.getBoolAttr((Element)element4, (String)TIME, (boolean)this.bTimeCounter);
                    this.bActionsCounter = JDomUtility.getBoolAttr((Element)element4, (String)ACTIONS, (boolean)this.bActionsCounter);
                    this.bScoreCounter = JDomUtility.getBoolAttr((Element)element4, (String)SCORE, (boolean)this.bScoreCounter);
                    object2 = this.project.version;
                    if (object2 != null && ((String)object2).compareTo("0.1.1") <= 0) {
                        n = this.bScoreCounter ? 1 : 0;
                        this.bScoreCounter = this.bTimeCounter;
                        this.bTimeCounter = this.bActionsCounter;
                        this.bActionsCounter = n;
                    }
                }
            }
            if ((element2 = element3.getChild(WINDOW)) != null) {
                this.activityBgColor = JDomUtility.getColorAttr((Element)element2, (String)BGCOLOR, (Color)this.activityBgColor);
                element4 = element2.getChild("gradient");
                if (element4 != null) {
                    this.activityBgGradient = Gradient.getGradient(element4);
                }
                this.transparentBg = JDomUtility.getBoolAttr((Element)element2, (String)TRANSPARENT, (boolean)this.transparentBg);
                this.border = JDomUtility.getBoolAttr((Element)element2, (String)BORDER, (boolean)this.border);
                element4 = element2.getChild(POSITION);
                if (element4 != null) {
                    this.absolutePositioned = true;
                    this.absolutePosition = JDomUtility.getPointAttr((Element)element4, (String)X, (String)Y, (Point)this.absolutePosition);
                }
                if ((element4 = element2.getChild(SIZE)) != null) {
                    this.windowSize = JDomUtility.getDimensionAttr((Element)element4, (String)WIDTH, (String)HEIGHT, (Dimension)this.windowSize);
                }
            }
            if ((element2 = element3.getChild("eventSounds")) != null) {
                this.eventSounds = EventSounds.getEventSounds(element2);
            }
            if ((element2 = element3.getChild(SKIN)) != null) {
                this.skinFileName = JDomUtility.getStringAttr((Element)element2, (String)FILE, (String)this.skinFileName, (boolean)false);
            }
        }
        if ((element3 = element.getChild("automation")) != null) {
            this.acp = AutoContentProvider.getAutoContentProvider(element3);
        }
    }

    public void setProperties(Clic3Activity clic3Activity) throws Exception {
        StringBuffer stringBuffer;
        this.name = clic3Activity.fileName;
        if (clic3Activity.fileDesc.length() > 0) {
            this.description = clic3Activity.fileDesc;
        }
        BoxBase boxBase = clic3Activity.getBoxBase(2);
        int n = 1;
        while (n < 3) {
            this.messages[n] = new ActiveBoxContent();
            this.messages[n].setBoxBase(boxBase);
            clic3Activity.setActiveBoxTextContent(this.messages[n], n == 1 ? clic3Activity.initMess : clic3Activity.endMess);
            if (this.messages[n].mediaContent != null) {
                this.messages[n].mediaContent.level = 2;
            }
            ++n;
        }
        this.absolutePositioned = clic3Activity.pwrp;
        this.absolutePosition = new Point(clic3Activity.pwrx, clic3Activity.pwry);
        this.transparentBg = clic3Activity.pwTransp;
        this.activityBgColor = clic3Activity.colorFons[1];
        this.border = clic3Activity.marcs;
        this.bgImageFile = clic3Activity.bmpFons;
        if (this.bgImageFile != null && this.bgImageFile.length() > 0) {
            this.project.mediaBag.getImageElement(this.bgImageFile);
        }
        this.tiledBgImg = clic3Activity.tileBmp;
        this.bgColor = clic3Activity.colorFons[0];
        this.bTimeCounter = clic3Activity.comptadors[0];
        this.bScoreCounter = clic3Activity.comptadors[1];
        this.bActionsCounter = clic3Activity.comptadors[2];
        boolean bl = this.includeInReports = !clic3Activity.noAv;
        if (clic3Activity.custHlp && clic3Activity.custHelpFile != null && clic3Activity.custHelpFile.length() > 0) {
            String string;
            stringBuffer = new StringBuffer();
            stringBuffer.append(clic3Activity.custHelpFile);
            if (clic3Activity.hlpTopic != null && clic3Activity.hlpTopic.length() > 0) {
                stringBuffer.append(" ").append(clic3Activity.hlpTopic);
            }
            if ((string = stringBuffer.substring(0)).indexOf(".htm") > 0) {
                StringTokenizer stringTokenizer = new StringTokenizer(string, " ");
                while (stringTokenizer.hasMoreTokens()) {
                    String string2 = stringTokenizer.nextToken();
                    if (string2.indexOf(".htm") <= 0) continue;
                    this.infoUrl = string2;
                    break;
                }
            } else {
                this.infoCmd = clic3Activity.custHelpFile.toLowerCase().indexOf(".hlp") > 0 ? "winhelp.exe " + clic3Activity.custHelpFile : string;
            }
        }
        if (this.helpSolutionAllowed()) {
            this.showSolution = clic3Activity.shHelp;
        }
        if (this.showSolution) {
            this.helpWindow = true;
        }
        if (clic3Activity.useDLL && clic3Activity.rgDLL.equalsIgnoreCase("arith2.dll")) {
            stringBuffer = new Element("automation");
            stringBuffer.setAttribute("class", "edu.xtec.jclic.automation.arith.Arith");
            try {
                this.acp = AutoContentProvider.getAutoContentProvider((Element)stringBuffer);
                if (this.acp != null) {
                    this.acp.setClic3Properties(clic3Activity.dllOptions);
                }
            }
            catch (Exception exception) {
                System.err.println("Unable to start arith2:\n" + exception);
            }
        }
    }

    public static void listReferences(Element element, HashMap hashMap) {
        Object object;
        Element element2 = element.getChild(MESSAGES);
        if (element2 != null) {
            object = element2.getChildren("cell").iterator();
            while (object.hasNext()) {
                ActiveBoxContent.listReferences((Element)object.next(), hashMap);
            }
        }
        if ((element2 = element.getChild(SETTINGS)) != null) {
            Element element3;
            Element element4 = element2.getChild(CONTAINER);
            if (element4 != null && (element3 = element4.getChild(IMAGE)) != null) {
                hashMap.put(element3.getAttributeValue(NAME), "media");
            }
            if ((element4 = element2.getChild("eventSounds")) != null) {
                EventSounds.listReferences(element4, hashMap);
            }
            if ((element4 = element2.getChild(SKIN)) != null && (object = JDomUtility.getStringAttr((Element)element4, (String)FILE, null, (boolean)false)) != null && !((String)object).startsWith(BASE_CLASS_TAG)) {
                hashMap.put(object, SKIN);
            }
        }
        object = element.getChildren("cells").iterator();
        while (object.hasNext()) {
            ActiveBagContent.listReferences((Element)object.next(), hashMap);
        }
        element2 = element.getChild("document");
        if (element2 != null) {
            Activity.innerListReferences(element2, hashMap);
        }
    }

    public static void innerListReferences(Element element, HashMap hashMap) {
        Iterator iterator = element.getChildren("cell").iterator();
        while (iterator.hasNext()) {
            ActiveBoxContent.listReferences((Element)iterator.next(), hashMap);
        }
        iterator = element.getChildren().iterator();
        while (iterator.hasNext()) {
            Element element2 = (Element)iterator.next();
            if ("cell".equals(element2.getName())) continue;
            Activity.innerListReferences(element2, hashMap);
        }
    }

    public ActiveBoxContent[] getMessages() {
        return this.messages;
    }

    public String toHtmlString(ResourceBridge resourceBridge) {
        Html html = new Html(1000);
        html.doubleCell(resourceBridge.getMsg("about_window_lb_activity"), true, this.name, true);
        if (this.description != null) {
            html.doubleCell(resourceBridge.getMsg("about_window_lb_description"), true, this.description, false);
        }
        return Html.table((String)html.toString(), null, (int)1, (int)5, (int)-1, null, (boolean)false);
    }

    public void initAutoContentProvider(ResourceBridge resourceBridge) {
        if (this.acp != null) {
            this.acp.init(resourceBridge);
        }
    }

    public boolean prepareMedia(PlayStation playStation) {
        if (this.eventSounds != null) {
            this.eventSounds.realize(playStation.getOptions(), this.project.mediaBag);
        }
        int n = 0;
        while (n < 4) {
            if (this.messages[n] != null) {
                this.messages[n].prepareMedia(playStation);
            }
            ++n;
        }
        if (this.abc != null) {
            int n2 = 0;
            while (n2 < this.abc.length) {
                if (this.abc[n2] != null) {
                    this.abc[n2].prepareMedia(playStation);
                }
                ++n2;
            }
        }
        return true;
    }

    protected Activity getActivity() {
        return this;
    }

    public abstract Panel getActivityPanel(PlayStation var1);

    public boolean helpSolutionAllowed() {
        return false;
    }

    public boolean helpWindowAllowed() {
        return this.helpWindow && (this.helpSolutionAllowed() && this.showSolution || this.helpMsg != null);
    }

    public abstract int getMinNumActions();

    public boolean mustPauseSequence() {
        return this.getMinNumActions() != 0;
    }

    public boolean canReinit() {
        return true;
    }

    public boolean hasInfo() {
        return this.infoUrl != null && this.infoUrl.length() > 0 || this.infoCmd != null && this.infoCmd.length() > 0;
    }

    public boolean hasRandom() {
        return false;
    }

    public boolean shuffleAlways() {
        return false;
    }

    public void end() {
        if (this.eventSounds != null) {
            this.eventSounds.close();
            this.eventSounds = null;
        }
        this.clear();
    }

    public void clear() {
    }

    public void finalize() throws Throwable {
        this.end();
        super.finalize();
    }

    public Dimension getWindowSize() {
        return new Dimension(this.windowSize);
    }

    public void setWindowSize(Dimension dimension) {
        this.windowSize = new Dimension(dimension);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public abstract class Panel
    extends JPanel {
        public Skin skin = null;
        public boolean solved = false;
        public Image bgImage = null;
        protected boolean playing = false;
        protected boolean firstRun = true;
        protected int currentItem = 0;
        protected BoxConnector bc = null;
        public PlayStation ps;

        protected Panel(PlayStation playStation) {
            this.ps = playStation;
            this.setMinimumSize(new Dimension(100, 100));
            this.setPreferredSize(new Dimension(500, 400));
            this.enableEvents(56L);
        }

        public Activity getActivity() {
            return Activity.this;
        }

        public PlayStation getPs() {
            return this.ps;
        }

        public void buildVisualComponents() throws Exception {
            this.playing = false;
            this.skin = null;
            if (Activity.this.skinFileName != null && Activity.this.skinFileName.length() > 0) {
                this.skin = Activity.this.project.mediaBag.getSkinElement(Activity.this.skinFileName, this.ps);
            }
            this.bgImage = null;
            if (Activity.this.bgImageFile != null && Activity.this.bgImageFile.length() > 0) {
                MediaBagElement mediaBagElement = Activity.this.project.mediaBag.getImageElement(Activity.this.bgImageFile);
                this.bgImage = mediaBagElement.getImage();
                Activity.this.bgImageFile = mediaBagElement.getName();
            }
            this.setBackground(Activity.this.activityBgColor);
            if (Activity.this.transparentBg) {
                this.setOpaque(false);
            }
            this.setBorder(Activity.this.border ? BorderFactory.createBevelBorder(0) : BorderFactory.createEmptyBorder());
            this.invalidate();
        }

        protected void playEvent(int n) {
            if (Activity.this.eventSounds != null) {
                Activity.this.eventSounds.play(n);
            }
        }

        public void initActivity() throws Exception {
            if (this.playing) {
                this.playing = false;
                this.ps.reportEndActivity(Activity.this, this.solved);
            }
            this.solved = false;
            this.ps.reportNewActivity(Activity.this, 0);
            this.enableCounters();
        }

        public void startActivity() throws Exception {
        }

        public void showHelp() {
        }

        public abstract void render(Graphics2D var1, Rectangle var2);

        public abstract Dimension setDimension(Dimension var1);

        public void processMouse(MouseEvent mouseEvent) {
        }

        public void processKey(KeyEvent keyEvent) {
        }

        public boolean isPlaying() {
            return this.playing;
        }

        public final void fitTo(Rectangle rectangle, Rectangle rectangle2) {
            Point point = new Point(0, 0);
            if (Activity.this.absolutePositioned && Activity.this.absolutePosition != null) {
                point.x = Math.max(0, Activity.this.absolutePosition.x + rectangle.x);
                point.y = Math.max(0, Activity.this.absolutePosition.y + rectangle.y);
                rectangle.width -= Activity.this.absolutePosition.x;
                rectangle.height -= Activity.this.absolutePosition.y;
            }
            Dimension dimension = this.setDimension(new Dimension(Math.max(2 * Activity.this.margin + 40, rectangle.width), Math.max(2 * Activity.this.margin + 40, rectangle.height)));
            if (!Activity.this.absolutePositioned) {
                point.setLocation(Math.max(0, rectangle.x + (rectangle.width - dimension.width) / 2), Math.max(0, rectangle.y + (rectangle.height - dimension.height) / 2));
            }
            if (point.x + dimension.width > rectangle2.width) {
                point.x = Math.max(0, rectangle2.width - dimension.width);
            }
            if (point.y + dimension.height > rectangle2.height) {
                point.y = Math.max(0, rectangle2.height - dimension.height);
            }
            this.setBounds(point.x, point.y, dimension.width, dimension.height);
        }

        public void paintComponent(Graphics graphics) {
            Graphics2D graphics2D = (Graphics2D)graphics;
            RenderingHints renderingHints = graphics2D.getRenderingHints();
            graphics2D.setRenderingHints(Constants.DEFAULT_RENDERING_HINTS);
            if (!Activity.this.transparentBg) {
                if (Activity.this.activityBgGradient == null || Activity.this.activityBgGradient.hasTransparency()) {
                    super.paintComponent(graphics2D);
                }
                if (Activity.this.activityBgGradient != null) {
                    Activity.this.activityBgGradient.paint(graphics2D, new Rectangle(0, 0, this.getWidth(), this.getHeight()));
                }
            }
            do {
                BoxBase.flagFontReduced = false;
                this.render(graphics2D, graphics2D.getClipBounds());
            } while (BoxBase.flagFontReduced);
            graphics2D.setRenderingHints(renderingHints);
        }

        public void forceFinishActivity() {
        }

        public void finishActivity(boolean bl) {
            this.playing = false;
            this.solved = bl;
            if (this.bc != null) {
                this.bc.end();
            }
            if (bl) {
                this.setAndPlayMsg(2, 5);
            } else {
                this.setAndPlayMsg(3, 4);
            }
            this.ps.activityFinished(this.solved);
            this.ps.reportEndActivity(Activity.this, this.solved);
        }

        protected void setAndPlayMsg(int n, int n2) {
            this.ps.setMsg(Activity.this.messages[n]);
            if (Activity.this.messages[n] == null || Activity.this.messages[n].mediaContent == null) {
                this.playEvent(n2);
            } else {
                this.ps.playMsg();
            }
        }

        public void end() {
            this.forceFinishActivity();
            if (this.playing) {
                if (this.bc != null) {
                    this.bc.end();
                }
                this.ps.reportEndActivity(Activity.this, this.solved);
                this.playing = false;
                this.solved = false;
            }
            this.clear();
        }

        public abstract void clear();

        public void finalize() throws Throwable {
            this.end();
        }

        protected void enableCounters() {
            this.enableCounters(Activity.this.bTimeCounter, Activity.this.bScoreCounter, Activity.this.bActionsCounter);
        }

        protected void enableCounters(boolean bl, boolean bl2, boolean bl3) {
            this.ps.setCounterEnabled(2, bl);
            if (Activity.this.countDownTime) {
                this.ps.setCountDown(2, Activity.this.maxTime);
            }
            this.ps.setCounterEnabled(0, bl2);
            this.ps.setCounterEnabled(1, bl3);
            if (Activity.this.countDownActions) {
                this.ps.setCountDown(1, Activity.this.maxActions);
            }
        }

        public void doLayout() {
        }

        protected void shuffle(ActiveBoxBag[] activeBoxBagArray, boolean bl, boolean bl2) {
            int n = Activity.this.shuffles;
            int n2 = Activity.this.shuffles;
            while (n2 > 0) {
                int n3 = n2 > n ? n : n2;
                int n4 = 0;
                while (n4 < activeBoxBagArray.length) {
                    if (activeBoxBagArray[n4] != null) {
                        activeBoxBagArray[n4].scrambleCells(n3, bl2);
                    }
                    ++n4;
                }
                n2 -= n;
            }
        }

        protected void processEvent(AWTEvent aWTEvent) {
            if (this.playing && aWTEvent instanceof MouseEvent) {
                if (aWTEvent.getID() == 501 && !this.hasFocus()) {
                    this.requestFocus();
                }
                if (this.playing) {
                    this.processMouse((MouseEvent)aWTEvent);
                }
            } else if (this.playing && aWTEvent instanceof KeyEvent) {
                this.processKey((KeyEvent)aWTEvent);
            }
            super.processEvent(aWTEvent);
        }
    }
}

