/*
 * Decompiled with CFR 0.152.
 */
package edu.xtec.jclic.boxes;

import edu.xtec.jclic.boxes.AbstractBox;
import edu.xtec.jclic.boxes.ActiveBagContent;
import edu.xtec.jclic.boxes.ActiveBox;
import edu.xtec.jclic.boxes.BoxBag;
import edu.xtec.jclic.boxes.BoxBase;
import java.awt.geom.Point2D;
import javax.swing.JComponent;

public class ActiveBoxBag
extends BoxBag
implements Cloneable {
    private static final int NOT_USED = -12345;

    public ActiveBoxBag(AbstractBox abstractBox, JComponent jComponent, BoxBase boxBase) {
        super(abstractBox, jComponent, boxBase);
    }

    public final void addActiveBox(ActiveBox activeBox) {
        activeBox.idOrder = activeBox.idLoc = this.cells.size();
        super.addBox(activeBox);
    }

    public ActiveBox getActiveBox(int n) {
        return (ActiveBox)super.getBox(n);
    }

    public ActiveBox getBackgroundActiveBox() {
        return (ActiveBox)this.getBackgroundBox();
    }

    public void setContent(ActiveBagContent activeBagContent) {
        this.setContent(activeBagContent, null);
    }

    public void setContent(ActiveBagContent activeBagContent, ActiveBagContent activeBagContent2) {
        this.setContent(activeBagContent, activeBagContent2, 0, 0, this.getNumCells());
    }

    public void setContent(ActiveBagContent activeBagContent, ActiveBagContent activeBagContent2, int n, int n2, int n3) {
        ActiveBox activeBox;
        int n4 = 0;
        while (n4 < n3) {
            activeBox = this.getActiveBox(n2 + n4);
            activeBox.setContent(activeBagContent, n + n4);
            activeBox.setAlternative(false);
            if (activeBagContent2 != null) {
                activeBox.setAltContent(activeBagContent2, n + n4);
            }
            ++n4;
        }
        if (activeBagContent.backgroundContent != null && (activeBox = this.getBackgroundActiveBox()) != null) {
            activeBox.setContent(activeBagContent.backgroundContent);
            if (activeBagContent.bb != activeBox.getBoxBaseX()) {
                activeBox.setBoxBase(activeBagContent.bb);
            }
        }
    }

    public ActiveBox findActiveBox(Point2D point2D) {
        return (ActiveBox)super.findBox(point2D);
    }

    public void clearAll() {
        int n = 0;
        while (n < this.cells.size()) {
            this.getActiveBox(n).clear();
            ++n;
        }
        if (this.backgroundBox != null) {
            this.getBackgroundActiveBox().clear();
        }
    }

    public int countCellsAtPlace() {
        int n = 0;
        int n2 = 0;
        while (n2 < this.cells.size()) {
            if (this.getActiveBox(n2).isAtPlace()) {
                ++n;
            }
            ++n2;
        }
        return n;
    }

    public ActiveBox getActiveBoxWithIdLoc(int n) {
        int n2 = 0;
        while (n2 < this.cells.size()) {
            ActiveBox activeBox = this.getActiveBox(n2);
            if (activeBox.idLoc == n) {
                return activeBox;
            }
            ++n2;
        }
        return null;
    }

    public boolean cellIsAtEquivalentPlace(ActiveBox activeBox, boolean bl) {
        return activeBox.isAtPlace() || activeBox.isEquivalent(this.getActiveBoxWithIdLoc(activeBox.idOrder), bl);
    }

    public int countCellsAtEquivalentPlace(boolean bl) {
        int n = 0;
        int n2 = 0;
        while (n2 < this.cells.size()) {
            if (this.cellIsAtEquivalentPlace(this.getActiveBox(n2), bl)) {
                ++n;
            }
            ++n2;
        }
        return n;
    }

    public int countCellsWithIdAss(int n) {
        int n2 = 0;
        int n3 = 0;
        while (n3 < this.cells.size()) {
            if (this.getActiveBox((int)n3).idAss == n) {
                ++n2;
            }
            ++n3;
        }
        return n2;
    }

    public int countInactiveCells() {
        int n = 0;
        int n2 = 0;
        while (n2 < this.cells.size()) {
            if (this.getActiveBox(n2).isInactive()) {
                ++n;
            }
            ++n2;
        }
        return n;
    }

    public void setDefaultIdAss() {
        int n = 0;
        while (n < this.cells.size()) {
            this.getActiveBox(n).setDefaultIdAss();
            ++n;
        }
    }

    public void scrambleCells(int n, boolean bl) {
        int n2 = this.cells.size();
        if (n2 >= 2) {
            Cloneable cloneable;
            Point2D[] point2DArray = new Point2D[n2];
            int[] nArray = new int[n2];
            int n3 = 0;
            while (n3 < n2) {
                cloneable = this.getActiveBox(n3);
                point2DArray[n3] = new Point2D.Double();
                point2DArray[n3].setLocation(((AbstractBox)cloneable).getLocation());
                nArray[n3] = ((ActiveBox)cloneable).idLoc;
                ++n3;
            }
            cloneable = new Point2D.Double();
            int n4 = 0;
            while (n4 < n) {
                int n5;
                int n6 = (int)(Math.random() * (double)n2);
                if (n6 != (n5 = (int)(Math.random() * (double)n2))) {
                    ((Point2D)cloneable).setLocation(point2DArray[n6]);
                    point2DArray[n6].setLocation(point2DArray[n5]);
                    point2DArray[n5].setLocation((Point2D)cloneable);
                    int n7 = nArray[n6];
                    nArray[n6] = nArray[n5];
                    nArray[n5] = n7;
                }
                ++n4;
            }
            double d = this.x + this.width;
            double d2 = this.y + this.height;
            int n8 = 0;
            while (n8 < n2) {
                ActiveBox activeBox = this.getActiveBox(n8);
                double d3 = point2DArray[n8].getX();
                double d4 = point2DArray[n8].getY();
                if (bl) {
                    d3 = Math.min(Math.max(d3, this.x), d - activeBox.width);
                    d4 = Math.min(Math.max(d4, this.y), d2 - activeBox.height);
                }
                activeBox.setLocation(d3, d4);
                activeBox.idLoc = nArray[n8];
                ++n8;
            }
        }
    }

    public void resetIds() {
        int n = 0;
        while (n < this.cells.size()) {
            ActiveBox activeBox = (ActiveBox)this.cells.get(n);
            if (activeBox != null) {
                activeBox.idOrder = n;
                activeBox.idAss = n;
                activeBox.idLoc = n;
            }
            ++n;
        }
    }

    public int getNextItem(int n) {
        return this.getNextItem(n, -12345);
    }

    public int getNextItem(int n, int n2) {
        int n3 = n + 1;
        while (n3 < this.cells.size()) {
            ActiveBox activeBox = (ActiveBox)this.cells.get(n3);
            if (activeBox == null || (n2 != -12345 ? n2 == activeBox.idAss : activeBox.idAss >= 0)) break;
            ++n3;
        }
        return n3;
    }
}

