/*
 * Decompiled with CFR 0.152.
 */
package org.apache.crimson.tree;

import org.apache.crimson.tree.DomEx;
import org.apache.crimson.tree.ParentNode;
import org.apache.crimson.util.XmlNames;
import org.w3c.dom.DOMException;

public abstract class NamespacedNode
extends ParentNode {
    protected String qName;
    protected String namespaceURI;

    NamespacedNode(String string, String string2) {
        this.namespaceURI = string;
        this.qName = string2;
    }

    public String getNamespaceURI() {
        return this.namespaceURI;
    }

    public String getPrefix() {
        return XmlNames.getPrefix(this.qName);
    }

    public void setPrefix(String string) throws DOMException {
        if (this.readonly) {
            throw new DomEx(7);
        }
        int n = this.qName.indexOf(58);
        if (string == null) {
            if (n >= 0) {
                this.qName = this.qName.substring(n + 1);
            }
            return;
        }
        if (!XmlNames.isUnqualifiedName(string)) {
            throw new DomEx(5);
        }
        if (this.namespaceURI == null || "xml".equals(string) && !"http://www.w3.org/XML/1998/namespace".equals(this.namespaceURI)) {
            throw new DomEx(14);
        }
        if (this.getNodeType() == 2 && ("xmlns".equals(string) && !"http://www.w3.org/2000/xmlns/".equals(this.namespaceURI) || "xmlns".equals(this.qName))) {
            throw new DomEx(14);
        }
        StringBuffer stringBuffer = new StringBuffer(string);
        stringBuffer.append(':');
        if (n < 0) {
            stringBuffer.append(this.qName);
        } else {
            stringBuffer.append(this.qName.substring(n + 1));
        }
        this.qName = stringBuffer.substring(0);
    }

    public String getLocalName() {
        return XmlNames.getLocalPart(this.qName);
    }

    public String getNodeName() {
        return this.qName;
    }
}

