/*
 * Decompiled with CFR 0.152.
 */
package edu.xtec.jclic.activities.text;

import edu.xtec.jclic.Activity;
import edu.xtec.jclic.HelpActivityComponent;
import edu.xtec.jclic.PlayStation;
import edu.xtec.jclic.activities.text.Evaluator;
import edu.xtec.jclic.activities.text.TextActivityDocument;
import edu.xtec.jclic.activities.text.TextActivityPane;
import edu.xtec.jclic.activities.text.TextTarget;
import edu.xtec.jclic.boxes.ActiveBoxContent;
import edu.xtec.jclic.boxes.BoxBase;
import edu.xtec.jclic.clic3.Clic3Activity;
import edu.xtec.jclic.project.JClicProject;
import edu.xtec.util.JDomUtility;
import edu.xtec.util.StrUtils;
import java.awt.Color;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JScrollPane;
import javax.swing.Timer;
import javax.swing.text.DefaultStyledDocument;
import javax.swing.text.Style;
import javax.swing.text.StyleConstants;
import javax.swing.text.StyleContext;
import javax.swing.text.StyledDocument;
import org.jdom.Content;
import org.jdom.Element;

public class TextActivityBase
extends Activity {
    protected TextActivityDocument tad;
    protected StyleContext styleContext = new StyleContext();
    protected boolean hasCheckButton;
    protected String checkButtonText;
    protected boolean prevScreen;
    protected int prevScreenMaxTime;
    protected String prevScreenText;
    protected BoxBase prevScreenStyle;
    protected StyledDocument prevScreenDocument;
    public static final String TYPE = "type";
    public static final String CHECK_BUTTON = "checkButton";
    public static final String PREV_SCREEN = "prevScreen";
    public static final String TEXT = "text";
    public static final String MAX_TIME = "maxTime";
    static /* synthetic */ Class class$edu$xtec$jclic$activities$text$ComplexEvaluator;
    static /* synthetic */ Class class$edu$xtec$jclic$activities$text$BasicEvaluator;

    public TextActivityBase(JClicProject jClicProject) {
        super(jClicProject);
        Style style = this.styleContext.getStyle("default");
        if (style != null) {
            StyleConstants.setFontFamily(style, BoxBase.getDefaultFont().getFamily());
            StyleConstants.setBackground(style, Color.white);
        }
        this.tad = new TextActivityDocument(this.styleContext);
        this.hasCheckButton = false;
        this.checkButtonText = "";
        this.prevScreen = false;
        this.prevScreenMaxTime = 0;
        this.prevScreenText = null;
        this.prevScreenDocument = null;
        this.prevScreenStyle = new BoxBase();
    }

    public Element getJDomElement() {
        Element element = super.getJDomElement();
        if (this.hasCheckButton) {
            element.addContent((Content)new Element(CHECK_BUTTON).setText(this.checkButtonText));
        }
        if (this.prevScreen) {
            Element element2 = new Element(PREV_SCREEN);
            if (this.prevScreenMaxTime > 0) {
                element2.setAttribute(MAX_TIME, Integer.toString(this.prevScreenMaxTime));
            }
            if (this.prevScreenText != null) {
                element2.addContent((Content)this.prevScreenStyle.getJDomElement());
                JDomUtility.setParagraphs((Element)element2, (String)this.prevScreenText);
            }
            element.addContent((Content)element2);
        }
        try {
            element.addContent((Content)this.tad.getJDomElement());
        }
        catch (Exception exception) {
            System.err.println("Error getting document contents!");
            return null;
        }
        return element;
    }

    public void setProperties(Element element, Object object) throws Exception {
        super.setProperties(element, object);
        Element element2 = element.getChild(CHECK_BUTTON);
        if (element2 != null) {
            this.hasCheckButton = true;
            this.checkButtonText = element2.getText();
        }
        if ((element2 = element.getChild(PREV_SCREEN)) != null) {
            this.prevScreen = true;
            this.prevScreenText = JDomUtility.getParagraphs((Element)element2);
            if (this.prevScreenText != null) {
                this.prevScreenStyle = BoxBase.getBoxBase((Element)element2.getChild("style"));
                this.prevScreenDocument = new DefaultStyledDocument();
                TextActivityDocument.boxBaseToStyledDocument(this.prevScreenStyle, this.prevScreenDocument);
                this.prevScreenDocument.insertString(0, this.prevScreenText, null);
            }
            this.prevScreenMaxTime = JDomUtility.getIntAttr((Element)element2, (String)MAX_TIME, (int)this.prevScreenMaxTime);
        }
        this.tad = TextActivityDocument.getTextActivityDocument(element.getChild("document"), this);
    }

    public void setProperties(Clic3Activity clic3Activity) throws Exception {
        super.setProperties(clic3Activity);
        this.setWindowSize(new Dimension(clic3Activity.txtCW, clic3Activity.txtCH));
        this.hasCheckButton = clic3Activity.btCorregir;
        this.checkButtonText = clic3Activity.txBtCorregir;
        if (clic3Activity.avPrevHelp > 0) {
            this.prevScreen = true;
            this.prevScreenMaxTime = clic3Activity.avTimePH;
            if (clic3Activity.avPrevHelp == 2) {
                this.prevScreenText = clic3Activity.txPrev;
                this.prevScreenStyle = clic3Activity.getBoxBase(3);
            }
            this.messages[0] = new ActiveBoxContent();
            this.messages[0].setBoxBase(this.messages[1].bb);
            clic3Activity.setActiveBoxTextContent(this.messages[0], clic3Activity.initMessPrev);
        }
        this.tad.readClic3Data(clic3Activity, this);
    }

    public void setStyleContext(StyleContext styleContext) {
        if (styleContext != null) {
            try {
                this.tad = TextActivityDocument.getTextActivityDocument(this.tad.getJDomElement(styleContext), this);
                this.styleContext = styleContext;
            }
            catch (Exception exception) {
                System.err.println("Error updating document styles:\n" + exception);
            }
        }
    }

    public StyleContext getStyleContext() {
        return this.styleContext;
    }

    protected Evaluator buildClic3Evaluator(Clic3Activity clic3Activity, boolean bl) throws Exception {
        Element element = new Element("evaluator");
        String string = bl ? (class$edu$xtec$jclic$activities$text$ComplexEvaluator == null ? (class$edu$xtec$jclic$activities$text$ComplexEvaluator = TextActivityBase.class$("edu.xtec.jclic.activities.text.ComplexEvaluator")) : class$edu$xtec$jclic$activities$text$ComplexEvaluator).getName() : (class$edu$xtec$jclic$activities$text$BasicEvaluator == null ? (class$edu$xtec$jclic$activities$text$BasicEvaluator = TextActivityBase.class$("edu.xtec.jclic.activities.text.BasicEvaluator")) : class$edu$xtec$jclic$activities$text$BasicEvaluator).getName();
        element.setAttribute("class", string);
        element.setAttribute("checkCase", JDomUtility.boolString((boolean)clic3Activity.avMaj));
        element.setAttribute("checkAccents", JDomUtility.boolString((boolean)clic3Activity.avAcc));
        element.setAttribute("checkPunctuation", JDomUtility.boolString((boolean)clic3Activity.avPunt));
        element.setAttribute("checkDoubleSpaces", JDomUtility.boolString((boolean)clic3Activity.avDblSpc));
        if (bl) {
            element.setAttribute("detail", JDomUtility.boolString((boolean)clic3Activity.avLletra));
            element.setAttribute("checkSteps", Integer.toString(clic3Activity.avScope));
            element.setAttribute("checkScope", Integer.toString(clic3Activity.avMaxScope));
        }
        return Evaluator.getEvaluator(element, clic3Activity.project);
    }

    public int getMinNumActions() {
        return this.tad == null ? 0 : this.tad.tmb.size();
    }

    public boolean prepareMedia(PlayStation playStation) {
        if (!super.prepareMedia(playStation)) {
            return false;
        }
        if (this.tad != null) {
            this.tad.boxesContent.prepareMedia(playStation);
            this.tad.popupsContent.prepareMedia(playStation);
        }
        return true;
    }

    public boolean helpSolutionAllowed() {
        return true;
    }

    public Activity.Panel getActivityPanel(PlayStation playStation) {
        return new Panel(playStation);
    }

    public TextActivityDocument getDocument() {
        return this.tad;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    class Panel
    extends Activity.Panel
    implements ActionListener {
        JScrollPane scrollPane = null;
        JButton checkButton = null;
        TextActivityPane pane = null;
        boolean showingPrevScreen = false;
        Timer prevScreenTimer = null;
        TextTarget.PopupTimer popupTimer = new TextTarget.PopupTimer(this);

        protected Panel(PlayStation playStation) {
            super((Activity)TextActivityBase.this, playStation);
        }

        public void clear() {
            if (this.prevScreenTimer != null) {
                this.prevScreenTimer.stop();
                this.prevScreenTimer = null;
            }
        }

        public void doLayout() {
            int n = ((JComponent)((Object)this)).getWidth();
            int n2 = ((JComponent)((Object)this)).getHeight();
            if (this.checkButton != null && this.checkButton.isVisible()) {
                int n3 = this.checkButton.getPreferredSize().height;
                this.checkButton.setBounds(0, n2 -= n3, n, n3);
            }
            if (this.scrollPane != null && this.pane != null) {
                if (this.pane.getBounds().isEmpty()) {
                    this.pane.setBounds(0, 0, n, n2);
                }
                this.scrollPane.setBounds(0, 0, n, n2);
            }
        }

        public void buildVisualComponents() throws Exception {
            super.buildVisualComponents();
            if (TextActivityBase.this.prevScreen && TextActivityBase.this.prevScreenText != null) {
                TextActivityBase.this.prevScreenDocument = new DefaultStyledDocument();
                TextActivityDocument.boxBaseToStyledDocument(TextActivityBase.this.prevScreenStyle, TextActivityBase.this.prevScreenDocument);
                try {
                    TextActivityBase.this.prevScreenDocument.insertString(0, TextActivityBase.this.prevScreenText, null);
                }
                catch (Exception exception) {
                    System.err.println("Error displaying initial screen:\n" + exception);
                }
            }
            this.pane = this.buildPane();
            this.scrollPane = new JScrollPane(this.pane);
            this.scrollPane.setBorder(BorderFactory.createEmptyBorder());
            this.scrollPane.getVerticalScrollBar().setBorder(BorderFactory.createLineBorder(Color.darkGray, 1));
            ((Container)((Object)this)).add(this.scrollPane);
            if (TextActivityBase.this.hasCheckButton) {
                this.checkButton = new JButton(StrUtils.secureString((Object)TextActivityBase.this.checkButtonText, (String)" "));
                this.checkButton.setOpaque(false);
                this.checkButton.addActionListener(this);
                ((Container)((Object)this)).add(this.checkButton);
            }
            if (TextActivityBase.this.prevScreen && TextActivityBase.this.prevScreenMaxTime > 0) {
                this.prevScreenTimer = new Timer(1000 * TextActivityBase.this.prevScreenMaxTime, this);
                this.prevScreenTimer.setRepeats(false);
            }
        }

        protected TextActivityPane buildPane() {
            return new TextActivityPane(this);
        }

        public void initActivity() throws Exception {
            if (TextActivityBase.this.prevScreen) {
                this.preInitActivity();
            } else {
                this.startActivity();
            }
        }

        public void startActivity() throws Exception {
            super.initActivity();
            this.showingPrevScreen = false;
            this.setAndPlayMsg(1, 0);
            this.initDocument();
            if (this.checkButton != null) {
                this.checkButton.setVisible(true);
            }
            this.ps.playMsg();
            this.pane.requestFocus();
            this.playing = true;
        }

        public void preInitActivity() {
            if (TextActivityBase.this.messages[0] == null || !TextActivityBase.this.prevScreen) {
                return;
            }
            this.showingPrevScreen = true;
            if (this.checkButton != null) {
                this.checkButton.setVisible(false);
            }
            this.enableCounters(true, false, false);
            this.ps.setCounterValue(2, 0);
            this.ps.setMsg(TextActivityBase.this.messages[0]);
            this.pane.setEditable(false);
            this.pane.setStyledDocument(TextActivityBase.this.prevScreenDocument != null ? TextActivityBase.this.prevScreenDocument : TextActivityBase.this.tad);
            if (this.prevScreenTimer != null) {
                this.ps.setCountDown(2, TextActivityBase.this.prevScreenMaxTime);
                this.prevScreenTimer.start();
            }
            this.ps.playMsg();
        }

        protected void initDocument() throws Exception {
            if (TextActivityBase.this.tad != null) {
                if (this.pane.getDocument() != TextActivityBase.this.tad) {
                    this.pane.setStyledDocument(TextActivityBase.this.tad);
                }
                this.pane.setEnabled(true);
            }
        }

        public void render(Graphics2D graphics2D, Rectangle rectangle) {
        }

        public void requestFocus() {
            if (this.playing && this.pane != null) {
                this.pane.requestFocus();
            }
        }

        public Dimension setDimension(Dimension dimension) {
            return new Dimension(Math.min(dimension.width, TextActivityBase.this.getWindowSize().width), Math.min(dimension.height, TextActivityBase.this.getWindowSize().height));
        }

        public void setCursor(Cursor cursor) {
            if (this.pane != null) {
                this.pane.setCursor(cursor);
            }
            super.setCursor(cursor);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (this.checkButton != null && actionEvent.getSource() == this.checkButton && this.playing) {
                this.doCheck(true);
            }
            if (this.prevScreenTimer != null && actionEvent.getSource() == this.prevScreenTimer && this.showingPrevScreen) {
                this.ps.startActivity((Activity.Panel)this);
            }
        }

        public void forceFinishActivity() {
            if (this.playing) {
                this.doCheck(false);
            }
        }

        protected void doCheck(boolean bl) {
        }

        public void showHelp() {
            if (!TextActivityBase.this.helpWindowAllowed() || this.pane == null) {
                return;
            }
            HelpActivityComponent helpActivityComponent = null;
            if (TextActivityBase.this.showSolution) {
                helpActivityComponent = new HelpActivityComponent(this, this){
                    TextActivityPane tap;
                    JScrollPane jsp;
                    private final /* synthetic */ Panel this$1;
                    {
                        this.this$1 = panel;
                        this.tap = null;
                        this.jsp = null;
                    }

                    public void render(Graphics2D graphics2D, Rectangle rectangle) {
                    }

                    public void init() {
                        this.tap = this.this$1.buildPane();
                        try {
                            this.tap.setStyledDocument(TextActivityDocument.getTextActivityDocument(Panel.access$200((Panel)this.this$1).tad.getJDomElement(), Panel.access$200(this.this$1)));
                        }
                        catch (Exception exception) {
                            this.tap.setStyledDocument(Panel.access$200((Panel)this.this$1).tad);
                        }
                        this.tap.setEditable(false);
                        this.tap.setEnabled(false);
                        this.jsp = new JScrollPane(this.tap);
                        this.jsp.setBorder(BorderFactory.createEmptyBorder());
                        this.jsp.getVerticalScrollBar().setBorder(BorderFactory.createLineBorder(Color.darkGray, 1));
                        ((Container)((Object)this)).add(this.jsp);
                        Dimension dimension = this.this$1.scrollPane.getBounds().getSize();
                        this.jsp.setBounds(0, 0, dimension.width, dimension.height);
                        if (this.tap.getBounds().isEmpty()) {
                            this.tap.setBounds(0, 0, dimension.width, dimension.height);
                        }
                        ((JComponent)((Object)this)).setPreferredSize(dimension);
                        ((JComponent)((Object)this)).setMaximumSize(dimension);
                        ((JComponent)((Object)this)).setMinimumSize(dimension);
                    }
                };
                helpActivityComponent.init();
            }
            if (this.ps.showHelp((JComponent)helpActivityComponent, TextActivityBase.this.helpMsg)) {
                this.ps.reportNewAction(this.getActivity(), "HELP", null, null, false, -1);
            }
            if (helpActivityComponent != null) {
                helpActivityComponent.end();
            }
        }

        static /* synthetic */ TextActivityBase access$200(Panel panel) {
            return panel.TextActivityBase.this;
        }
    }
}

