/*
 * Decompiled with CFR 0.152.
 */
package edu.xtec.util;

import edu.xtec.util.FontCheck;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import java.io.OutputStream;
import java.text.DateFormat;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.StringTokenizer;
import java.util.Vector;
import org.jdom.Content;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.Text;
import org.jdom.input.SAXBuilder;
import org.jdom.output.Format;
import org.jdom.output.XMLOutputter;

public class JDomUtility {
    private static SAXBuilder saxBuilder;
    private static XMLOutputter outputter;
    public static final String ID = "id";
    public static final String IMAGE = "image";
    public static final String NAME = "name";
    public static final String TYPE = "type";
    public static final String BGCOLOR = "bgcolor";
    public static final String FORECOLOR = "forecolor";
    public static final String MARGIN = "margin";
    public static final String BORDER = "border";
    public static final String POSITION = "position";
    public static final String X = "x";
    public static final String Y = "y";
    public static final String P = "p";
    public static final String CLASS = "class";
    public static final String FONT = "font";
    private static final String FAMILY = "family";
    private static final String SIZE = "size";
    private static final String BOLD = "bold";
    private static final String ITALIC = "italic";
    public static final String[] HTML_COLOR_NAMES;
    public static final Color[] HTML_COLORS;
    public static final String LEFT = "left";
    public static final String RIGHT = "right";
    public static final String TOP = "top";
    public static final String BOTTOM = "bottom";
    public static final String WIDTH = "width";
    public static final String HEIGHT = "height";
    public static final String UP = "up";
    public static final String DOWN = "down";
    public static final String RECTANGLE = "rectangle";
    public static final String POINT = "point";
    public static final String DIMENSION = "dimension";
    public static final String OFFSET = "offset";
    public static final String COLOR = "color";
    public static final String VALUE = "value";
    public static final String DIRECTION = "direction";
    public static final int DIRECTION_UP = 0;
    public static final int DIRECTION_DOWN = 1;
    public static final int DIRECTION_LEFT = 2;
    public static final int DIRECTION_RIGHT = 3;
    public static final String[] directionName;
    public static final String ALIGNMENT = "alignment";
    public static final String HALIGN = "hAlign";
    public static final String VALIGN = "vAlign";
    public static final int ALIGN_LEFT = 0;
    public static final int ALIGN_TOP = 0;
    public static final int ALIGN_MIDDLE = 1;
    public static final int ALIGN_RIGHT = 2;
    public static final int ALIGN_BOTTOM = 2;
    public static final String[] hAlignName;
    public static final String[] vAlignName;
    public static final int[] DEFAULT_ALIGNMENT;
    public static final String[] BOOL_STR;
    public static final int FALSE = 0;
    public static final int TRUE = 1;
    public static final int DEFAULT = 2;
    private static final int rare = -18634527;
    public static final String NEWLINE = "\n";
    public static final String BLANK = "";
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$java$lang$Integer;
    static /* synthetic */ Class class$java$lang$Float;
    static /* synthetic */ Class class$java$lang$Double;
    static /* synthetic */ Class class$java$lang$Boolean;
    static /* synthetic */ Class class$java$awt$Color;

    private JDomUtility() {
    }

    public static boolean addGenericAttribute(Element element, String string, Object object) {
        if (object == null) {
            return false;
        }
        Class<?> clazz = object.getClass();
        if (element.getAttribute(string) != null) {
            return false;
        }
        if (clazz.isArray()) {
            return false;
        }
        if (clazz.isAssignableFrom(class$java$lang$String == null ? (class$java$lang$String = JDomUtility.class$("java.lang.String")) : class$java$lang$String) || clazz.isAssignableFrom(class$java$lang$Integer == null ? (class$java$lang$Integer = JDomUtility.class$("java.lang.Integer")) : class$java$lang$Integer) || clazz.isAssignableFrom(class$java$lang$Float == null ? (class$java$lang$Float = JDomUtility.class$("java.lang.Float")) : class$java$lang$Float) || clazz.isAssignableFrom(class$java$lang$Double == null ? (class$java$lang$Double = JDomUtility.class$("java.lang.Double")) : class$java$lang$Double) || clazz.isAssignableFrom(class$java$lang$Boolean == null ? (class$java$lang$Boolean = JDomUtility.class$("java.lang.Boolean")) : class$java$lang$Boolean)) {
            element.setAttribute(string, object.toString());
        } else if (clazz.isAssignableFrom(class$java$awt$Color == null ? (class$java$awt$Color = JDomUtility.class$("java.awt.Color")) : class$java$awt$Color)) {
            element.setAttribute(string, JDomUtility.colorToString((Color)object));
        } else {
            return false;
        }
        return true;
    }

    public static Element fontToElement(Font font) {
        Element element = new Element(FONT);
        element.setAttribute(FAMILY, font.getFamily());
        element.setAttribute(SIZE, Integer.toString(font.getSize()));
        if (font.isBold()) {
            element.setAttribute(BOLD, JDomUtility.boolString(font.isBold()));
        }
        if (font.isItalic()) {
            element.setAttribute(ITALIC, JDomUtility.boolString(font.isItalic()));
        }
        return element;
    }

    public static Font elementToFont(Element element) throws Exception {
        JDomUtility.checkName(element, FONT);
        String string = JDomUtility.getStringAttr(element, FAMILY, "default", false);
        int n = JDomUtility.getIntAttr(element, SIZE, 12);
        int n2 = (JDomUtility.getBoolAttr(element, BOLD, false) ? 1 : 0) | (JDomUtility.getBoolAttr(element, ITALIC, false) ? 2 : 0);
        return FontCheck.getValidFont(string, n2, n);
    }

    public static String colorToString(Color color) {
        String string = Long.toHexString(0x100000000L | (long)color.getRGB()).toUpperCase();
        string = string.substring(string.length() - (color.getAlpha() == 255 ? 6 : 8));
        return "0x" + string;
    }

    public static Color stringToColor(String string) throws Exception {
        Color color = null;
        if (string.startsWith("0x")) {
            long l = Long.decode(string);
            color = new Color((int)l, string.length() > 8 || l >= 0x1000000L);
        } else {
            int n = 0;
            while (n < HTML_COLOR_NAMES.length) {
                if (HTML_COLOR_NAMES[n].equalsIgnoreCase(string)) {
                    color = HTML_COLORS[n];
                    break;
                }
                ++n;
            }
        }
        if (color == null) {
            throw new Exception("Invalid color: " + string);
        }
        return color;
    }

    public static Color getColorAttr(Element element, String string, Color color) throws Exception {
        String string2 = element.getAttributeValue(string);
        return string2 == null ? color : JDomUtility.stringToColor(string2);
    }

    public static final Element getChildWithId(Element element, String string, String string2) {
        Element element2 = null;
        if (element != null && string2 != null && string != null) {
            Iterator iterator = element.getChildren(string).iterator();
            while (iterator.hasNext()) {
                element2 = (Element)iterator.next();
                if (!string2.equals(element2.getAttributeValue(ID))) continue;
                return element2;
            }
        }
        return null;
    }

    public static final Rectangle getRectangle(Element element, String string, Rectangle rectangle) {
        if (string != null) {
            element = JDomUtility.getChildWithId(element, RECTANGLE, string);
        } else if (element != null && !element.getName().equals(RECTANGLE)) {
            element = element.getChild(RECTANGLE);
        }
        if (element == null) {
            return rectangle;
        }
        Rectangle rectangle2 = rectangle == null ? new Rectangle() : new Rectangle(rectangle);
        rectangle2.setBounds(JDomUtility.getIntAttr(element, LEFT, rectangle2.x), JDomUtility.getIntAttr(element, TOP, rectangle2.y), JDomUtility.getIntAttr(element, WIDTH, rectangle2.width), JDomUtility.getIntAttr(element, HEIGHT, rectangle2.height));
        return rectangle2;
    }

    public static final Point getPoint(Element element, String string, Point point) {
        if (string != null) {
            element = JDomUtility.getChildWithId(element, POINT, string);
        } else if (element != null && !element.getName().equals(POINT)) {
            element = element.getChild(POINT);
        }
        if (element == null) {
            return point;
        }
        Point point2 = point == null ? new Point() : new Point(point);
        point2.setLocation(JDomUtility.getIntAttr(element, LEFT, point2.x), JDomUtility.getIntAttr(element, TOP, point2.y));
        return point2;
    }

    public static final Dimension getDimension(Element element, String string, Dimension dimension) {
        if (string != null) {
            element = JDomUtility.getChildWithId(element, DIMENSION, string);
        } else if (element != null && !element.getName().equals(DIMENSION)) {
            element = element.getChild(DIMENSION);
        }
        if (element == null) {
            return dimension;
        }
        Dimension dimension2 = dimension == null ? new Dimension() : new Dimension(dimension);
        dimension2.setSize(JDomUtility.getIntAttr(element, WIDTH, dimension2.width), JDomUtility.getIntAttr(element, HEIGHT, dimension2.height));
        return dimension2;
    }

    public static final Point getOffset(Element element, String string, Point point) {
        if (string != null) {
            element = JDomUtility.getChildWithId(element, OFFSET, string);
        } else if (element != null && !element.getName().equals(OFFSET)) {
            element = element.getChild(OFFSET);
        }
        if (element == null) {
            return point;
        }
        Point point2 = point == null ? new Point() : new Point(point);
        point2.setLocation(JDomUtility.getIntAttr(element, RIGHT, point2.x), JDomUtility.getIntAttr(element, DOWN, point2.y));
        return point2;
    }

    public static Color getColorByPoint(Element element, String string, BufferedImage bufferedImage, Color color) throws Exception {
        Element element2;
        if (string != null) {
            element = JDomUtility.getChildWithId(element, COLOR, string);
        } else if (element != null && !element.getName().equals(COLOR)) {
            element = element.getChild(COLOR);
        }
        if (element == null) {
            return color;
        }
        Color color2 = JDomUtility.getColorAttr(element, VALUE, color);
        if (bufferedImage != null && (element2 = element.getChild(POINT)) != null) {
            Point point = JDomUtility.getPoint(element2, null, new Point());
            color2 = new Color(bufferedImage.getRGB(point.x, point.y));
        }
        return color2;
    }

    public static int getDirection(Element element, int n) throws Exception {
        if (element == null) {
            return n;
        }
        return JDomUtility.getStrIndexAttr(element, DIRECTION, directionName, n);
    }

    public static int getHAlign(Element element, int n) throws Exception {
        if (element == null) {
            return n;
        }
        return JDomUtility.getStrIndexAttr(element, HALIGN, hAlignName, n);
    }

    public static int getVAlign(Element element, int n) throws Exception {
        if (element == null) {
            return n;
        }
        return JDomUtility.getStrIndexAttr(element, VALIGN, vAlignName, n);
    }

    public static int[] getAlignment(Element element, String string, int[] nArray) throws Exception {
        if (nArray == null) {
            nArray = DEFAULT_ALIGNMENT;
        }
        if (string != null) {
            element = JDomUtility.getChildWithId(element, ALIGNMENT, string);
        } else if (element != null && !element.getName().equals(ALIGNMENT)) {
            element = element.getChild(ALIGNMENT);
        }
        if (element == null) {
            return nArray;
        }
        int[] nArray2 = new int[]{JDomUtility.getHAlign(element, nArray == null ? nArray[0] : 1), JDomUtility.getVAlign(element, nArray == null ? nArray[1] : 1)};
        return nArray2;
    }

    public static int[] getAlignProp(Element element, String string, int[] nArray) throws Exception {
        String string2;
        int[] nArray2 = new int[2];
        if (nArray == null) {
            nArray = DEFAULT_ALIGNMENT;
        }
        nArray2[0] = nArray[0];
        nArray2[1] = nArray[1];
        if (string != null && (string2 = element.getAttributeValue(string)) != null && string2.length() > 0) {
            StringTokenizer stringTokenizer = new StringTokenizer(string2, ",");
            if (stringTokenizer.hasMoreTokens()) {
                nArray2[0] = JDomUtility.getStrIndexAttr(stringTokenizer.nextToken(), hAlignName, nArray[0]);
            }
            if (stringTokenizer.hasMoreTokens()) {
                nArray2[1] = JDomUtility.getStrIndexAttr(stringTokenizer.nextToken(), vAlignName, nArray[1]);
            }
        }
        return nArray2;
    }

    public static void setAlignProp(Element element, String string, int[] nArray, boolean bl) {
        if (!(element == null || string == null || nArray == null || nArray.length != 2 || bl && JDomUtility.isDefaultAlign(nArray))) {
            element.setAttribute(string, hAlignName[nArray[0]] + "," + vAlignName[nArray[1]]);
        }
    }

    public static boolean isDefaultAlign(int[] nArray) {
        return nArray != null && nArray[0] == 1 && nArray[1] == 1;
    }

    public static void addParagraphs(Element element, String string, String string2) {
        if (string2 != null) {
            Element element2 = new Element(string);
            JDomUtility.setParagraphs(element2, string2);
            element.addContent((Content)element2);
        }
    }

    public static void setParagraphs(Element element, String string) {
        if (string != null) {
            StringTokenizer stringTokenizer = new StringTokenizer(string, NEWLINE);
            while (stringTokenizer.hasMoreTokens()) {
                element.addContent((Content)new Element(P).setText(stringTokenizer.nextToken()));
            }
        }
    }

    public static String getParagraphs(Element element) {
        StringBuffer stringBuffer = null;
        if (element != null) {
            Iterator iterator = element.getChildren(P).iterator();
            while (iterator.hasNext()) {
                String string = ((Element)iterator.next()).getText();
                if (stringBuffer == null) {
                    stringBuffer = new StringBuffer(string);
                    continue;
                }
                stringBuffer.append(NEWLINE).append(string);
            }
        }
        return stringBuffer == null ? null : stringBuffer.substring(0);
    }

    public static String intArrayToString(int[] nArray) {
        return JDomUtility.intArrayToString(nArray, nArray.length);
    }

    public static String intArrayToString(int[] nArray, int n) {
        StringBuffer stringBuffer = new StringBuffer(n * 4);
        int n2 = 0;
        while (n2 < n) {
            stringBuffer.append(nArray[n2]).append(' ');
            ++n2;
        }
        return stringBuffer.substring(0).trim();
    }

    public static int[] stringToIntArray(String string) throws Exception {
        int[] nArray = null;
        StringTokenizer stringTokenizer = new StringTokenizer(string, " ");
        int n = stringTokenizer.countTokens();
        nArray = new int[n];
        int n2 = 0;
        while (n2 < n) {
            nArray[n2] = Integer.parseInt(stringTokenizer.nextToken());
            ++n2;
        }
        return nArray;
    }

    public static int getIntAttr(Element element, String string, int n) {
        String string2 = element.getAttributeValue(string);
        int n2 = n;
        if (string2 != null) {
            n2 = Integer.parseInt(string2);
        }
        return n2;
    }

    public static long getLongAttr(Element element, String string, long l) {
        String string2 = element.getAttributeValue(string);
        long l2 = l;
        if (string2 != null) {
            l2 = Long.parseLong(string2);
        }
        return l2;
    }

    public static String triStateString(int n) {
        if (n < 0 || n >= 2) {
            n = 2;
        }
        return BOOL_STR[n];
    }

    public static int getTriStateAttr(Element element, String string, int n) throws Exception {
        return JDomUtility.getStrIndexAttr(element, string, BOOL_STR, n);
    }

    public static boolean checkTriState(int n) {
        return n >= 0 && n <= 2;
    }

    public static String boolString(boolean bl) {
        return BOOL_STR[bl ? 1 : 0];
    }

    public static boolean getBoolAttr(Element element, String string, boolean bl) {
        String string2 = element.getAttributeValue(string);
        boolean bl2 = bl;
        if (string2 != null) {
            if (string2.equalsIgnoreCase(BOOL_STR[1])) {
                bl2 = true;
            } else if (string2.equalsIgnoreCase(BOOL_STR[0])) {
                bl2 = false;
            } else {
                throw new NumberFormatException("invalid boolean: " + string2);
            }
        }
        return bl2;
    }

    public static Boolean getBooleanAttr(Element element, String string, Boolean bl) {
        String string2 = element.getAttributeValue(string);
        Boolean bl2 = bl;
        if (string2 != null) {
            if (string2.equalsIgnoreCase(BOOL_STR[1]) || string2.equalsIgnoreCase(BOOL_STR[0])) {
                bl2 = new Boolean(string2);
            } else {
                throw new NumberFormatException("invalid boolean: " + string2);
            }
        }
        return bl2;
    }

    public static float getFloatAttr(Element element, String string, float f) {
        String string2 = element.getAttributeValue(string);
        float f2 = f;
        if (string2 != null) {
            f2 = Float.parseFloat(string2);
        }
        return f2;
    }

    public static double getDoubleAttr(Element element, String string, double d) {
        String string2 = element.getAttributeValue(string);
        double d2 = d;
        if (string2 != null) {
            d2 = Double.parseDouble(string2);
        }
        return d2;
    }

    public static String getStringAttr(Element element, String string, String string2, boolean bl) {
        String string3 = element.getAttributeValue(string);
        String string4 = string2;
        if (string3 != null && (bl || string3.length() > 0)) {
            string4 = string3;
        }
        return string4;
    }

    public static void setStringAttr(Element element, String string, String string2, boolean bl) {
        String string3;
        String string4 = string3 = bl && (string2 == null || string2.length() == 0) ? BLANK : string2;
        if (string != null && string3 != null) {
            element.setAttribute(string, string3);
        }
    }

    public static int getStrIndexAttr(Element element, String string, String[] stringArray, int n) throws Exception {
        return JDomUtility.getStrIndexAttr(element.getAttributeValue(string), stringArray, n);
    }

    public static int getStrIndexAttr(String string, String[] stringArray, int n) throws Exception {
        int n2 = n;
        if (string != null && string.length() > 0) {
            n2 = 0;
            while (n2 < stringArray.length) {
                if (string.equalsIgnoreCase(stringArray[n2])) break;
                ++n2;
            }
            if (n2 == stringArray.length) {
                throw new Exception("Unknown value: " + string);
            }
        }
        return n2;
    }

    public static Dimension getDimensionAttr(Element element, String string, String string2, Dimension dimension) {
        Dimension dimension2 = dimension;
        int n = JDomUtility.getIntAttr(element, string, -18634527);
        int n2 = JDomUtility.getIntAttr(element, string2, -18634527);
        if (n != -18634527 && n2 != -18634527) {
            dimension2 = new Dimension(n, n2);
        }
        return dimension2;
    }

    public static Point getPointAttr(Element element, String string, String string2, Point point) {
        Point point2 = point;
        int n = JDomUtility.getIntAttr(element, string, -18634527);
        int n2 = JDomUtility.getIntAttr(element, string2, -18634527);
        if (n != -18634527 && n2 != -18634527) {
            point2 = new Point(n, n2);
        }
        return point2;
    }

    public static String dateToStringShortUS(Date date) {
        return DateFormat.getDateInstance(3, Locale.US).format(date);
    }

    public static Date getDateAttrShortUS(Element element, String string, Date date) throws Exception {
        Date date2 = date;
        String string2 = null;
        string2 = JDomUtility.getStringAttr(element, string, null, false);
        if (string2 != null) {
            date2 = DateFormat.getDateInstance(3, Locale.US).parse(string2);
        }
        return date2;
    }

    public static void clearNewLineElements(Element element) {
        if (element != null) {
            Vector vector = null;
            boolean bl = !element.getChildren().isEmpty();
            List list = element.getContent();
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                Object e = iterator.next();
                if (e instanceof Element) {
                    JDomUtility.clearNewLineElements((Element)e);
                    continue;
                }
                if (!bl || !(e instanceof Text)) continue;
                if (vector == null) {
                    vector = new Vector();
                }
                vector.add(e);
            }
            if (vector != null) {
                list.removeAll(vector);
            }
        }
    }

    public static SAXBuilder getSAXBuilder() {
        if (saxBuilder == null) {
            saxBuilder = new SAXBuilder();
        }
        return saxBuilder;
    }

    public static void saveDocument(OutputStream outputStream, Element element) throws Exception {
        JDomUtility.saveDocument(outputStream, new Document(element));
    }

    public static void saveDocument(OutputStream outputStream, Document document) throws Exception {
        JDomUtility.getXMLOutputter().output(document, outputStream);
        outputStream.flush();
    }

    public static XMLOutputter getXMLOutputter() {
        if (outputter == null) {
            Format format = Format.getPrettyFormat();
            format.setIndent(" ");
            format.setEncoding("UTF-8");
            format.setTextMode(Format.TextMode.PRESERVE);
            outputter = new XMLOutputter(format);
        }
        return outputter;
    }

    public static void checkName(Element element, String string) throws Exception {
        if (element == null) {
            throw new JDOMException("Null element passed as argument, expecting: \"" + string + "\"");
        }
        if (!element.getName().equals(string)) {
            throw new JDOMException("Find element \"" + element.getName() + "\" while expecting \"" + string + "\"");
        }
    }

    public static String getClassName(Element element) throws Exception {
        String string = element.getAttributeValue(CLASS);
        if (element == null) {
            throw new JDOMException("Element without class name!");
        }
        return string;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        HTML_COLOR_NAMES = new String[]{"Black", "Silver", "Gray", "White", "Maroon", "Red", "Purple", "Fuchsia", "Green", "Lime", "Olive", "Yellow", "Navy", "Blue", "Teal", "Aqua", "Pink", "Orange", "DarkGray"};
        HTML_COLORS = new Color[]{Color.black, Color.lightGray, Color.gray, Color.white, new Color(128, 0, 0), Color.red, new Color(128, 0, 128), Color.magenta, new Color(0, 128, 0), Color.green, new Color(128, 128, 0), Color.yellow, new Color(0, 0, 128), Color.blue, new Color(0, 128, 128), Color.cyan, Color.pink, Color.orange, Color.darkGray};
        directionName = new String[]{UP, DOWN, LEFT, RIGHT};
        hAlignName = new String[]{LEFT, "middle", RIGHT};
        vAlignName = new String[]{TOP, "middle", BOTTOM};
        DEFAULT_ALIGNMENT = new int[]{1, 1};
        BOOL_STR = new String[]{"false", "true", "default"};
    }
}

