/*
 * Decompiled with CFR 0.152.
 */
package freemind.view.mindmapview;

import java.awt.Component;
import java.awt.Graphics;
import java.util.Vector;
import javax.swing.ImageIcon;

public class MultipleImage
extends ImageIcon {
    private Vector mImages = new Vector();
    private double zoomFactor = 1.0;

    MultipleImage(double zoom) {
        this.zoomFactor = zoom;
    }

    public int getImageCount() {
        return this.mImages.size();
    }

    public void addImage(ImageIcon image) {
        this.mImages.add(image);
    }

    public void paintIcon(Component c, Graphics g, int x, int y) {
        int myX = x;
        int myHeight = this.getIconHeight();
        for (int i = 0; i < this.mImages.size(); ++i) {
            ImageIcon currentIcon = (ImageIcon)this.mImages.get(i);
            int px = myX;
            int py = y + (myHeight - (int)((double)currentIcon.getIconHeight() * this.zoomFactor)) / 2;
            int pwidth = (int)((double)currentIcon.getIconWidth() * this.zoomFactor);
            int pheight = (int)((double)currentIcon.getIconHeight() * this.zoomFactor);
            if (currentIcon.getImageObserver() == null) {
                g.drawImage(currentIcon.getImage(), px, py, pwidth, pheight, c);
            } else {
                g.drawImage(currentIcon.getImage(), px, py, pwidth, pheight, currentIcon.getImageObserver());
            }
            myX += pwidth;
        }
    }

    public int getIconWidth() {
        int myX = 0;
        for (int i = 0; i < this.mImages.size(); ++i) {
            myX += ((ImageIcon)this.mImages.get(i)).getIconWidth();
        }
        return (int)((double)myX * this.zoomFactor);
    }

    public int getIconHeight() {
        int myY = 0;
        for (int i = 0; i < this.mImages.size(); ++i) {
            int otherHeight = ((ImageIcon)this.mImages.get(i)).getIconHeight();
            if (otherHeight <= myY) continue;
            myY = otherHeight;
        }
        return (int)((double)myY * this.zoomFactor);
    }
}

