/*
 * Decompiled with CFR 0.152.
 */
package edu.xtec.jclic.boxes;

import edu.xtec.jclic.PlayStation;
import edu.xtec.jclic.bags.MediaBag;
import edu.xtec.jclic.bags.MediaBagElement;
import edu.xtec.jclic.boxes.ActiveBoxContent;
import edu.xtec.jclic.boxes.BoxBase;
import edu.xtec.jclic.fileSystem.FileSystem;
import edu.xtec.jclic.shapers.Rectangular;
import edu.xtec.jclic.shapers.Shaper;
import edu.xtec.util.Domable;
import edu.xtec.util.JDomUtility;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.geom.Rectangle2D;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import org.jdom.Content;
import org.jdom.Element;

public class ActiveBagContent
implements Domable {
    public Image img;
    public String imgName;
    public int ncw;
    public int nch;
    public double w;
    public double h;
    public boolean border;
    public BoxBase bb;
    protected Shaper shaper;
    protected ActiveBoxContent backgroundContent;
    protected ArrayList activeBoxContentArray = new ArrayList(12);
    public int defaultIdValue = -1;
    public static final String ELEMENT_NAME = "cells";
    public static final String ROWS = "rows";
    public static final String COLUMNS = "columns";
    public static final String COLS = "cols";
    public static final String CELL_WIDTH = "cellWidth";
    public static final String CELL_HEIGHT = "cellHeight";
    public static final String BORDER = "border";
    public static final String IMAGE = "image";
    public static final String IDS = "ids";

    private ActiveBagContent() {
    }

    public ActiveBagContent(int n, int n2) {
        this.ncw = Math.max(1, n);
        this.nch = Math.max(1, n2);
        this.w = 20.0;
        this.h = 20.0;
    }

    public static ActiveBagContent initNew(int n, int n2, int n3) {
        return ActiveBagContent.initNew(n, n2, n3, false, false, 50, 30);
    }

    public static ActiveBagContent initNew(int n, int n2, int n3, boolean bl, boolean bl2, int n4, int n5) {
        ActiveBagContent activeBagContent = new ActiveBagContent(n, n2);
        activeBagContent.w = n4;
        activeBagContent.h = n5;
        activeBagContent.setBoxBase(new BoxBase());
        activeBagContent.border = true;
        char[] cArray = null;
        if (n3 > 0) {
            cArray = new char[]{(char)n3};
        }
        int n6 = 0;
        while (n6 < n2) {
            int n7 = 0;
            while (n7 < n) {
                ActiveBoxContent activeBoxContent = new ActiveBoxContent();
                if (cArray != null) {
                    activeBoxContent.setTextContent("");
                    cArray[0] = (char)(cArray[0] + '\u0001');
                } else {
                    activeBoxContent.setTextContent("");
                }
                if (bl) {
                    if (bl2) {
                        activeBoxContent.id = n7;
                        activeBoxContent.item = n6;
                    } else {
                        activeBoxContent.id = n6 * n + n7;
                    }
                }
                activeBagContent.addActiveBoxContent(activeBoxContent);
                ++n7;
            }
            ++n6;
        }
        return activeBagContent;
    }

    public void checkCells() {
        block3: {
            int n;
            int n2;
            block2: {
                n2 = this.getShaper().getNumCells();
                n = this.activeBoxContentArray.size();
                if (n <= n2) break block2;
                while (this.activeBoxContentArray.size() > n2) {
                    this.activeBoxContentArray.remove(this.activeBoxContentArray.size() - 1);
                }
                break block3;
            }
            if (n2 <= n) break block3;
            int n3 = n;
            while (n3 < n2) {
                ActiveBoxContent activeBoxContent = this.getActiveBoxContent(n3);
                activeBoxContent.id = this.defaultIdValue;
                ++n3;
            }
        }
    }

    public Element getJDomElement() {
        Element element = new Element(ELEMENT_NAME);
        if (this.ncw > 0 || this.nch > 0) {
            element.setAttribute(ROWS, Integer.toString(this.nch));
            element.setAttribute(COLS, Integer.toString(this.ncw));
        }
        if (this.imgName == null && (this.w != 0.0 || this.h != 0.0)) {
            element.setAttribute(CELL_WIDTH, Double.toString(this.w));
            element.setAttribute(CELL_HEIGHT, Double.toString(this.h));
        }
        element.setAttribute(BORDER, JDomUtility.boolString((boolean)this.border));
        if (this.imgName != null) {
            element.setAttribute(IMAGE, this.imgName);
        }
        if (this.bb != null) {
            element.addContent((Content)this.bb.getJDomElement());
        }
        if (this.shaper != null) {
            element.addContent((Content)this.shaper.getJDomElement());
        }
        switch (this.testCellContents()) {
            case 0: {
                break;
            }
            case 1: {
                StringBuffer stringBuffer = new StringBuffer();
                int n = 0;
                while (n < this.activeBoxContentArray.size()) {
                    stringBuffer.append(this.getActiveBoxContent((int)n).id).append(" ");
                    ++n;
                }
                element.addContent((Content)new Element(IDS).addContent(stringBuffer.substring(0).trim()));
                break;
            }
            default: {
                int n = 0;
                while (n < this.activeBoxContentArray.size()) {
                    element.addContent((Content)this.getActiveBoxContent(n).getJDomElement());
                    ++n;
                }
                break block0;
            }
        }
        return element;
    }

    public int testCellContents() {
        int n = 0;
        int n2 = 0;
        while (n2 < this.activeBoxContentArray.size()) {
            int n3 = this.getActiveBoxContent(n2).testCellContents();
            if (n3 > n) {
                n = n3;
                if (n3 > 1) break;
            }
            ++n2;
        }
        return n;
    }

    public static ActiveBagContent getActiveBagContent(Element element, MediaBag mediaBag) throws Exception {
        ActiveBagContent activeBagContent = new ActiveBagContent();
        activeBagContent.setProperties(element, mediaBag);
        return activeBagContent;
    }

    public void setProperties(Element element, Object object) throws Exception {
        int n;
        int n2;
        Iterator iterator;
        JDomUtility.checkName((Element)element, (String)ELEMENT_NAME);
        MediaBag mediaBag = (MediaBag)object;
        int n3 = JDomUtility.getIntAttr((Element)element, (String)COLS, (int)-1);
        if (n3 >= 0) {
            this.ncw = n3;
            this.nch = JDomUtility.getIntAttr((Element)element, (String)ROWS, (int)this.nch);
        } else {
            this.ncw = JDomUtility.getIntAttr((Element)element, (String)ROWS, (int)this.ncw);
            this.nch = JDomUtility.getIntAttr((Element)element, (String)COLUMNS, (int)this.nch);
        }
        this.activeBoxContentArray.ensureCapacity(Math.max(12, this.ncw * this.nch));
        this.w = JDomUtility.getDoubleAttr((Element)element, (String)CELL_WIDTH, (double)this.w);
        this.h = JDomUtility.getDoubleAttr((Element)element, (String)CELL_HEIGHT, (double)this.h);
        this.border = JDomUtility.getBoolAttr((Element)element, (String)BORDER, (boolean)this.border);
        this.imgName = FileSystem.stdFn(element.getAttributeValue(IMAGE));
        Element element2 = element.getChild("style");
        if (element2 != null) {
            this.setBoxBase(BoxBase.getBoxBase(element2));
        }
        if ((element2 = element.getChild("shaper")) != null) {
            this.setShaper(Shaper.getShaper(element2));
        }
        if ((iterator = element.getChildren("cell").iterator()).hasNext()) {
            while (iterator.hasNext()) {
                element2 = (Element)iterator.next();
                this.addActiveBoxContent(ActiveBoxContent.getActiveBoxContent(element2, mediaBag));
            }
        } else {
            int[] nArray;
            element2 = element.getChild(IDS);
            if (element2 != null && (nArray = JDomUtility.stringToIntArray((String)element2.getText())) != null) {
                n2 = 0;
                while (n2 < nArray.length) {
                    this.getActiveBoxContent((int)n2).id = nArray[n2];
                    ++n2;
                }
            }
        }
        if (this.imgName != null && mediaBag != null && mediaBag.getProject().getBridge() != null) {
            this.setImgContent(mediaBag.getImageElement(this.imgName), true);
        }
        if ((n = this.activeBoxContentArray.size()) > 0) {
            n2 = 1;
            int n4 = 0;
            while (n4 < n) {
                ActiveBoxContent activeBoxContent = this.getActiveBoxContent(n4);
                if (activeBoxContent.id != -1 || activeBoxContent.item != -1 || !activeBoxContent.isEmpty()) {
                    n2 = 0;
                    break;
                }
                ++n4;
            }
            if (n2 != 0) {
                int n5 = 0;
                while (n5 < n) {
                    this.getActiveBoxContent((int)n5).id = n5;
                    ++n5;
                }
            }
        }
    }

    public static void listReferences(Element element, HashMap hashMap) {
        String string = element.getAttributeValue(IMAGE);
        if (string != null) {
            hashMap.put(string, "media");
        }
        Iterator iterator = element.getChildren("cell").iterator();
        while (iterator.hasNext()) {
            ActiveBoxContent.listReferences((Element)iterator.next(), hashMap);
        }
    }

    public Shaper getShaper() {
        if (this.shaper == null) {
            this.setShaper(new Rectangular(this.ncw, this.nch));
        }
        return this.shaper;
    }

    public void setShaper(Shaper shaper) {
        this.shaper = shaper;
    }

    public void addActiveBoxContent(ActiveBoxContent activeBoxContent) {
        this.activeBoxContentArray.add(activeBoxContent);
        if (this.ncw == 0 || this.nch == 0) {
            this.ncw = 1;
            this.nch = 1;
        }
    }

    public ActiveBoxContent getActiveBoxContent(int n) {
        if (n >= this.activeBoxContentArray.size()) {
            int n2 = this.activeBoxContentArray.size();
            while (n2 <= n) {
                this.activeBoxContentArray.add(new ActiveBoxContent());
                ++n2;
            }
        }
        return (ActiveBoxContent)this.activeBoxContentArray.get(n);
    }

    public ActiveBoxContent getActiveBoxContentWith(int n, int n2) {
        ActiveBoxContent activeBoxContent = null;
        int n3 = 0;
        while (n3 < this.activeBoxContentArray.size()) {
            ActiveBoxContent activeBoxContent2 = (ActiveBoxContent)this.activeBoxContentArray.get(n3);
            if (activeBoxContent2.id == n && activeBoxContent2.item == n2) {
                activeBoxContent = activeBoxContent2;
                break;
            }
            ++n3;
        }
        return activeBoxContent;
    }

    public void deleteActiveBoxContentWith(int n, int n2) {
        ActiveBoxContent activeBoxContent = this.getActiveBoxContentWith(n, n2);
        if (activeBoxContent != null) {
            ((AbstractCollection)this.activeBoxContentArray).remove(activeBoxContent);
            int n3 = 0;
            while (n3 < this.activeBoxContentArray.size()) {
                activeBoxContent = (ActiveBoxContent)this.activeBoxContentArray.get(n3);
                if (activeBoxContent.id == n && activeBoxContent.item > n2) {
                    --activeBoxContent.item;
                }
                ++n3;
            }
        }
    }

    public void insertActiveBoxContentWith(int n, int n2) {
        ActiveBoxContent activeBoxContent = this.getActiveBoxContentWith(n, n2);
        int n3 = this.activeBoxContentArray.indexOf(activeBoxContent);
        int n4 = 0;
        while (n4 < this.activeBoxContentArray.size()) {
            activeBoxContent = (ActiveBoxContent)this.activeBoxContentArray.get(n4);
            if (activeBoxContent.id == n && activeBoxContent.item >= n2) {
                ++activeBoxContent.item;
            }
            ++n4;
        }
        activeBoxContent = new ActiveBoxContent();
        activeBoxContent.id = n;
        activeBoxContent.item = n2;
        this.activeBoxContentArray.add(n3 + 1, activeBoxContent);
    }

    public int indexOf(ActiveBoxContent activeBoxContent) {
        int n = -1;
        int n2 = 0;
        while (n2 < this.activeBoxContentArray.size()) {
            if (this.activeBoxContentArray.get(n2) == activeBoxContent) {
                n = n2;
                break;
            }
            ++n2;
        }
        return n;
    }

    public void setActiveBoxContentAt(ActiveBoxContent activeBoxContent, int n) {
        if (n >= 0) {
            this.getActiveBoxContent(n);
            this.activeBoxContentArray.set(n, activeBoxContent);
        }
    }

    public void setImgContent(MediaBagElement mediaBagElement, boolean bl) throws Exception {
        this.setImgContent(mediaBagElement, this.getShaper(), bl);
    }

    public void setImgContent(MediaBagElement mediaBagElement, Shaper shaper) throws Exception {
        this.setImgContent(mediaBagElement, shaper, false);
    }

    public void setImgContent(MediaBagElement mediaBagElement, Shaper shaper, boolean bl) throws Exception {
        this.setShaper(shaper);
        this.ncw = this.shaper.getNumColumns();
        this.nch = this.shaper.getNumRows();
        if (mediaBagElement != null) {
            this.img = mediaBagElement.getImage();
            this.imgName = mediaBagElement.getName();
            this.w = -1.0;
            this.h = -1.0;
            while (true) {
                this.w = (double)this.img.getWidth(null) / (double)this.ncw;
                this.h = (double)this.img.getHeight(null) / (double)this.nch;
                if (this.w >= 0.0 && this.h >= 0.0) break;
                Thread.currentThread();
                Thread.sleep(50L);
            }
            if (bl) {
                this.w = (int)this.w;
                this.h = (int)this.h;
            }
            if (this.w < 1.0 || this.h < 1.0) {
                throw new Exception("Invalid image!");
            }
        } else {
            this.img = null;
            this.imgName = null;
            this.w = Math.max(this.w, 10.0);
            this.h = Math.max(this.h, 10.0);
        }
        Rectangle2D.Double double_ = new Rectangle2D.Double(0.0, 0.0, this.w * (double)this.ncw, this.h * (double)this.nch);
        this.activeBoxContentArray.ensureCapacity(this.shaper.getNumCells());
        int n = 0;
        while (n < this.shaper.getNumCells()) {
            this.getActiveBoxContent(n).setImgContent(this.img, this.shaper.getShape(n, double_));
            ++n;
        }
        if (this.shaper.hasRemainder()) {
            this.backgroundContent = new ActiveBoxContent();
            this.backgroundContent.setImgContent(this.img, this.shaper.getRemainderShape(double_));
        }
    }

    public void setTextContent(String[] stringArray, int n, int n2) {
        this.ncw = Math.max(1, n);
        this.nch = Math.max(1, n2);
        int n3 = this.ncw * this.nch;
        this.activeBoxContentArray.ensureCapacity(n3);
        int n4 = 0;
        while (n4 < n3) {
            this.getActiveBoxContent(n4).setTextContent(n4 >= stringArray.length || stringArray[n4] == null ? new String("") : stringArray[n4]);
            ++n4;
        }
    }

    public boolean hasImg() {
        return this.img != null;
    }

    public double getTotalWidth() {
        return this.w * (double)this.ncw;
    }

    public double getTotalHeight() {
        return this.h * (double)this.nch;
    }

    public int getNumCells() {
        return this.activeBoxContentArray.size();
    }

    public boolean isEmpty() {
        return this.activeBoxContentArray.isEmpty();
    }

    public void prepareMedia(PlayStation playStation) {
        int n = 0;
        while (n < this.activeBoxContentArray.size()) {
            this.getActiveBoxContent(n).prepareMedia(playStation);
            ++n;
        }
        if (this.img != null && playStation.getOptions().getBoolean("preDrawImages")) {
            Graphics graphics = playStation.getComponent().getGraphics();
            graphics.drawImage(this.img, 0, 0, 0, 0, playStation.getComponent());
        }
    }

    public void setBoxBase(BoxBase boxBase) {
        this.bb = boxBase;
    }

    public void setIds(int[] nArray) {
        int n = 0;
        while (n < this.activeBoxContentArray.size()) {
            if (n < nArray.length) {
                this.getActiveBoxContent((int)n).id = nArray[n];
            }
            ++n;
        }
    }

    public void setAllIdsTo(int n) {
        int n2 = 0;
        while (n2 < this.activeBoxContentArray.size()) {
            this.getActiveBoxContent((int)n2).id = n;
            ++n2;
        }
    }

    public void copyStyleTo(ActiveBagContent activeBagContent) {
        if (activeBagContent != null) {
            activeBagContent.setBoxBase(this.bb);
            activeBagContent.border = this.border;
        }
    }
}

