/*
 * Decompiled with CFR 0.152.
 */
package edu.xtec.jclic.shapers;

import edu.xtec.jclic.shapers.ShapeData;
import edu.xtec.jclic.shapers.Shaper;
import edu.xtec.util.JDomUtility;
import org.jdom.Element;

public class JigSaw
extends Shaper {
    protected double baseWidthFactor = this.getDefaultBaseWidthFactor();
    protected double toothHeightFactor = this.getDefaultToothHeightFactor();
    protected boolean randomLines = false;
    protected static final String BASE_WIDTH_FACTOR = "baseWidthFactor";
    protected static final String TOOTH_HEIGHT_FACTOR = "toothHeightFactor";
    protected static final String RANDOM_LINES = "randomLines";

    public JigSaw(int n, int n2) {
        super(n, n2);
    }

    protected int getBaseFactor() {
        return 50;
    }

    public String getEditorPanelClassName() {
        return this.getClass().getPackage().getName() + ".JigSawEditorPanel";
    }

    protected double getDefaultBaseWidthFactor() {
        return 0.3333333432674408;
    }

    protected double getDefaultToothHeightFactor() {
        return 0.1666666716337204;
    }

    public Element getJDomElement() {
        Element element = super.getJDomElement();
        if (this.baseWidthFactor != this.getDefaultBaseWidthFactor()) {
            element.setAttribute(BASE_WIDTH_FACTOR, Double.toString(this.baseWidthFactor));
        }
        if (this.toothHeightFactor != this.getDefaultToothHeightFactor()) {
            element.setAttribute(TOOTH_HEIGHT_FACTOR, Double.toString(this.toothHeightFactor));
        }
        if (this.randomLines) {
            element.setAttribute(RANDOM_LINES, JDomUtility.boolString((boolean)this.randomLines));
        }
        return element;
    }

    public void setProperties(Element element, Object object) throws Exception {
        this.initiated = false;
        this.baseWidthFactor = JDomUtility.getDoubleAttr((Element)element, (String)BASE_WIDTH_FACTOR, (double)this.baseWidthFactor);
        this.toothHeightFactor = JDomUtility.getDoubleAttr((Element)element, (String)TOOTH_HEIGHT_FACTOR, (double)this.toothHeightFactor);
        this.randomLines = JDomUtility.getBoolAttr((Element)element, (String)RANDOM_LINES, (boolean)this.randomLines);
    }

    protected void buildShapes() {
        int[][] nArray = new int[this.nRows + 1][this.nCols + 1];
        int[][] nArray2 = new int[this.nRows + 1][this.nCols + 1];
        int n = 0;
        while (n < this.nRows) {
            int n2 = 0;
            while (n2 < this.nCols) {
                nArray[n][n2] = n == 0 ? 0 : 1 + (this.randomLines ? (int)(Math.random() * 9.0) : n + n2) % 2;
                nArray2[n][n2] = n2 == 0 ? 0 : 1 + (this.randomLines ? (int)(Math.random() * 9.0) : n2 + n + 1) % 2;
                if (n2 == this.nCols - 1) {
                    nArray2[n][n2 + 1] = 0;
                }
                if (n == this.nRows - 1) {
                    nArray[n + 1][n2] = 0;
                }
                ++n2;
            }
            ++n;
        }
        double d = 1.0 / (double)this.nCols;
        double d2 = 1.0 / (double)this.nRows;
        int n3 = 0;
        while (n3 < this.nRows) {
            int n4 = 0;
            while (n4 < this.nCols) {
                double d3 = d * (double)n4;
                double d4 = d2 * (double)n3;
                ShapeData shapeData = this.shapeData[n3 * this.nCols + n4];
                shapeData.moveTo(d3, d4);
                this.hLine(shapeData, nArray[n3][n4], d3 + 0.0, d4 + 0.0, d, d2, false);
                this.vLine(shapeData, nArray2[n3][n4 + 1], d3 + d, d4 + 0.0, d, d2, false);
                this.hLine(shapeData, nArray[n3 + 1][n4], d3 + d, d4 + d2, d, d2, true);
                this.vLine(shapeData, nArray2[n3][n4], d3 + 0.0, d4 + d2, d, d2, true);
                shapeData.closePath();
                ++n4;
            }
            ++n3;
        }
        this.initiated = true;
    }

    protected void hLine(ShapeData shapeData, int n, double d, double d2, double d3, double d4, boolean bl) {
        int n2;
        int n3 = bl ? -1 : 1;
        int n4 = n2 = n == 1 ? 1 : -1;
        if (n == 0) {
            shapeData.lineTo(d + d3 * (double)n3, d2);
        } else {
            double d5 = d + (d3 - d3 * this.baseWidthFactor) / 2.0 * (double)n3;
            double d6 = d3 * this.baseWidthFactor * (double)n3;
            shapeData.lineTo(d5, d2);
            double d7 = d4 * this.toothHeightFactor * (double)n2;
            shapeData.lineTo(d5, d2 + d7);
            shapeData.lineTo(d5 + d6, d2 + d7);
            shapeData.lineTo(d5 + d6, d2);
            shapeData.lineTo(d + d3 * (double)n3, d2);
        }
    }

    protected void vLine(ShapeData shapeData, int n, double d, double d2, double d3, double d4, boolean bl) {
        int n2;
        int n3 = bl ? -1 : 1;
        int n4 = n2 = n == 1 ? 1 : -1;
        if (n == 0) {
            shapeData.lineTo(d, d2 + d4 * (double)n3);
        } else {
            double d5 = d2 + (d4 - d4 * this.baseWidthFactor) / 2.0 * (double)n3;
            double d6 = d4 * this.baseWidthFactor * (double)n3;
            shapeData.lineTo(d, d5);
            double d7 = d3 * this.toothHeightFactor * (double)n2;
            shapeData.lineTo(d + d7, d5);
            shapeData.lineTo(d + d7, d5 + d6);
            shapeData.lineTo(d, d5 + d6);
            shapeData.lineTo(d, d2 + d4 * (double)n3);
        }
    }
}

