/*
 * Decompiled with CFR 0.152.
 */
package edu.xtec.jclic.boxes;

import edu.xtec.jclic.PlayStation;
import edu.xtec.jclic.bags.MediaBag;
import edu.xtec.jclic.bags.MediaBagElement;
import edu.xtec.jclic.boxes.BoxBase;
import edu.xtec.jclic.fileSystem.FileSystem;
import edu.xtec.jclic.media.ActiveMediaPlayer;
import edu.xtec.jclic.media.MediaContent;
import edu.xtec.util.Domable;
import edu.xtec.util.JDomUtility;
import edu.xtec.util.ResourceManager;
import edu.xtec.util.StrUtils;
import java.awt.Dimension;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.Shape;
import java.util.HashMap;
import org.jdom.Content;
import org.jdom.Element;

public class ActiveBoxContent
implements Cloneable,
Domable {
    public BoxBase bb = null;
    public Dimension dimension = null;
    public Boolean border = null;
    public String text = null;
    public String imgName = null;
    public Shape imgClip = null;
    public MediaContent mediaContent = null;
    public int[] imgAlign = new int[]{1, 1};
    public int[] txtAlign = new int[]{1, 1};
    public boolean avoidOverlapping = false;
    public int id = -1;
    public int item = -1;
    public Image img = null;
    protected static ActiveBoxContent EMPTY_CONTENT;
    public Object userData = null;
    public String rawText = null;
    public String htmlText = null;
    public String innerHtmlText = null;
    public boolean animated = false;
    public ActiveMediaPlayer amp = null;
    public static final String ELEMENT_NAME = "cell";
    protected static final String ID = "id";
    protected static final String ITEM = "item";
    protected static final String WIDTH = "width";
    protected static final String HEIGHT = "height";
    protected static final String BORDER = "border";
    protected static final String IMAGE = "image";
    protected static final String TXTALIGN = "txtAlign";
    protected static final String IMGALIGN = "imgAlign";
    protected static final String AVOID_OVERLAPPING = "avoidOverlapping";
    public static final int EMPTY_CELL = 0;
    public static final int ONLY_ID = 1;
    public static final int HAS_CONTENT = 2;

    protected void copyRawDataFrom(ActiveBoxContent activeBoxContent) {
        this.bb = activeBoxContent.bb;
        this.dimension = activeBoxContent.dimension;
        this.border = activeBoxContent.border;
        this.text = activeBoxContent.text;
        this.imgName = activeBoxContent.imgName;
        this.imgClip = activeBoxContent.imgClip;
        this.mediaContent = activeBoxContent.mediaContent;
        this.imgAlign = activeBoxContent.imgAlign;
        this.txtAlign = activeBoxContent.txtAlign;
        this.avoidOverlapping = activeBoxContent.avoidOverlapping;
        this.id = activeBoxContent.id;
        this.item = activeBoxContent.item;
        this.img = activeBoxContent.img;
        this.userData = activeBoxContent.userData;
        this.rawText = activeBoxContent.rawText;
        this.htmlText = activeBoxContent.htmlText;
        this.innerHtmlText = activeBoxContent.innerHtmlText;
        this.animated = activeBoxContent.animated;
        this.amp = activeBoxContent.amp;
    }

    public static ActiveBoxContent getEmptyContent() {
        if (EMPTY_CONTENT == null) {
            EMPTY_CONTENT = new ActiveBoxContent();
        }
        return EMPTY_CONTENT;
    }

    public Element getJDomElement() {
        Element element = new Element(ELEMENT_NAME);
        if (this.id != -1) {
            element.setAttribute(ID, Integer.toString(this.id));
        }
        if (this.item != -1) {
            element.setAttribute(ITEM, Integer.toString(this.item));
        }
        JDomUtility.setAlignProp((Element)element, (String)TXTALIGN, (int[])this.txtAlign, (boolean)true);
        JDomUtility.setAlignProp((Element)element, (String)IMGALIGN, (int[])this.imgAlign, (boolean)true);
        if (this.avoidOverlapping) {
            element.setAttribute(AVOID_OVERLAPPING, JDomUtility.boolString((boolean)this.avoidOverlapping));
        }
        if (this.dimension != null) {
            element.setAttribute(WIDTH, Integer.toString(this.dimension.width));
            element.setAttribute(HEIGHT, Integer.toString(this.dimension.height));
        }
        if (this.border != null) {
            element.setAttribute(BORDER, JDomUtility.boolString((boolean)this.border));
        }
        if (this.imgName != null) {
            element.setAttribute(IMAGE, this.imgName);
        }
        if (this.bb != null) {
            element.addContent((Content)this.bb.getJDomElement());
        }
        if (this.mediaContent != null) {
            element.addContent((Content)this.mediaContent.getJDomElement());
        }
        if (this.text != null) {
            JDomUtility.setParagraphs((Element)element, (String)this.text);
        }
        return element;
    }

    public int testCellContents() {
        if (JDomUtility.isDefaultAlign((int[])this.txtAlign) && JDomUtility.isDefaultAlign((int[])this.imgAlign) && !this.avoidOverlapping && this.dimension == null && this.border == null && this.imgName == null && this.bb == null && this.mediaContent == null && (this.text == null || this.text.length() == 0)) {
            return this.id == -1 && this.item == -1 ? 0 : 1;
        }
        return 2;
    }

    public static ActiveBoxContent getActiveBoxContent(Element element, MediaBag mediaBag) throws Exception {
        ActiveBoxContent activeBoxContent = new ActiveBoxContent();
        activeBoxContent.setProperties(element, mediaBag);
        return activeBoxContent;
    }

    public void setProperties(Element element, Object object) throws Exception {
        JDomUtility.checkName((Element)element, (String)ELEMENT_NAME);
        MediaBag mediaBag = (MediaBag)object;
        Element element2 = null;
        this.id = JDomUtility.getIntAttr((Element)element, (String)ID, (int)this.id);
        this.item = JDomUtility.getIntAttr((Element)element, (String)ITEM, (int)this.item);
        if (element.getAttribute("hAlign") != null || element.getAttribute("vAlign") != null) {
            this.txtAlign[0] = JDomUtility.getHAlign((Element)element, (int)this.txtAlign[0]);
            this.txtAlign[1] = JDomUtility.getVAlign((Element)element, (int)this.txtAlign[1]);
            this.imgAlign[0] = this.txtAlign[0];
            this.imgAlign[1] = this.txtAlign[1];
        } else {
            this.txtAlign = JDomUtility.getAlignProp((Element)element, (String)TXTALIGN, (int[])this.txtAlign);
            this.imgAlign = JDomUtility.getAlignProp((Element)element, (String)IMGALIGN, (int[])this.imgAlign);
        }
        this.avoidOverlapping = JDomUtility.getBoolAttr((Element)element, (String)AVOID_OVERLAPPING, (boolean)this.avoidOverlapping);
        this.dimension = JDomUtility.getDimensionAttr((Element)element, (String)WIDTH, (String)HEIGHT, (Dimension)this.dimension);
        this.border = JDomUtility.getBooleanAttr((Element)element, (String)BORDER, (Boolean)this.border);
        this.imgName = FileSystem.stdFn(element.getAttributeValue(IMAGE));
        element2 = element.getChild("style");
        if (element2 != null) {
            this.setBoxBase(BoxBase.getBoxBase(element2));
        }
        if ((element2 = element.getChild("media")) != null) {
            this.mediaContent = MediaContent.getMediaContent(element2);
        }
        this.setTextContent(JDomUtility.getParagraphs((Element)element));
        if (mediaBag != null) {
            this.realizeContent(mediaBag);
        }
    }

    public static void listReferences(Element element, HashMap hashMap) {
        if (element != null) {
            Element element2;
            String string = element.getAttributeValue(IMAGE);
            if (string != null && string.length() > 0) {
                hashMap.put(string, "media");
            }
            if ((element2 = element.getChild("media")) != null) {
                MediaContent.listReferences(element2, hashMap);
            }
        }
    }

    public Object clone() {
        ActiveBoxContent activeBoxContent = null;
        try {
            activeBoxContent = (ActiveBoxContent)super.clone();
            activeBoxContent.txtAlign = new int[]{this.txtAlign[0], this.txtAlign[1]};
            activeBoxContent.imgAlign = new int[]{this.imgAlign[0], this.imgAlign[1]};
        }
        catch (Exception exception) {
            System.err.println("Unexpected error cloning ActiveBoxContent!");
        }
        return activeBoxContent;
    }

    public void realizeContent(MediaBag mediaBag) throws Exception {
        Object object;
        if (this.imgName != null && (object = mediaBag.getImageElement(this.imgName)) != null) {
            this.img = ((MediaBagElement)object).getImage();
            this.animated = ((MediaBagElement)object).animated;
        }
        if (this.mediaContent != null) {
            this.mediaContent.registerContentTo(mediaBag);
            if (this.img == null && (this.text == null || this.text.length() == 0)) {
                object = this.mediaContent.getIconName();
                this.img = ResourceManager.getImageIcon((String)("icons/" + (String)object)).getImage();
            }
        }
        this.checkHtmlText(mediaBag);
    }

    public boolean isEmpty() {
        return this.text == null && this.img == null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean isEquivalent(ActiveBoxContent activeBoxContent, boolean bl) {
        boolean bl2;
        boolean bl3;
        if (activeBoxContent == this) {
            return true;
        }
        boolean bl4 = false;
        if (activeBoxContent == null) return bl4;
        if (this.isEmpty() && activeBoxContent.isEmpty()) {
            if (this.id != activeBoxContent.id) return false;
            return true;
        }
        if (this.text == null) {
            if (activeBoxContent.text != null) return false;
            bl3 = true;
        } else {
            bl3 = bl ? this.text.equals(activeBoxContent.text) : this.text.equalsIgnoreCase(activeBoxContent.text);
        }
        if (!bl3) return false;
        if (this.mediaContent == null) {
            if (activeBoxContent.mediaContent != null) return false;
            bl2 = true;
        } else {
            bl2 = this.mediaContent.isEquivalent(activeBoxContent.mediaContent);
        }
        if (!bl2) return false;
        if (this.img != activeBoxContent.img) return false;
        if (this.imgClip == null) {
            if (activeBoxContent.imgClip != null) return false;
            return true;
        }
        boolean bl5 = this.imgClip.equals(activeBoxContent.imgClip);
        if (!bl5) return false;
        return true;
    }

    public boolean equals(Object object) {
        boolean bl;
        boolean bl2 = bl = object == this;
        if (!bl && object != null && object instanceof ActiveBoxContent) {
            ActiveBoxContent activeBoxContent = (ActiveBoxContent)object;
            bl = this.isEquivalent(activeBoxContent, true) && (this.bb == null && activeBoxContent.bb == null || this.bb != null && this.bb.equals(activeBoxContent.bb)) && this.txtAlign[0] == activeBoxContent.txtAlign[0] && this.txtAlign[1] == activeBoxContent.txtAlign[1] && this.imgAlign[0] == activeBoxContent.imgAlign[0] && this.imgAlign[1] == activeBoxContent.imgAlign[1] && this.avoidOverlapping == activeBoxContent.avoidOverlapping;
        }
        return bl;
    }

    public void setTextContent(String string) {
        if (string != null) {
            this.rawText = new String(string);
            this.text = new String(string);
            this.checkHtmlText(null);
        } else {
            this.rawText = null;
            this.text = null;
            this.htmlText = null;
            this.innerHtmlText = null;
        }
    }

    protected void checkHtmlText(MediaBag mediaBag) {
        this.htmlText = null;
        this.innerHtmlText = null;
        if (this.text != null && this.text.substring(0).toLowerCase().startsWith("<html>")) {
            int n;
            Object object;
            this.htmlText = new String(this.text);
            if (mediaBag != null) {
                object = mediaBag.getProject().getFileSystem();
                String string = ((FileSystem)object).root;
                if (!((FileSystem)object).isUrlBased()) {
                    string = "file:" + FileSystem.sysFn(string);
                }
                this.htmlText = StrUtils.replace((String)this.htmlText, (String)"SRC=\"", (String)("SRC=\"" + string));
                this.htmlText = StrUtils.replace((String)this.htmlText, (String)"src=\"", (String)("src=\"" + string));
            }
            if (((String)(object = this.htmlText.substring(0).toLowerCase())).indexOf("<body") == -1 && (n = ((String)object).indexOf("</html>")) >= 0) {
                this.innerHtmlText = this.htmlText.substring(6, n);
            }
        }
    }

    public void setImgContent(Image image, Shape shape) {
        this.img = image;
        this.imgName = null;
        this.imgClip = shape;
    }

    public void setImgAlign(int[] nArray) {
        this.imgAlign[0] = nArray[0];
        this.imgAlign[1] = nArray[1];
    }

    public void setImgAlign(int n, int n2) {
        this.imgAlign[0] = n;
        this.imgAlign[1] = n2;
    }

    public void setTxtAlign(int[] nArray) {
        this.txtAlign[0] = nArray[0];
        this.txtAlign[1] = nArray[1];
    }

    public void setTxtAlign(int n, int n2) {
        this.txtAlign[0] = n;
        this.txtAlign[1] = n2;
    }

    public void prepareMedia(PlayStation playStation) {
        this.amp = this.mediaContent != null ? playStation.getActiveMediaPlayer(this.mediaContent) : null;
    }

    public void setBoxBase(BoxBase boxBase) {
        this.bb = boxBase;
    }

    public void setDimension(Dimension dimension) {
        this.dimension = dimension;
    }

    public Dimension getDimension() {
        return this.dimension;
    }

    public void setBorder(boolean bl) {
        this.border = new Boolean(bl);
    }

    public void copyStyleTo(ActiveBoxContent activeBoxContent) {
        if (activeBoxContent != null) {
            activeBoxContent.setBoxBase(this.bb);
            if (this.border != null) {
                activeBoxContent.setBorder(this.border);
            }
        }
    }

    public String getDescription() {
        StringBuffer stringBuffer = new StringBuffer();
        if (this.text != null && this.text.length() > 0) {
            stringBuffer.append(this.text);
        } else if (this.imgName != null) {
            stringBuffer.append("IMG:").append(this.imgName);
        } else if (this.imgClip != null) {
            Rectangle rectangle = this.imgClip.getBounds();
            stringBuffer.append("[").append(rectangle.x).append(",").append(rectangle.y).append(",");
            stringBuffer.append(rectangle.width).append(",").append(rectangle.height).append("]");
        }
        if (this.mediaContent != null) {
            if (stringBuffer.length() > 0) {
                stringBuffer.append(' ');
            }
            stringBuffer.append(this.mediaContent.getDescription());
        }
        return stringBuffer.substring(0);
    }
}

