/*
 * Decompiled with CFR 0.152.
 */
package edu.xtec.jclic.clic3;

import edu.xtec.jclic.Activity;
import edu.xtec.jclic.bags.ActivityBag;
import edu.xtec.jclic.bags.ActivitySequenceElement;
import edu.xtec.jclic.bags.ActivitySequenceJump;
import edu.xtec.jclic.bags.ConditionalJumpInfo;
import edu.xtec.jclic.clic3.Clic3Activity;
import edu.xtec.jclic.clic3.Clic3Pac;
import edu.xtec.jclic.clic3.TripleColor;
import edu.xtec.jclic.fileSystem.FileSystem;
import edu.xtec.jclic.fileSystem.PCCFileSystem;
import edu.xtec.jclic.project.JClicProject;
import java.awt.Color;
import java.util.Vector;

public abstract class Clic3 {
    public static final int CLICVER = 120;
    public static final String CLICSTR = "CLIC120";
    protected static final String BLANK = "";
    protected static final String COMMA = ",";
    protected static final Color DEFAULT_BACK_COLOR = new Color(192, 192, 192);
    protected static final Color DEFAULT_COLOR_USUARI_0 = Color.blue;
    protected static final Color DEFAULT_COLOR_USUARI_1 = DEFAULT_BACK_COLOR;
    protected static final Color DEFAULT_COLOR_ERROR_0 = Color.white;
    protected static final Color DEFAULT_COLOR_ERROR_1 = Color.red;
    protected static final TripleColor DEFAULT_TRIPLE_COLOR = new TripleColor(Color.white, Color.black, Color.gray, false);
    public static final String[] extName = new String[]{"*.BMP", "*.GIF", "*.TXT", "*.PUZ", "*.SOP", "*.ASS", "*.CRW", "*.TXA", "*.PAC", "*.PCC", "*.P?C", "*.HLP", "*.MVB", "*.EXE", "*.MID", "*.WAV", "*.JPG", "*.PNG", ""};
    public static final int EXT_BMP = 0;
    public static final int EXT_GIF = 1;
    public static final int EXT_TXT = 2;
    public static final int EXT_PUZ = 3;
    public static final int EXT_SOP = 4;
    public static final int EXT_ASS = 5;
    public static final int EXT_CRW = 6;
    public static final int EXT_TXA = 7;
    public static final int EXT_PAC = 8;
    public static final int EXT_PCC = 9;
    public static final int EXT_PCG = 10;
    public static final int EXT_HLP = 11;
    public static final int EXT_MVB = 12;
    public static final int EXT_EXE = 13;
    public static final int EXT_MID = 14;
    public static final int EXT_WAV = 15;
    public static final int EXT_JPG = 16;
    public static final int EXT_PNG = 17;
    public static final int UNKNOWN_EXT = 18;
    public static final int NO_EXT = -1;
    protected static final int MAXCW = 20;
    protected static final int MAXCH = 20;
    protected static final int MAXGW = 21;
    protected static final int MAXGH = 10;
    public static final int NONE = 0;
    public static final int PUZZLE = 1;
    public static final int SOPA = 2;
    public static final int ASSOCIA = 3;
    public static final int CREUATS = 4;
    public static final int TEXTACT = 5;
    public static final int INTERC = 0;
    public static final int FORAT = 1;
    public static final int DOBLE = 2;
    public static final int MEMORY = 3;
    public static final int NORMAL = 0;
    public static final int ESPECIAL = 1;
    public static final int EXPLORA = 2;
    public static final int INFO = 3;
    public static final int IDENTIFICA = 4;
    public static final int ESCRIU = 5;
    public static final int FORATS = 0;
    public static final int COMPTEXT = 1;
    public static final int IDLLETRES = 2;
    public static final int IDPARAULES = 3;
    public static final int BPARAULES = 4;
    public static final int BPARAGRAFS = 5;
    public static final int AB = 0;
    public static final int BA = 1;
    public static final int AUB = 2;
    public static final int BUA = 3;
    public static final int DEF_TXTCASW = 140;
    public static final int DEF_TXTCASH = 100;
    public static final int DEF_CICLES = 30;
    public static final int NEGRE = 160;
    public static final char COMODI = '*';
    public static final char SEPARADOR = ';';
    public static final byte ENDDESC_BYTE = -121;
    public static final char ENDDESC = '\u2021';
    public static final char CHBLOCK = '\u008e';
    public static final char CHINC = '\u008f';
    public static final char SEP = '\u0090';
    private static final String[] strArray = new String[]{"FFFFFF", "000000", "808080", "C0C0C0", "0000FF", "00FF00", "FF0000"};
    private static final Color[] colorArray = new Color[]{Color.white, Color.black, Color.gray, DEFAULT_BACK_COLOR, Color.red, Color.green, Color.blue};
    private static int gcCounter = 0;
    public static final String ansiChars = "\u20ac\u0081\u201a\u0192\u201e\u2026\u2020\u2021\u02c6\u2030\u0160\u2039\u0152\u008d\u008e\u008f\u0090\u2018\u2019\u201c\u201d\u2022\u2013\u2014\u02dc\u2122\u0161\u203a\u0153\u009d\u009e\u0178";
    public static final String convertFileChars = "e__f______s_c_z__________ts_o_zy_icl_y_s_ca___r_o_23__p__10_423_aaaaaaaceeeeiiiidnooooox0uuuuy_baaaaaaaceeeeiiiionooooo_0uuuuy_y";
    public static final String validFileChars = ".:\\_!~0123456789abcdefghijklmnopqrstuvwxyz";

    public static int getExt(String string) {
        if (string == null || string.length() == 0) {
            return 18;
        }
        int n = string.indexOf(32);
        if (n < 0) {
            n = string.length() - 1;
        }
        while (n > 0) {
            if (string.charAt(n) == '.') break;
            --n;
        }
        if (n == 0 || string.length() - n < 4) {
            return 18;
        }
        String string2 = "*" + string.substring(n, n + 4).toUpperCase();
        int n2 = 0;
        while (n2 < 18) {
            if (string2.equals(extName[n2])) break;
            ++n2;
        }
        if (n2 == 16 || n2 == 17) {
            n2 = 1;
        }
        return n2;
    }

    public static boolean isClic3Extension(int n) {
        switch (n) {
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                return true;
            }
        }
        return false;
    }

    public static int parseIntX(String string) {
        return Clic3.parseIntX(string, 10);
    }

    public static int parseIntX(String string, int n) {
        int n2;
        try {
            n2 = Integer.parseInt(string, n);
        }
        catch (NumberFormatException numberFormatException) {
            n2 = 0;
        }
        return n2;
    }

    protected static int correctColor(int n) {
        return (n & 0xFF) << 16 | n & 0xFF00 | (n & 0xFF0000) >> 16;
    }

    protected static Color strToColor(String string) {
        if (string == null) {
            return Color.black;
        }
        if (string.length() > 6) {
            string = string.substring(string.length() - 6);
        }
        int n = 0;
        while (n < strArray.length) {
            if (string.equals(strArray[n])) {
                return colorArray[n];
            }
            ++n;
        }
        return new Color(Clic3.correctColor(Clic3.parseIntX(string, 16)));
    }

    public static boolean copyArray(String[] stringArray, int n, String[] stringArray2, int n2, int n3, boolean bl) {
        int n4 = 0;
        int n5 = n;
        int n6 = n2;
        while (n4 < n3) {
            stringArray[n5] = stringArray2[n6];
            if (stringArray[n5] == null) break;
            if (bl) {
                stringArray[n5].toUpperCase();
            }
            ++n4;
            ++n5;
            ++n6;
        }
        return n4 == n3;
    }

    public static void readPccFile(JClicProject jClicProject) throws Exception {
        if (!(jClicProject.getFileSystem() instanceof PCCFileSystem)) {
            throw new Exception("FileSystem is not PCCFileSystem!");
        }
        PCCFileSystem pCCFileSystem = (PCCFileSystem)jClicProject.getFileSystem();
        int n = 0;
        while (n < pCCFileSystem.numFiles) {
            String string = pCCFileSystem.getEntryName(n);
            switch (Clic3.getExt(string)) {
                case 8: {
                    Clic3.addPacToSequence(jClicProject, string);
                    break;
                }
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: {
                    Clic3.addActivityToBag(jClicProject, string);
                    break;
                }
            }
            ++n;
        }
    }

    public static void addActivityToBag(JClicProject jClicProject, String string) throws Exception {
        ActivityBag activityBag = jClicProject.activityBag;
        String string2 = FileSystem.stdFn(string);
        if (activityBag.getElementByName(string2) != null) {
            return;
        }
        Clic3Activity clic3Activity = new Clic3Activity(jClicProject);
        try {
            clic3Activity.load(string2, jClicProject.getFileSystem().getBytes(string2));
        }
        catch (Exception exception) {
            System.err.println("Error loading " + string2 + "\n" + exception);
            throw exception;
        }
        switch (clic3Activity.actMode) {
            case 3: {
                switch (clic3Activity.puzMode) {
                    case 3: {
                        clic3Activity.className = "edu.xtec.jclic.activities.panels.InformationScreen";
                        break;
                    }
                    case 0: {
                        clic3Activity.className = "edu.xtec.jclic.activities.associations.SimpleAssociation";
                        break;
                    }
                    case 1: {
                        clic3Activity.className = "edu.xtec.jclic.activities.associations.ComplexAssociation";
                        break;
                    }
                    case 4: {
                        clic3Activity.className = "edu.xtec.jclic.activities.panels.Identify";
                        break;
                    }
                    case 2: {
                        clic3Activity.className = "edu.xtec.jclic.activities.panels.Explore";
                        break;
                    }
                    case 5: {
                        clic3Activity.className = "edu.xtec.jclic.activities.text.WrittenAnswer";
                    }
                }
                break;
            }
            case 1: {
                switch (clic3Activity.puzMode) {
                    case 0: {
                        clic3Activity.className = "edu.xtec.jclic.activities.puzzles.ExchangePuzzle";
                        break;
                    }
                    case 2: {
                        clic3Activity.className = "edu.xtec.jclic.activities.puzzles.DoublePuzzle";
                        break;
                    }
                    case 3: {
                        clic3Activity.className = "edu.xtec.jclic.activities.memory.MemoryGame";
                        break;
                    }
                    case 1: {
                        clic3Activity.className = "edu.xtec.jclic.activities.puzzles.HolePuzzle";
                    }
                }
                break;
            }
            case 2: {
                clic3Activity.className = "edu.xtec.jclic.activities.textGrid.WordSearch";
                break;
            }
            case 4: {
                clic3Activity.className = "edu.xtec.jclic.activities.textGrid.CrossWord";
                break;
            }
            case 5: {
                switch (clic3Activity.puzMode) {
                    case 0: {
                        clic3Activity.className = "edu.xtec.jclic.activities.text.FillInBlanks";
                        break;
                    }
                    case 1: {
                        clic3Activity.className = "edu.xtec.jclic.activities.text.Complete";
                        break;
                    }
                    case 2: 
                    case 3: {
                        clic3Activity.className = "edu.xtec.jclic.activities.text.Identify";
                        break;
                    }
                    case 4: 
                    case 5: {
                        clic3Activity.className = "edu.xtec.jclic.activities.text.Order";
                    }
                }
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown Clic3 activity!");
            }
        }
        activityBag.addActivity(Activity.getActivity(clic3Activity, jClicProject));
        jClicProject.mediaBag.clearData();
        if (++gcCounter % 50 == 0) {
            System.gc();
        }
    }

    public static void addPacToSequence(JClicProject jClicProject, String string) throws Exception {
        String string2 = FileSystem.stdFn(string);
        if (jClicProject.activitySequence.getElementByTag(string2, false) != null) {
            return;
        }
        FileSystem fileSystem = jClicProject.getFileSystem();
        Clic3Pac clic3Pac = new Clic3Pac();
        try {
            clic3Pac.load(string2, fileSystem.getBytes(string2));
        }
        catch (Exception exception) {
            System.err.println("Error loading " + string2 + "\n" + exception);
            throw exception;
        }
        int n = 0;
        while (n < clic3Pac.nActs) {
            ActivitySequenceElement activitySequenceElement = new ActivitySequenceElement(clic3Pac.acts[n], clic3Pac.lapToPass, clic3Pac.noPassButtons ? 0 : 3);
            if (n == 0) {
                activitySequenceElement.backJump = new ActivitySequenceJump(1);
                activitySequenceElement.setTag(string2);
                activitySequenceElement.setDescription(clic3Pac.fileDesc != null && clic3Pac.fileDesc.length() > 0 ? clic3Pac.fileDesc : null);
            }
            if (n == clic3Pac.nActs - 1) {
                ActivitySequenceJump activitySequenceJump = new ActivitySequenceJump(1);
                if (clic3Pac.def && clic3Pac.chDef != null && Clic3.getExt(clic3Pac.chDef) == 8) {
                    activitySequenceJump.action = 0;
                    activitySequenceJump.sequence = fileSystem.getCanonicalNameOf(clic3Pac.chDef);
                    if (clic3Pac.sup) {
                        activitySequenceJump.setConditionalJump(new ConditionalJumpInfo(0, fileSystem.getCanonicalNameOf(clic3Pac.chSup), clic3Pac.supP, clic3Pac.supTFlag ? clic3Pac.supT : -1), true);
                    }
                    if (clic3Pac.inf) {
                        activitySequenceJump.setConditionalJump(new ConditionalJumpInfo(0, fileSystem.getCanonicalNameOf(clic3Pac.chInf), clic3Pac.infP, clic3Pac.infTFlag ? clic3Pac.infT : -1), false);
                    }
                }
                activitySequenceElement.fwdJump = activitySequenceJump;
            }
            jClicProject.activitySequence.add(activitySequenceElement);
            ++n;
        }
    }

    public static String bufferToString(byte[] byArray) {
        if (byArray == null || byArray.length == 0) {
            return BLANK;
        }
        char[] cArray = new char[byArray.length];
        int n = 0;
        while (n < byArray.length) {
            int n2 = byArray[n] & 0xFF;
            cArray[n] = n2 < 128 || n2 >= 160 ? (char)n2 : ansiChars.charAt(n2 - 128);
            ++n;
        }
        return new String(cArray);
    }

    /*
     * Unable to fully structure code
     */
    public static String[] dataToArray(byte[] var0) {
        block10: {
            var1_1 = new Vector<String>();
            var10_2 = 0;
            var5_3 = var0.length;
            var2_4 = 0;
            var3_5 = 0;
            break block10;
            while (var0[var3_5] != 13 && var0[var3_5] != 10) {
                ++var3_5;
lbl9:
                // 2 sources

                ** while (var3_5 >= var5_3)
lbl10:
                // 1 sources

            }
lbl11:
            // 2 sources

            if ((var6_7 = var3_5 - var2_4) > 0) {
                var7_8 = new byte[var6_7];
                var4_6 = 0;
                while (var4_6 < var6_7) {
                    var7_8[var4_6] = var0[var2_4 + var4_6];
                    ++var4_6;
                }
                var1_1.add(Clic3.bufferToString(var7_8));
            } else {
                var1_1.add("");
            }
            ++var10_2;
            if (var3_5 >= var5_3 || var0[++var3_5] == 10) {
                // empty if block
            }
            var2_4 = ++var3_5;
        }
        if (var2_4 < var5_3) ** GOTO lbl9
        if (var10_2 > 0) {
            var9_9 = new String[var10_2];
            try {
                var9_9 = var1_1.toArray(var9_9);
            }
            catch (ArrayStoreException var11_10) {
                var9_9 = null;
            }
        } else {
            var9_9 = null;
        }
        return var9_9;
    }

    public static String validFileName(String string, boolean bl, boolean bl2) {
        if (string == null) {
            return null;
        }
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        while (n < string.length()) {
            int n2 = string.charAt(n);
            if (validFileChars.indexOf(n2, bl ? 3 : 0) < 0) {
                int n3;
                n2 = n2 >= 65 && n2 <= 90 ? (int)Character.toLowerCase((char)n2) : (n2 == 47 ? 92 : ((n3 = ansiChars.indexOf(n2)) >= 0 ? (int)convertFileChars.charAt(n3) : 95));
            }
            stringBuffer.append((char)n2);
            ++n;
        }
        String string2 = stringBuffer.substring(0);
        if (bl2 && !string2.equals(string)) {
            FileSystem.altFileNames.put(string2, string);
        }
        return string2;
    }

    public static String validFileName(String string) {
        return Clic3.validFileName(string, false, true);
    }

    public static final String pacNameToLowerCase(String string) {
        String string2;
        String string3 = string;
        if (string != null && ((string2 = string.toLowerCase()).endsWith(".pac") || string2.endsWith(".pcc"))) {
            string3 = string2;
        }
        return string3;
    }
}

