/*
 * Decompiled with CFR 0.152.
 */
package org.tritonus.share.sampled;

import java.util.ArrayList;
import java.util.Random;
import javax.sound.sampled.AudioFormat;

public class FloatSampleBuffer {
    private static final boolean LAZY_DEFAULT = true;
    private ArrayList channels = new ArrayList();
    private int sampleCount = 0;
    private int channelCount = 0;
    private float sampleRate = 0.0f;
    private int originalFormatType = 0;
    public static final int DITHER_MODE_AUTOMATIC = 0;
    public static final int DITHER_MODE_ON = 1;
    public static final int DITHER_MODE_OFF = 2;
    private static Random random = null;
    private float ditherBits = 0.8f;
    private boolean doDither = false;
    private int ditherMode = 0;
    private static final int F_8 = 1;
    private static final int F_16 = 2;
    private static final int F_24 = 3;
    private static final int F_32 = 4;
    private static final int F_SAMPLE_WIDTH_MASK = 7;
    private static final int F_SIGNED = 8;
    private static final int F_BIGENDIAN = 16;
    private static final int CT_8S = 9;
    private static final int CT_8U = 1;
    private static final int CT_16SB = 26;
    private static final int CT_16SL = 10;
    private static final int CT_24SB = 27;
    private static final int CT_24SL = 11;
    private static final int CT_32SB = 28;
    private static final int CT_32SL = 12;
    private static final float twoPower7 = 128.0f;
    private static final float twoPower15 = 32768.0f;
    private static final float twoPower23 = 8388608.0f;
    private static final float twoPower31 = 2.1474836E9f;
    private static final float invTwoPower7 = 0.0078125f;
    private static final float invTwoPower15 = 3.0517578E-5f;
    private static final float invTwoPower23 = 1.1920929E-7f;
    private static final float invTwoPower31 = 4.656613E-10f;

    public FloatSampleBuffer() {
        this(0, 0, 1.0f);
    }

    public FloatSampleBuffer(int n, int n2, float f) {
        this.init(n, n2, f, true);
    }

    public FloatSampleBuffer(byte[] byArray, int n, int n2, AudioFormat audioFormat) {
        this(audioFormat.getChannels(), n2 / (audioFormat.getSampleSizeInBits() / 8 * audioFormat.getChannels()), audioFormat.getSampleRate());
        this.initFromByteArray(byArray, n, n2, audioFormat);
    }

    protected void init(int n, int n2, float f) {
        this.init(n, n2, f, true);
    }

    protected void init(int n, int n2, float f, boolean bl) {
        if (n < 0 || n2 < 0) {
            throw new IllegalArgumentException("Invalid parameters in initialization of FloatSampleBuffer.");
        }
        this.setSampleRate(f);
        if (this.getSampleCount() != n2 || this.getChannelCount() != n) {
            this.createChannels(n, n2, bl);
        }
    }

    private void createChannels(int n, int n2, boolean bl) {
        this.sampleCount = n2;
        this.channelCount = 0;
        int n3 = 0;
        while (n3 < n) {
            this.insertChannel(n3, false, bl);
            ++n3;
        }
        if (!bl) {
            while (this.channels.size() > n) {
                this.channels.remove(this.channels.size() - 1);
            }
        }
    }

    public void initFromByteArray(byte[] byArray, int n, int n2, AudioFormat audioFormat) {
        this.initFromByteArray(byArray, n, n2, audioFormat, true);
    }

    public void initFromByteArray(byte[] byArray, int n, int n2, AudioFormat audioFormat, boolean bl) {
        int n3;
        if (n + n2 > byArray.length) {
            throw new IllegalArgumentException("FloatSampleBuffer.initFromByteArray: buffer too small.");
        }
        boolean bl2 = audioFormat.getEncoding().equals(AudioFormat.Encoding.PCM_SIGNED);
        if (!bl2 && !audioFormat.getEncoding().equals(AudioFormat.Encoding.PCM_UNSIGNED)) {
            throw new IllegalArgumentException("FloatSampleBuffer: only PCM samples are possible.");
        }
        int n4 = audioFormat.getSampleSizeInBits() / 8;
        int n5 = n4 * audioFormat.getChannels();
        int n6 = n2 / n5;
        this.init(audioFormat.getChannels(), n6, audioFormat.getSampleRate(), bl);
        this.originalFormatType = n3 = this.getFormatType(audioFormat.getSampleSizeInBits(), bl2, audioFormat.isBigEndian());
        int n7 = 0;
        while (n7 < audioFormat.getChannels()) {
            FloatSampleBuffer.convertByteToFloat(byArray, n, n5, n3, this.getChannel(n7), 0, this.sampleCount);
            n += n4;
            ++n7;
        }
    }

    public void initFromFloatSampleBuffer(FloatSampleBuffer floatSampleBuffer) {
        this.init(floatSampleBuffer.getChannelCount(), floatSampleBuffer.getSampleCount(), floatSampleBuffer.getSampleRate());
        int n = 0;
        while (n < this.getChannelCount()) {
            System.arraycopy(floatSampleBuffer.getChannel(n), 0, this.getChannel(n), 0, this.sampleCount);
            ++n;
        }
    }

    public void reset() {
        this.init(0, 0, 1.0f, false);
    }

    public void reset(int n, int n2, float f) {
        this.init(n, n2, f, false);
    }

    public int getByteArrayBufferSize(AudioFormat audioFormat) {
        if (!audioFormat.getEncoding().equals(AudioFormat.Encoding.PCM_SIGNED) && !audioFormat.getEncoding().equals(AudioFormat.Encoding.PCM_UNSIGNED)) {
            throw new IllegalArgumentException("FloatSampleBuffer: only PCM samples are possible.");
        }
        int n = audioFormat.getSampleSizeInBits() / 8;
        int n2 = n * audioFormat.getChannels();
        return n2 * this.getSampleCount();
    }

    public int convertToByteArray(byte[] byArray, int n, AudioFormat audioFormat) {
        int n2 = this.getByteArrayBufferSize(audioFormat);
        if (n + n2 > byArray.length) {
            throw new IllegalArgumentException("FloatSampleBuffer.convertToByteArray: buffer too small.");
        }
        boolean bl = audioFormat.getEncoding().equals(AudioFormat.Encoding.PCM_SIGNED);
        if (!bl && !audioFormat.getEncoding().equals(AudioFormat.Encoding.PCM_UNSIGNED)) {
            throw new IllegalArgumentException("FloatSampleBuffer.convertToByteArray: only PCM samples are allowed.");
        }
        if (audioFormat.getSampleRate() != this.getSampleRate()) {
            throw new IllegalArgumentException("FloatSampleBuffer.convertToByteArray: different samplerates.");
        }
        if (audioFormat.getChannels() != this.getChannelCount()) {
            throw new IllegalArgumentException("FloatSampleBuffer.convertToByteArray: different channel count.");
        }
        int n3 = audioFormat.getSampleSizeInBits() / 8;
        int n4 = n3 * audioFormat.getChannels();
        int n5 = this.getFormatType(audioFormat.getSampleSizeInBits(), bl, audioFormat.isBigEndian());
        int n6 = 0;
        while (n6 < audioFormat.getChannels()) {
            this.convertFloatToByte(this.getChannel(n6), this.sampleCount, byArray, n, n4, n5);
            n += n3;
            ++n6;
        }
        return this.getSampleCount() * n4;
    }

    public byte[] convertToByteArray(AudioFormat audioFormat) {
        byte[] byArray = new byte[this.getByteArrayBufferSize(audioFormat)];
        this.convertToByteArray(byArray, 0, audioFormat);
        return byArray;
    }

    public void changeSampleCount(int n, boolean bl) {
        int n2 = this.getSampleCount();
        if (n2 == n) {
            return;
        }
        Object[] objectArray = null;
        if (bl) {
            objectArray = this.getAllChannels();
        }
        this.init(this.getChannelCount(), n, this.getSampleRate());
        if (bl) {
            int n3 = n < n2 ? n : n2;
            int n4 = 0;
            while (n4 < this.getChannelCount()) {
                float[] fArray = (float[])objectArray[n4];
                float[] fArray2 = this.getChannel(n4);
                if (fArray != fArray2) {
                    System.arraycopy(fArray, 0, fArray2, 0, n3);
                }
                if (n2 < n) {
                    int n5 = n2;
                    while (n5 < n) {
                        fArray2[n5] = 0.0f;
                        ++n5;
                    }
                }
                ++n4;
            }
        }
    }

    public void makeSilence() {
        if (this.getChannelCount() > 0) {
            this.makeSilence(0);
            int n = 1;
            while (n < this.getChannelCount()) {
                this.copyChannel(0, n);
                ++n;
            }
        }
    }

    public void makeSilence(int n) {
        float[] fArray = this.getChannel(0);
        int n2 = 0;
        while (n2 < this.getSampleCount()) {
            fArray[n2] = 0.0f;
            ++n2;
        }
    }

    public void addChannel(boolean bl) {
        this.insertChannel(this.getChannelCount(), bl);
    }

    public void insertChannel(int n, boolean bl) {
        this.insertChannel(n, bl, true);
    }

    public void insertChannel(int n, boolean bl, boolean bl2) {
        int n2 = this.channels.size();
        int n3 = this.getChannelCount();
        float[] fArray = null;
        if (n2 > n3) {
            int n4 = n3;
            while (n4 < n2) {
                float[] fArray2 = (float[])this.channels.get(n4);
                if (bl2 && fArray2.length >= this.getSampleCount() || !bl2 && fArray2.length == this.getSampleCount()) {
                    fArray = fArray2;
                    this.channels.remove(n4);
                    break;
                }
                ++n4;
            }
        }
        if (fArray == null) {
            fArray = new float[this.getSampleCount()];
        }
        this.channels.add(n, fArray);
        ++this.channelCount;
        if (bl) {
            this.makeSilence(n);
        }
    }

    public void removeChannel(int n) {
        this.removeChannel(n, true);
    }

    public void removeChannel(int n, boolean bl) {
        if (!bl) {
            this.channels.remove(n);
        } else if (n < this.getChannelCount() - 1) {
            this.channels.add(this.channels.remove(n));
        }
        --this.channelCount;
    }

    public void copyChannel(int n, int n2) {
        float[] fArray = this.getChannel(n);
        float[] fArray2 = this.getChannel(n2);
        System.arraycopy(fArray, 0, fArray2, 0, this.getSampleCount());
    }

    public void copy(int n, int n2, int n3) {
        int n4 = 0;
        while (n4 < this.getChannelCount()) {
            this.copy(n4, n, n2, n3);
            ++n4;
        }
    }

    public void copy(int n, int n2, int n3, int n4) {
        float[] fArray = this.getChannel(n);
        int n5 = this.getSampleCount();
        if (n2 + n4 > n5 || n3 + n4 > n5 || n2 < 0 || n3 < 0 || n4 < 0) {
            throw new IndexOutOfBoundsException("parameters exceed buffer size");
        }
        System.arraycopy(fArray, n2, fArray, n3, n4);
    }

    public void expandChannel(int n) {
        if (this.getChannelCount() != 1) {
            throw new IllegalArgumentException("FloatSampleBuffer: can only expand channels for mono signals.");
        }
        int n2 = 1;
        while (n2 < n) {
            this.addChannel(false);
            this.copyChannel(0, n2);
            ++n2;
        }
    }

    public void mixDownChannels() {
        float[] fArray = this.getChannel(0);
        int n = this.getSampleCount();
        int n2 = this.getChannelCount();
        int n3 = n2 - 1;
        while (n3 > 0) {
            float[] fArray2 = this.getChannel(n3);
            int n4 = 0;
            while (n4 < n) {
                int n5 = n4;
                fArray[n5] = fArray[n5] + fArray2[n4];
                ++n4;
            }
            this.removeChannel(n3);
            --n3;
        }
    }

    public void setSamplesFromBytes(byte[] byArray, int n, AudioFormat audioFormat, int n2, int n3) {
        int n4 = (audioFormat.getSampleSizeInBits() + 7) / 8;
        int n5 = n4 * audioFormat.getChannels();
        if (n + n3 * n5 > byArray.length) {
            throw new IllegalArgumentException("FloatSampleBuffer.setSamplesFromBytes: srcBuffer too small.");
        }
        if (n2 + n3 > this.getSampleCount()) {
            throw new IllegalArgumentException("FloatSampleBuffer.setSamplesFromBytes: destBuffer too small.");
        }
        boolean bl = audioFormat.getEncoding().equals(AudioFormat.Encoding.PCM_SIGNED);
        boolean bl2 = audioFormat.getEncoding().equals(AudioFormat.Encoding.PCM_UNSIGNED);
        if (!bl && !bl2) {
            throw new IllegalArgumentException("FloatSampleBuffer: only PCM samples are possible.");
        }
        int n6 = this.getFormatType(audioFormat.getSampleSizeInBits(), bl, audioFormat.isBigEndian());
        int n7 = 0;
        while (n7 < audioFormat.getChannels()) {
            FloatSampleBuffer.convertByteToFloat(byArray, n, n5, n6, this.getChannel(n7), n2, n3);
            n += n4;
            ++n7;
        }
    }

    public int getChannelCount() {
        return this.channelCount;
    }

    public int getSampleCount() {
        return this.sampleCount;
    }

    public float getSampleRate() {
        return this.sampleRate;
    }

    public void setSampleRate(float f) {
        if (f <= 0.0f) {
            throw new IllegalArgumentException("Invalid samplerate for FloatSampleBuffer.");
        }
        this.sampleRate = f;
    }

    public float[] getChannel(int n) {
        if (n < 0 || n >= this.getChannelCount()) {
            throw new IllegalArgumentException("FloatSampleBuffer: invalid channel number.");
        }
        return (float[])this.channels.get(n);
    }

    public Object[] getAllChannels() {
        Object[] objectArray = new Object[this.getChannelCount()];
        int n = 0;
        while (n < this.getChannelCount()) {
            objectArray[n] = this.getChannel(n);
            ++n;
        }
        return objectArray;
    }

    public void setDitherBits(float f) {
        if (f <= 0.0f) {
            throw new IllegalArgumentException("DitherBits must be greater than 0");
        }
        this.ditherBits = f;
    }

    public float getDitherBits() {
        return this.ditherBits;
    }

    public void setDitherMode(int n) {
        if (n != 0 && n != 1 && n != 2) {
            throw new IllegalArgumentException("Illegal DitherMode");
        }
        this.ditherMode = n;
    }

    public int getDitherMode() {
        return this.ditherMode;
    }

    public int getFormatType(int n, boolean bl, boolean bl2) {
        int n2 = n / 8;
        int n3 = 0;
        if (n == 8) {
            n3 = 1;
        } else if (n == 16) {
            n3 = 2;
        } else if (n == 24) {
            n3 = 3;
        } else if (n == 32) {
            n3 = 4;
        }
        if (n3 == 0) {
            throw new IllegalArgumentException("FloatSampleBuffer: unsupported sample size of " + n + " bits per sample.");
        }
        if (!bl && n2 > 1) {
            throw new IllegalArgumentException("FloatSampleBuffer: unsigned samples larger than 8 bit are not supported");
        }
        if (bl) {
            n3 |= 8;
        }
        if (bl2 && n != 8) {
            n3 |= 0x10;
        }
        return n3;
    }

    private static void convertByteToFloat(byte[] byArray, int n, int n2, int n3, float[] fArray, int n4, int n5) {
        int n6 = n4 + n5;
        int n7 = n4;
        while (n7 < n6) {
            switch (n3) {
                case 9: {
                    fArray[n7] = (float)byArray[n] * 0.0078125f;
                    break;
                }
                case 1: {
                    fArray[n7] = (float)((byArray[n] & 0xFF) - 128) * 0.0078125f;
                    break;
                }
                case 26: {
                    fArray[n7] = (float)(byArray[n] << 8 | byArray[n + 1] & 0xFF) * 3.0517578E-5f;
                    break;
                }
                case 10: {
                    fArray[n7] = (float)(byArray[n + 1] << 8 | byArray[n] & 0xFF) * 3.0517578E-5f;
                    break;
                }
                case 27: {
                    fArray[n7] = (float)(byArray[n] << 16 | (byArray[n + 1] & 0xFF) << 8 | byArray[n + 2] & 0xFF) * 1.1920929E-7f;
                    break;
                }
                case 11: {
                    fArray[n7] = (float)(byArray[n + 2] << 16 | (byArray[n + 1] & 0xFF) << 8 | byArray[n] & 0xFF) * 1.1920929E-7f;
                    break;
                }
                case 28: {
                    fArray[n7] = (float)(byArray[n] << 24 | (byArray[n + 1] & 0xFF) << 16 | (byArray[n + 2] & 0xFF) << 8 | byArray[n + 3] & 0xFF) * 4.656613E-10f;
                    break;
                }
                case 12: {
                    fArray[n7] = (float)(byArray[n + 3] << 24 | (byArray[n + 2] & 0xFF) << 16 | (byArray[n + 1] & 0xFF) << 8 | byArray[n] & 0xFF) * 4.656613E-10f;
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unsupported formatType=" + n3);
                }
            }
            n += n2;
            ++n7;
        }
    }

    protected byte quantize8(float f) {
        if (this.doDither) {
            f += random.nextFloat() * this.ditherBits;
        }
        if (f >= 127.0f) {
            return 127;
        }
        if (f <= -128.0f) {
            return -128;
        }
        return f < 0.0f ? (byte)(f - 0.5f) : (byte)(f + 0.5f);
    }

    protected int quantize16(float f) {
        if (this.doDither) {
            f += random.nextFloat() * this.ditherBits;
        }
        if (f >= 32767.0f) {
            return Short.MAX_VALUE;
        }
        if (f <= -32768.0f) {
            return Short.MIN_VALUE;
        }
        return f < 0.0f ? (int)(f - 0.5f) : (int)(f + 0.5f);
    }

    protected int quantize24(float f) {
        if (this.doDither) {
            f += random.nextFloat() * this.ditherBits;
        }
        if (f >= 8388607.0f) {
            return 0x7FFFFF;
        }
        if (f <= -8388608.0f) {
            return -8388608;
        }
        return f < 0.0f ? (int)(f - 0.5f) : (int)(f + 0.5f);
    }

    protected int quantize32(float f) {
        if (this.doDither) {
            f += random.nextFloat() * this.ditherBits;
        }
        if (f >= 2.1474836E9f) {
            return Integer.MAX_VALUE;
        }
        if (f <= -2.1474836E9f) {
            return Integer.MIN_VALUE;
        }
        return f < 0.0f ? (int)(f - 0.5f) : (int)(f + 0.5f);
    }

    private void convertFloatToByte(float[] fArray, int n, byte[] byArray, int n2, int n3, int n4) {
        switch (this.ditherMode) {
            case 0: {
                this.doDither = (this.originalFormatType & 7) > (n4 & 7);
                break;
            }
            case 1: {
                this.doDither = true;
                break;
            }
            case 2: {
                this.doDither = false;
            }
        }
        if (this.doDither && random == null) {
            random = new Random();
        }
        int n5 = 0;
        while (n5 < n) {
            switch (n4) {
                case 9: {
                    byArray[n2] = this.quantize8(fArray[n5] * 128.0f);
                    break;
                }
                case 1: {
                    byArray[n2] = (byte)(this.quantize8(fArray[n5] * 128.0f) + 128);
                    break;
                }
                case 26: {
                    int n6 = this.quantize16(fArray[n5] * 32768.0f);
                    byArray[n2] = (byte)(n6 >> 8);
                    byArray[n2 + 1] = (byte)(n6 & 0xFF);
                    break;
                }
                case 10: {
                    int n6 = this.quantize16(fArray[n5] * 32768.0f);
                    byArray[n2 + 1] = (byte)(n6 >> 8);
                    byArray[n2] = (byte)(n6 & 0xFF);
                    break;
                }
                case 27: {
                    int n6 = this.quantize24(fArray[n5] * 8388608.0f);
                    byArray[n2] = (byte)(n6 >> 16);
                    byArray[n2 + 1] = (byte)(n6 >>> 8 & 0xFF);
                    byArray[n2 + 2] = (byte)(n6 & 0xFF);
                    break;
                }
                case 11: {
                    int n6 = this.quantize24(fArray[n5] * 8388608.0f);
                    byArray[n2 + 2] = (byte)(n6 >> 16);
                    byArray[n2 + 1] = (byte)(n6 >>> 8 & 0xFF);
                    byArray[n2] = (byte)(n6 & 0xFF);
                    break;
                }
                case 28: {
                    int n6 = this.quantize32(fArray[n5] * 2.1474836E9f);
                    byArray[n2] = (byte)(n6 >> 24);
                    byArray[n2 + 1] = (byte)(n6 >>> 16 & 0xFF);
                    byArray[n2 + 2] = (byte)(n6 >>> 8 & 0xFF);
                    byArray[n2 + 3] = (byte)(n6 & 0xFF);
                    break;
                }
                case 12: {
                    int n6 = this.quantize32(fArray[n5] * 2.1474836E9f);
                    byArray[n2 + 3] = (byte)(n6 >> 24);
                    byArray[n2 + 2] = (byte)(n6 >>> 16 & 0xFF);
                    byArray[n2 + 1] = (byte)(n6 >>> 8 & 0xFF);
                    byArray[n2] = (byte)(n6 & 0xFF);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unsupported formatType=" + n4);
                }
            }
            n2 += n3;
            ++n5;
        }
    }

    private static String formatType2Str(int n) {
        String string = "" + n + ": ";
        switch (n & 7) {
            case 1: {
                string = string + "8bit";
                break;
            }
            case 2: {
                string = string + "16bit";
                break;
            }
            case 3: {
                string = string + "24bit";
                break;
            }
            case 4: {
                string = string + "32bit";
            }
        }
        string = string + ((n & 8) == 8 ? " signed" : " unsigned");
        if ((n & 7) != 1) {
            string = string + ((n & 0x10) == 16 ? " big endian" : " little endian");
        }
        return string;
    }
}

