/*
 * Decompiled with CFR 0.152.
 */
package org.jdom.output;

import java.util.Iterator;
import org.jdom.Attribute;
import org.jdom.CDATA;
import org.jdom.Comment;
import org.jdom.Content;
import org.jdom.DocType;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.EntityRef;
import org.jdom.JDOMException;
import org.jdom.Namespace;
import org.jdom.ProcessingInstruction;
import org.jdom.Text;
import org.jdom.adapters.DOMAdapter;
import org.jdom.output.NamespaceStack;
import org.w3c.dom.Attr;
import org.w3c.dom.Node;

public class DOMOutputter {
    private static final String CVS_ID = "@(#) $RCSfile: DOMOutputter.java,v $ $Revision: 1.41 $ $Date: 2004/09/03 06:03:42 $ $Name: jdom_1_0 $";
    private static final String DEFAULT_ADAPTER_CLASS = "org.jdom.adapters.XercesDOMAdapter";
    private String adapterClass;

    public DOMOutputter() {
    }

    public DOMOutputter(String string) {
        this.adapterClass = string;
    }

    public org.w3c.dom.Document output(Document document) throws JDOMException {
        NamespaceStack namespaceStack = new NamespaceStack();
        org.w3c.dom.Document document2 = null;
        try {
            DocType docType = document.getDocType();
            document2 = this.createDOMDocument(docType);
            Iterator iterator = document.getContent().iterator();
            while (iterator.hasNext()) {
                Node node;
                Content content;
                Object e = iterator.next();
                if (e instanceof Element) {
                    content = (Element)e;
                    node = this.output((Element)content, document2, namespaceStack);
                    org.w3c.dom.Element element = document2.getDocumentElement();
                    if (element == null) {
                        document2.appendChild(node);
                        continue;
                    }
                    document2.replaceChild(node, element);
                    continue;
                }
                if (e instanceof Comment) {
                    content = (Comment)e;
                    node = document2.createComment(((Comment)content).getText());
                    document2.appendChild(node);
                    continue;
                }
                if (e instanceof ProcessingInstruction) {
                    content = (ProcessingInstruction)e;
                    node = document2.createProcessingInstruction(((ProcessingInstruction)content).getTarget(), ((ProcessingInstruction)content).getData());
                    document2.appendChild(node);
                    continue;
                }
                if (e instanceof DocType) continue;
                throw new JDOMException("Document contained top-level content with type:" + e.getClass().getName());
            }
        }
        catch (Throwable throwable) {
            throw new JDOMException("Exception outputting Document", throwable);
        }
        return document2;
    }

    private org.w3c.dom.Document createDOMDocument(DocType docType) throws JDOMException {
        if (this.adapterClass != null) {
            try {
                DOMAdapter dOMAdapter = (DOMAdapter)Class.forName(this.adapterClass).newInstance();
                return dOMAdapter.createDocument(docType);
            }
            catch (ClassNotFoundException classNotFoundException) {
            }
            catch (IllegalAccessException illegalAccessException) {
            }
            catch (InstantiationException instantiationException) {}
        } else {
            try {
                DOMAdapter dOMAdapter = (DOMAdapter)Class.forName("org.jdom.adapters.JAXPDOMAdapter").newInstance();
                return dOMAdapter.createDocument(docType);
            }
            catch (ClassNotFoundException classNotFoundException) {
            }
            catch (IllegalAccessException illegalAccessException) {
            }
            catch (InstantiationException instantiationException) {
                // empty catch block
            }
        }
        try {
            DOMAdapter dOMAdapter = (DOMAdapter)Class.forName(DEFAULT_ADAPTER_CLASS).newInstance();
            return dOMAdapter.createDocument(docType);
        }
        catch (ClassNotFoundException classNotFoundException) {
        }
        catch (IllegalAccessException illegalAccessException) {
        }
        catch (InstantiationException instantiationException) {
            // empty catch block
        }
        throw new JDOMException("No JAXP or default parser available");
    }

    private org.w3c.dom.Element output(Element element, org.w3c.dom.Document document, NamespaceStack namespaceStack) throws JDOMException {
        try {
            String string;
            Object object;
            Object object2;
            Object object3;
            Iterator iterator;
            int n = namespaceStack.size();
            org.w3c.dom.Element element2 = null;
            element2 = element.getNamespace() == Namespace.NO_NAMESPACE ? document.createElement(element.getQualifiedName()) : document.createElementNS(element.getNamespaceURI(), element.getQualifiedName());
            Namespace namespace = element.getNamespace();
            if (namespace != Namespace.XML_NAMESPACE && (namespace != Namespace.NO_NAMESPACE || namespaceStack.getURI("") != null)) {
                iterator = namespace.getPrefix();
                object3 = namespaceStack.getURI((String)((Object)iterator));
                if (!namespace.getURI().equals(object3)) {
                    namespaceStack.push(namespace);
                    object2 = DOMOutputter.getXmlnsTagFor(namespace);
                    element2.setAttribute((String)object2, namespace.getURI());
                }
            }
            iterator = element.getAdditionalNamespaces().iterator();
            while (iterator.hasNext()) {
                object3 = (Namespace)iterator.next();
                object2 = ((Namespace)object3).getPrefix();
                object = namespaceStack.getURI((String)object2);
                if (((Namespace)object3).getURI().equals(object)) continue;
                string = DOMOutputter.getXmlnsTagFor((Namespace)object3);
                element2.setAttribute(string, ((Namespace)object3).getURI());
                namespaceStack.push((Namespace)object3);
            }
            iterator = element.getAttributes().iterator();
            while (iterator.hasNext()) {
                object3 = (Attribute)iterator.next();
                element2.setAttributeNode(this.output((Attribute)object3, document));
                object2 = ((Attribute)object3).getNamespace();
                if (object2 != Namespace.NO_NAMESPACE && object2 != Namespace.XML_NAMESPACE) {
                    object = ((Namespace)object2).getPrefix();
                    string = namespaceStack.getURI((String)object);
                    if (!((Namespace)object2).getURI().equals(string)) {
                        String string2 = DOMOutputter.getXmlnsTagFor((Namespace)object2);
                        element2.setAttribute(string2, ((Namespace)object2).getURI());
                        namespaceStack.push((Namespace)object2);
                    }
                }
                if (((Attribute)object3).getNamespace() == Namespace.NO_NAMESPACE) {
                    element2.setAttribute(((Attribute)object3).getQualifiedName(), ((Attribute)object3).getValue());
                    continue;
                }
                element2.setAttributeNS(((Attribute)object3).getNamespaceURI(), ((Attribute)object3).getQualifiedName(), ((Attribute)object3).getValue());
            }
            iterator = element.getContent().iterator();
            while (iterator.hasNext()) {
                object3 = iterator.next();
                if (object3 instanceof Element) {
                    object2 = (Element)object3;
                    object = this.output((Element)object2, document, namespaceStack);
                    element2.appendChild((Node)object);
                    continue;
                }
                if (object3 instanceof String) {
                    object2 = (String)object3;
                    object = document.createTextNode((String)object2);
                    element2.appendChild((Node)object);
                    continue;
                }
                if (object3 instanceof CDATA) {
                    object2 = (CDATA)object3;
                    object = document.createCDATASection(((Text)object2).getText());
                    element2.appendChild((Node)object);
                    continue;
                }
                if (object3 instanceof Text) {
                    object2 = (Text)object3;
                    object = document.createTextNode(((Text)object2).getText());
                    element2.appendChild((Node)object);
                    continue;
                }
                if (object3 instanceof Comment) {
                    object2 = (Comment)object3;
                    object = document.createComment(((Comment)object2).getText());
                    element2.appendChild((Node)object);
                    continue;
                }
                if (object3 instanceof ProcessingInstruction) {
                    object2 = (ProcessingInstruction)object3;
                    object = document.createProcessingInstruction(((ProcessingInstruction)object2).getTarget(), ((ProcessingInstruction)object2).getData());
                    element2.appendChild((Node)object);
                    continue;
                }
                if (object3 instanceof EntityRef) {
                    object2 = (EntityRef)object3;
                    object = document.createEntityReference(((EntityRef)object2).getName());
                    element2.appendChild((Node)object);
                    continue;
                }
                throw new JDOMException("Element contained content with type:" + object3.getClass().getName());
            }
            while (namespaceStack.size() > n) {
                namespaceStack.pop();
            }
            return element2;
        }
        catch (Exception exception) {
            throw new JDOMException("Exception outputting Element " + element.getQualifiedName(), exception);
        }
    }

    private Attr output(Attribute attribute, org.w3c.dom.Document document) throws JDOMException {
        Attr attr = null;
        try {
            attr = attribute.getNamespace() == Namespace.NO_NAMESPACE ? document.createAttribute(attribute.getQualifiedName()) : document.createAttributeNS(attribute.getNamespaceURI(), attribute.getQualifiedName());
            attr.setValue(attribute.getValue());
        }
        catch (Exception exception) {
            throw new JDOMException("Exception outputting Attribute " + attribute.getQualifiedName(), exception);
        }
        return attr;
    }

    private static String getXmlnsTagFor(Namespace namespace) {
        String string = "xmlns";
        if (!namespace.getPrefix().equals("")) {
            string = string + ":";
            string = string + namespace.getPrefix();
        }
        return string;
    }
}

